<?php
$pieChartMaterials = [];
?>



<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('layouts.partial.notice', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="main-content-container container-fluid px-4">
        <!-- Page Header -->
        <div class="page-header row no-gutters py-4">
            <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
                <span class="text-uppercase page-subtitle">Overview</span>
                <h3 class="page-title"><?php echo e($pageData['pageName']); ?> List</h3>
            </div>
            <div class="float-right col-12 col-sm-8 text-center text-sm-right">
                <span class="text-uppercase page-subtitle">Action</span>
                <h3 class="page-title">
                    <a href="<?php echo e(route($pageData['routeFirstName'].'-create')); ?>" class="btn btn-md btn-white">
                        <i class="material-icons">control_point</i> Add <?php echo e($pageData['pageName']); ?>

                    </a>
                </h3>
            </div>
        </div>


        <div class="row">
            <div class="col-lg-12 mb-3">
                <div id="accordion" style="cursor: pointer">
                    <div class="card card-small mb-1 rounded">

                        <ul class="nav nav-tabs">
                            <li class="nav-item p-1">
                                <select class="select2-box-manual form-control yr-select" name="filterYearChart">
                                    <option value="2015">2015</option>
                                    <option value="2016">2016</option>
                                    <option value="2017">2017</option>
                                    <option value="2018">2018</option>
                                    <option value="2019">2019</option>
                                    <option value="2020">2020</option>
                                    <option value="2021">2021</option>
                                    <option value="2022">2022</option>
                                    <option value="2023">2023</option>
                                    <option value="2024">2024</option>
                                </select>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link active" data-toggle="tab" href="#lc_value">
                                    <b>LC Chart</b>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="tab" href="#bank_acceptance_amount">
                                    <b>Acceptance Chart</b>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="tab" href="#payment_amount">
                                    <b>Payment Chart</b>
                                </a>
                            </li>
                        </ul>


                        <div class="card-header border-bottom rounded">
                            <h6 class="m-0 card-link" data-toggle="collapse" href="#collapseThree">
                                Yearly Chart
                            </h6>

                            <div class="block-handle"></div>

                        </div>
                        <div id="collapseThree" class="collapse show" data-parent="#accordion">

                            <!-- Tab panes -->
                            <div class="tab-content">
                                <div id="lc_value" class="tab-pane active">
                                    <br>
                                    <div class="card-body pt-0">
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item p-2">
                                                <div class="row" style="height: 400px;">
                                                    <div class="col-md-12">
                                                        <div id="columnChart"></div>
                                                    </div>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div id="bank_acceptance_amount" class="tab-pane fade"><br>
                                    <div class="card-body pt-0">
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item p-2">
                                                <div class="row" style="height: 400px;">
                                                    <div class="col-md-12">
                                                        <div id="columnChart2"></div>
                                                    </div>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div id="payment_amount" class="tab-pane fade"><br>
                                    <div class="card-body pt-0">
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item p-2">
                                                <div class="row" style="height: 400px;">
                                                    <div class="col-md-12">
                                                        <div id="columnChart3"></div>
                                                    </div>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="card card-small mb-1">
            <div class="card-header border-bottom rounded">
                <h6 class="m-0 collapsed card-link w-100" data-toggle="collapse" href="#collapseTwo">
                    Commercial Expense Payment Due Summery
                </h6>
                <div class="block-handle"></div>
            </div>
            <div id="collapseTwo" class="collapse" data-parent="#accordion">
                <table class="summary-table text-capitalize">
                    <thead>
                        <?php $__currentLoopData = $commercialExpenseFieldPaymentDueValues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <th><?php echo e($key); ?></th>
                                <th><?php echo e($field); ?></th>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <th class="bg-info text-white">BTB </th>
                            <th class="bg-info text-white"><?php echo e($allCommercialPaymentDue - array_sum($commercialExpenseFieldPaymentDueValues)); ?></th>
                        </tr>
                        <tr>
                            <th class="bg-secondary text-white">Total </th>
                            <th class="bg-secondary text-white"><?php echo e($allCommercialPaymentDue); ?></th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>


        
        <?php echo $__env->make('layouts.tools.filterFormForCommercialReport', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        




        <div class="row">
            <div class="col-lg-12 mb-3">
                <div class="card card-small">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item p-2">
                            <div class="row">
                                <div class="col-md-2">
                                    <b>Total : </b> <span><?php echo e($count); ?> <?php echo e(($count>1)?Str::plural($pageData['pageName']):$pageData['pageName']); ?> Found</span>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col">
                <div class="card card-small mb-4">
                    <div class="card-header border-bottom">
                        
                        <h6 class="m-0">Active <?php echo e(Str::plural($pageData['pageName'])); ?></h6>
                    </div>
                    <div class="card-body p-0 text-center pre-x-scrollable" id="order-table">



                        <!-- Transaction History Table -->
                        <?php echo $__env->make('commercial.table', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <!-- End Transaction History Table -->



                    </div>
                </div>

            </div>
        </div>
    </div>
    <div class="promo-popup animated bounceIn" style="padding: 10px; border: 2px solid #898989; background: rgba(255,255,255,0.82); right: 10px;">

        <div>
            <a href="#accordion">
            <span class="close">
                <i class="material-icons">pie_chart</i>
            </span>
            </a>
        </div>


        <div>
            <a href="#search-area">
            <span class="close">
                <i class="material-icons">format_align_left</i>
            </span>
            </a>
        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vue-script'); ?>






    <?php echo $__env->make('js/script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>

        $('[name="filterYearChart"]').change(function () {
            //alert($(this).val())
            window.location = '?direct=true&filterYearChart='+$(this).val();
        });

        const columnChart = (idName, type, chartTitle, seriesName) => {

            let categories_lc = [
                <?php $__currentLoopData = $monthWiseCommercial['lc'][0]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month => $monthlyOrder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    '<?php echo e($month); ?>',
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ];
            let data_lc = [
                <?php $__currentLoopData = $monthWiseCommercial['lc'][0]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month => $monthlyOrder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e(array_sum($monthWiseCommercial['lc'][1][$month] ?? [])); ?>,
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ]

            let categories_acceptance = [
                <?php $__currentLoopData = $monthWiseCommercial['acceptance'][0]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month => $monthlyOrder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    '<?php echo e($month); ?>',
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ];
            let data_acceptance = [
                <?php $__currentLoopData = $monthWiseCommercial['acceptance'][0]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month => $monthlyOrder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e(array_sum($monthWiseCommercial['acceptance'][1][$month] ?? [])); ?>,
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ]

            let categories_payment = [
                <?php $__currentLoopData = $monthWiseCommercial['payment'][0]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month => $monthlyOrder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    '<?php echo e($month); ?>',
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ];
            let data_payment = [
                <?php $__currentLoopData = $monthWiseCommercial['payment'][0]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month => $monthlyOrder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e(array_sum($monthWiseCommercial['payment'][1][$month] ?? [])); ?>,
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ]



            Highcharts.chart(idName, {

                chart: {
                    type: 'column'
                },

                title: {
                    text: chartTitle
                },

                xAxis: {
                    categories: type === 'lc' ? categories_lc: type === 'acceptance' ? categories_acceptance: type === 'payment' ? categories_payment: [],
                },

                yAxis: [{
                    title: {
                        text: ''
                    },
                    linkedTo: 1,
                    opposite: true
                },
                    {
                        title: {
                            text: seriesName
                        }
                    }],

                plotOptions: {
                    series: {
                        borderWidth: 0,
                        /*dataLabels: {
                            enabled: true,
                            format: '{point.y:.f}'
                        }*/
                    },
                    column: {
                        pointPadding: 0.05,
                        borderRadius: 3
                    }
                },
                series: [{
                    name: '',
                    data: type === 'lc' ? data_lc: type === 'acceptance' ? data_acceptance: type === 'payment' ? data_payment: [],
                    yAxis: 1
                }
                    /*, {
                        name: 'Acceptance Value',
                        data: [
                            1,2,3,4,5,6,7,8,9,10,11,12
                        ],
                        yAxis: 1
                    }, {
                        name: 'Maturity Value',
                        data: [
                            1,2,3,4,5,6,7,8,9,10,11,12
                        ],
                        yAxis: 1
                    }*/],
                credits: {
                    enabled: false
                },

            });
        }

        columnChart('columnChart',  'lc',           'Monthly LC',          'Value axis');
        columnChart('columnChart2', 'acceptance',   'Monthly acceptance',   'Value axis');
        columnChart('columnChart3', 'payment',      'Monthly payment',      'Value axis');



        function dataTableFooterSum(obj) {
            let tbl = obj.table;
            [7, 9, 11].forEach(function (col) { //10.OrderQty, 12.TotValue, 13.ShipQty, 15.ShipValue, 16.ShortShipVal
                //console.log(tbl.column(col).footer());
                $(tbl.column(col).footer()).html(
                    roundWithFrac(tbl.column(col).data().sum())
                );
            });

            /*custom sum footer*/
            /*let totVal = $(tbl.column(12).footer()).text();
            let totOrdQty = $(tbl.column(10).footer()).text();
            let totCm = $(tbl.column(19).footer()).text();
            let totYrn = $(tbl.column(21).footer()).text();*/

            //console.log(totYrn);
            //console.log(tbl.column(10).footer());

            /*$(tbl.column(11).footer()).html(
                roundWithFrac(totVal/totOrdQty) /!*unit price avr*!/
            );
            $(tbl.column(18).footer()).html(
                roundWithFrac(totCm/totOrdQty * 12)
            );
            $(tbl.column(20).footer()).html(
                roundWithFrac((totYrn * 12) / totOrdQty)
            );*/
            /*custom sum footer*/
        }




    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\rmg_erp\resources\views/commercial/index.blade.php ENDPATH**/ ?>