<table class="main-data-table d-none text-capitalize" id="main-table">
    <thead>
    <tr>
        <th>ID</th>
        <th>Buyer</th>
        <th>OrderName</th>
        <th>Style</th>
        <th>StyleDesc</th>
        <th>Image</th>
        <th>AcceptDate</th>
        <th>ShipmentDate</th>
        <th style="background: #ffd3b0;color: #000;">RemDay</th>
        <th style="background: #f68a8a;color: #000;">OrderQty</th>
        <th>UnitPrice</th>
        <th>TotValue</th>
        <th style="background: #93a8ff;color: #000;">ShipQty</th>
        <th>ShipValue</th>
        <th>ShortShipVal</th>
        <th>Curr TNA</th>
        <th>Status</th>
        <th>CmDz</th>
        <th>CM</th>
        <th>YrnCons</th>
        <th>TotYrn</th>
        <th>SMV</th>
        <th>TotSMV</th>
        {{--<th>LC/Sales</th>--}}
    </tr>
    </thead>
    <tbody>


    @foreach($orders as $order)
        @php


            $lastShipOut = $order->shipment->where('status', 'ShipOut')->first();

            $dateOfShip = $order->date_of_ship;
            $dateForHumans = Carbon::parse($dateOfShip)->diffForHumans($lastShipOut ? $lastShipOut->date : Carbon::now());
            $diff = -Carbon::parse($dateOfShip)->diffInDays($lastShipOut ? $lastShipOut->date : Carbon::now(), false);


            $garmImg = null;

            if ($order->image != '') {

                if (file_exists(public_path('profile-pic/garments/'.$order->image))) {
                    $garmImg = public_path('profile-pic/garments/'.$order->image);
                }

            }



            //dump($garmImg);

            //$delayedShipment = Carbon::parse($dateOfShip)->diffForHumans(Carbon::now());

        @endphp
        <tr>
            {{--Job ID--}}              <td>{{ $order->id }}</td>
            {{--Byuer--}}               <td>{{ $order->buyer->name }}</td>
            {{--order name--}}          <td>{{ $order->name }}</td>
            {{--style name--}}          <td>{{ $order->style }}</td>
            {{--style desc--}}          <td>{{ $order->style_desc }}</td>
            {{--getGarmentsPicture--}}  <td style="color:#fff; border: 1px solid #a62211">@if($garmImg)<img class="zoom" width="50" src="{{ $garmImg }}" alt=""> @else <div class="text-danger">No Image</div> @endif</td>
            {{--Accept Date--}}         <td>{{ $order->order_accept_date }}</td>
            {{--Shipment Date--}}       <td>{{ $dateOfShip }}</td>
            {{--Rem Day--}}             <td style="@if($lastShipOut) color:#56b916; border: 1px solid #e3cd07 @endif"> <div class="badge {{ ($diff<=10)?(($diff<0)?'badge-danger':'badge-warning'):'badge-info' }}">{{ $diff }} Day</div><br> {{ str_replace(['before', 'after'], ['delay', 'remain'], $dateForHumans) }}</td>
            {{--Order Qty--}}           <td>{{ $order->ord_quantity }}</td>
            {{--Unit Price--}}          <td>{{ $order->unit_price }}</td>
            {{--Total Price--}}         <td>{{ $totalValue = $order->ord_quantity*$order->unit_price }}</td>
            {{--Ship Qty--}}            <td>{{ $shipmentQty = $order->shipment->sum('quantity') }}</td>
            {{--Ship value--}}          <td>{{ $shipmentQty*$order->unit_price }}</td>
            {{--Short Ship value--}}    <td>{{ $shipmentQty?$shipmentQty*$order->unit_price-$totalValue:null }}</td>
            {{--Order Status--}}        <td>{{ $order->status->name ?? null }}</td>
            {{--Order Status--}}        <td style="@if($order->statuses=='ShipOut') background: #794d53; color:#fff; @elseif($order->statuses=='Partial') background: #797750; color:#fff; @endif">{{ $lastShipOut ? $lastShipOut->status : $order->statuses }}</td>
            {{--CM from budget table--}}<td>{{ $cm = $order->budget->cm ?? null }}</td>
            {{--CM from budget table--}}<td>{{ round($order->ord_quantity / 12 * $cm, 2) }}</td>
{{--YarnConsumtion from budget table--}}<td>{{ $order->budget->yarn_consumption }}</td>
{{--YarnConsumtion from budget table--}}<td>{{ round(($order->budget->yarn_consumption * $order->ord_quantity)/12, 2) }}</td>
            {{--SMV--}}                 <td>{{ $order->smv }}</td>
            {{--SMV--}}                 <td>{{ $order->ord_quantity * $order->smv }}</td>
            {{--Sales--}}               {{--<td>{{ ucfirst($order->sales_user->name) }}</td>--}}


        </tr>
    @endforeach
    <tr class="bg-dark">
        <td>ID</td>
        <td>Buyer</td>
        <td>OrderName</td>
        <td>Style</td>
        <td>StyleDesc</td>
        <td>Image</td>
        <td>AcceptDate</td>
        <td>ShipmentDate</td>
        <td style="background: #ffd3b0;color: #000;">RemDay</td>
        <td>OrderQty</td>
        <td>UnitPrice</td>
        <td>TotValue</td>
        <td style="background: #93a8ff;color: #000;">ShipQty</td>
        <td>ShipValue</td>
        <td>ShortShipVal</td>
        <td>Curr TNA</td>
        <td>Status</td>
        <td>CmDz</td>
        <td>CM</td>
        <td>YrnCons</td>
        <td>TotYrn</td>
        <td>SMV</td>
        <td>TotSMV</td>
        {{--<th>LC/Sales</th>--}}
    </tr>
    </tbody>
    <tfoot>
    <tr>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th style="background: #93a8ff;color: #000;"></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
    </tr>
    </tfoot>
</table>


