@php
$pieChartMaterials = [];
@endphp

@extends('layouts.master')

@section('content')

    @include('layouts.partial.notice')

    <div class="main-content-container container-fluid px-4">
        <!-- Page Header -->
        <div class="page-header row no-gutters py-4">
            <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
                <span class="text-uppercase page-subtitle">Overview</span>
                <h3 class="page-title">{{ $pageData['pageName'] }} List</h3>
            </div>
            <div class="float-right col-12 col-sm-8 text-center text-sm-right">
                <span class="text-uppercase page-subtitle">Action</span>
                <h3 class="page-title">
                    <a href="{{ route($pageData['routeFirstName'].'-create') }}" class="btn btn-md btn-white">
                        <i class="material-icons">control_point</i> Add {{ $pageData['pageName'] }}
                    </a>
                </h3>
            </div>
        </div>


        <div class="row">
            <div class="col-lg-12 mb-3">
                <div id="accordion" style="cursor: pointer">

                    <div class="card card-small mb-1 rounded">
                        <div class="card-header border-bottom rounded">
                            <h6 class="m-0 card-link" data-toggle="collapse" href="#collapseFour">
                                Pending Summery
                            </h6>
                            <div class="block-handle"></div>
                        </div>
                        <div id="collapseFour" class="collapse show" data-parent="#accordion">
                            <div class="card-body pt-0">
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item p-2">
                                        <div class="row">
                                            @php
                                                $grandTot = [];
                                                $grandTot['qty'] = [];
                                                $grandTot['val'] = [];
                                                $grandTot['ord'] = [];
                                            @endphp

                                            @if(false)
                                                @foreach($allPendingOrder as $ym => $pendingOrds)
                                                <div class="col-12 col-md-4 col-lg-4 mb-4">
                                                    <div class="stats-small card card-small">
                                                        <div class="card-body px-0 pb-0"><div class="chartjs-size-monitor" style="position: absolute; left: 0; top: 0; right: 0; bottom: 0; overflow: hidden; pointer-events: none; visibility: hidden; z-index: -1;"><div class="chartjs-size-monitor-expand" style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;"><div style="position:absolute;width:1000000px;height:1000000px;left:0;top:0"></div></div><div class="chartjs-size-monitor-shrink" style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;"><div style="position:absolute;width:200%;height:200%;left:0; top:0"></div></div></div>
                                                            <div class="px-3">
                                                                <div class="">
                                                                    <span class="mb-1">{{ $ym }} [ {{ Carbon::parse($ym)->shortEnglishMonth }} ]</span>

                                                                    <?php
                                                                    $qtyArr = [];
                                                                    $valArr = [];
                                                                    foreach ($pendingOrds as $pendingOrd){
                                                                        $qty = $pendingOrd->ord_quantity - $pendingOrd->shipment->sum('quantity');
                                                                        $qtyArr[] = $qty;
                                                                        $valArr[] = $pendingOrd->unit_price * $qty;

                                                                        $grandTot['qty'][] = $qty;
                                                                        $grandTot['val'][] = $pendingOrd->unit_price * $qty;
                                                                    }
                                                                    $grandTot['ord'][] = count($pendingOrds) ?? 0;
                                                                    ?>
                                                                    <table class="table table-striped table-bordered">
                                                                        <tr>
                                                                            <th>Ord</th>
                                                                            <th>Qty</th>
                                                                            <th>Value</th>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><b class="text-danger">{{ count($pendingOrds) }}</b></td>
                                                                            <td>{{ array_sum($qtyArr) }}</td>
                                                                            <td>${{ array_sum($valArr) }}</td>
                                                                        </tr>
                                                                    </table>
                                                                </div>
                                                            </div>
                                                            <canvas height="49" class="analytics-overview-stats-small-1 chartjs-render-monitor" width="247" style="display: block; width: 247px; height: 49px;"></canvas>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                            @endif
                                            <div class="col-12 col-md-4 col-lg-4 mb-4">
                                                <div class="stats-small card card-small">
                                                    <div class="card-body px-0 pb-0"><div class="chartjs-size-monitor" style="position: absolute; left: 0; top: 0; right: 0; bottom: 0; overflow: hidden; pointer-events: none; visibility: hidden; z-index: -1;"><div class="chartjs-size-monitor-expand" style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;"><div style="position:absolute;width:1000000px;height:1000000px;left:0;top:0"></div></div><div class="chartjs-size-monitor-shrink" style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;"><div style="position:absolute;width:200%;height:200%;left:0; top:0"></div></div></div>
                                                        <div class="px-3">
                                                            <div class="">
                                                                <span class="mb-1">2022-08 [ Aug ]</span>


                                                                <table class="table table-striped table-bordered">
                                                                    <tr>
                                                                        <th>Ord</th>
                                                                        <th>Qty</th>
                                                                        <th>Value</th>
                                                                    </tr>
                                                                    <tr>
                                                                        <td><b class="text-danger">{{ count([]) }}</b></td>
                                                                        <td>{{ array_sum([0]) }}</td>
                                                                        <td>${{ array_sum([0]) }}</td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                        </div>
                                                        <canvas height="49" class="analytics-overview-stats-small-1 chartjs-render-monitor" width="247" style="display: block; width: 247px; height: 49px;"></canvas>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>




        {{--Star filter form--}}
        @include('layouts.tools.filterFormForCommercialReport')
        {{--End filter form--}}




        <div class="row">
            <div class="col-lg-12 mb-3">
                <div class="card card-small">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item p-2">
                            <div class="row">
                                <div class="col-md-2">
                                    <b>Total : </b> <span>{{ $count }} {{ ($count>1)?Str::plural($pageData['pageName']):$pageData['pageName'] }} Found</span>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col">
                <div class="card card-small mb-4">
                    <div class="card-header border-bottom">
                        {{--From Controller--}}
                        <h6 class="m-0">Active {{ Str::plural($pageData['pageName']) }}</h6>
                    </div>
                    <div class="card-body p-0 text-center pre-x-scrollable" id="order-table">



                        <!-- Transaction History Table -->
                        @include('commercial.table')
                        <!-- End Transaction History Table -->



                    </div>
                </div>

            </div>
        </div>
    </div>
    <div class="promo-popup animated bounceIn" style="padding: 10px; border: 2px solid #898989; background: rgba(255,255,255,0.82); right: 10px;">

        <div>
            <a href="#accordion">
            <span class="close">
                <i class="material-icons">pie_chart</i>
            </span>
            </a>
        </div>


        <div>
            <a href="#search-area">
            <span class="close">
                <i class="material-icons">format_align_left</i>
            </span>
            </a>
        </div>

    </div>
@endsection

@section('vue-script')

{{--start php code--}}

{{--end php code--}}


    @include('js/script')
    <script>

        $('[name="filterYearChart"]').change(function () {
            //alert($(this).val())
            window.location = '?direct=true&filterYearChart='+$(this).val();
        });


        function dataTableFooterSum(obj) {
            let tbl = obj.table;
            [7, 9, 11].forEach(function (col) { //10.OrderQty, 12.TotValue, 13.ShipQty, 15.ShipValue, 16.ShortShipVal
                //console.log(tbl.column(col).footer());
                $(tbl.column(col).footer()).html(
                    roundWithFrac(tbl.column(col).data().sum())
                );
            });

            /*custom sum footer*/
            /*let totVal = $(tbl.column(12).footer()).text();
            let totOrdQty = $(tbl.column(10).footer()).text();
            let totCm = $(tbl.column(19).footer()).text();
            let totYrn = $(tbl.column(21).footer()).text();*/

            //console.log(totYrn);
            //console.log(tbl.column(10).footer());

            /*$(tbl.column(11).footer()).html(
                roundWithFrac(totVal/totOrdQty) /!*unit price avr*!/
            );
            $(tbl.column(18).footer()).html(
                roundWithFrac(totCm/totOrdQty * 12)
            );
            $(tbl.column(20).footer()).html(
                roundWithFrac((totYrn * 12) / totOrdQty)
            );*/
            /*custom sum footer*/
        }




    </script>
@endsection
