@extends('layouts.master')

@section('content')

    @include('layouts.partial.notice')

    <div class="main-content-container container-fluid px-4">
        <!-- Page Header -->
        <div class="page-header row no-gutters py-4">
            <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
                <span class="text-uppercase page-subtitle">Overview</span>
                <h3 class="page-title"> {{ isset($isSetModel)? 'Edit':'Place' }} {{ $pageData['pageName'] }}</h3>
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Default Light Table -->

        @if(isset($isSetModel))
            <form action="{{ route($pageData['routeFirstName'].'-update', $isSetModel->id) }}" method="post" enctype="multipart/form-data">
            @method('PATCH')

                @if(false)
                    {{--For IDE--}} </form> {{--For IDE--}}
                @endif

        @else
            <form action="{{ route($pageData['routeFirstName'].'-store') }}" method="post" enctype="multipart/form-data">
        @endif
            @csrf
            <div class="row">
                <div class="col-lg-6">

                    <div style="display: flex; justify-content: space-between; width: 100%;">

                        @if(isset($isSetModel) && $isSetModel->history_type == 'notApprove')
                            <a href="{{ route($pageData['routeFirstName'].'-approve-order', $isSetModel->id) }}" class="btn btn-lg btn-java">Approve this Order</a>
                        @endif

                    </div>

                    <hr>


                        <div class="card card-small mb-4">
                                    <div class="card-header border-bottom">
                                        <h6 class="m-0">{{ $pageData['pageName'] }} Details</h6>
                                    </div>
                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item p-3">
                                            <div class="row">
                                                <div class="col">

                                                    <div class="form-row">
<!--                                                        <div class="form-group col-md-6">
                                                            <label>Item
                                                                Name</label>
                                                            <input v-model="fullName" name="item_name" type="text"
                                                                   autocomplete="off"
                                                                   class="form-control"
                                                                   placeholder="{{ $pageData['pageName'] }} Name"
                                                                   value="{{ $isSetModel->item_name ?? null }}">
                                                        </div>-->

                                                        <div class="form-group col-md-6">
                                                            <label>Item Name
                                                                <a target="_blank" href="{{ route('accessories-create') }}">
                                                                    <i class="material-icons">control_point</i>
                                                                </a>
                                                            </label>
                                                            <select class="select2-box form-control" name="accessories_id" laravel-model="Accessories" laravel-get-from="name">
                                                                <option value="{{ $isSetModel->accessories_id ?? null }}">{{ $isSetModel->accessories->name ?? null }}</option>
                                                            </select>
                                                        </div>

                                                       <div class="form-group col-md-6">
                                                            <label>Party Name
                                                                <a target="_blank" href="{{ route('party-create') }}">
                                                                    <i class="material-icons">control_point</i>
                                                                </a>
                                                            </label>
                                                            <select class="select2-box form-control" name="party_id" laravel-model="Party" laravel-get-from="name">
                                                                <option value="{{ $isSetModel->party_id ?? null }}">{{ $isSetModel->party->name ?? null }}</option>
                                                            </select>
                                                        </div>
                                                    </div>

                                                    <div class="form-row">
                                                        <div class="form-group col-md-4">
                                                            <label>PI Number</label>
                                                            <input name="pi_number" type="text"
                                                                   class="form-control"
                                                                   placeholder="PI Number"
                                                                   value="{{ $isSetModel->pi_number ?? null }}">
                                                        </div>
                                                        <div class="form-group col-md-8">
                                                            <label>LC Number</label>
                                                            <input value="{{ $isSetModel->lc_number ?? null }}"
                                                                   name="lc_number" type="text" class="form-control"
                                                                   placeholder="LC Number">
                                                        </div>
                                                    </div>

                                                    <div class="form-row">
                                                        <div class="form-group col-md-4">
                                                            <label>LC Date</label>
                                                            <input name="lc_date" type="date"
                                                                   class="form-control"
                                                                   placeholder="LC Date"
                                                                   value="{{ $isSetModel->lc_date ?? null }}">
                                                        </div>
                                                        <div class="form-group col-md-8">
                                                            <label>LC Value</label>
                                                            <input value="{{ $isSetModel->lc_value ?? null }}"
                                                                   name="lc_value" type="number" step="any" class="form-control"
                                                                   placeholder="LC Value">
                                                        </div>
                                                    </div>

                                                    <div class="form-row">
                                                        <div class="form-group col-md-4">
                                                            <label>Bank Acceptance Date</label>
                                                            <input name="bank_acceptance_date" type="date" class="form-control"
                                                                   value="{{ $isSetModel->bank_acceptance_date ?? null }}">
                                                        </div>

                                                        <div class="form-group col-md-4">
                                                            <label>B.Acceptance Amount</label>
                                                            <input name="bank_acceptance_amount" type="number" step="any" class="form-control"
                                                                   value="{{ $isSetModel->bank_acceptance_amount ?? null }}">
                                                        </div>

{{--                                                        <div class="form-group col-md-4">--}}
{{--                                                            <label>Maturity Date</label>--}}
{{--                                                            <input name="maturity_date" type="date" class="form-control" placeholder="Shipment Date"--}}
{{--                                                                   value="{{ $isSetModel->maturity_date ?? null }}">--}}
{{--                                                        </div>--}}

                                                        <div class="form-group col-md-4">
                                                            <label>Tenor</label>
                                                            <input name="tenor" type="number" step="1" min="1" max="150" class="form-control" placeholder="Days"
                                                                   value="{{ $isSetModel->tenor ?? null }}">
                                                        </div>

                                                    </div>

                                                    <div class="form-row">
                                                        <div class="form-group col-md-4">
                                                            <label>Payment Date</label>
                                                            <input name="payment_date" type="date" class="form-control" placeholder="Shipment Date"
                                                                   value="{{ $isSetModel->payment_date ?? null }}">
                                                        </div>

                                                        <div class="form-group col-md-4">
                                                            <label>Payment Status</label>
                                                            <select class="select2-box-manual form-control" name="payment_status">
                                                                <option value="{{ $isSetModel->payment_status ?? 'PaymentDue' }}">{{ $isSetModel->payment_status ?? 'Payment Due' }}</option>
                                                                <option value="PaymentDue">Payment Due</option>
                                                                <option value="Paid">Paid</option>
                                                                <option value="PartialPaid">Partial Paid</option>
                                                            </select>
                                                        </div>

                                                        <div class="form-group col-md-4">
                                                            <label>Payment Amount</label>
                                                            <input name="payment_amount" type="number" step="any" class="form-control"
                                                                   value="{{ $isSetModel->payment_amount ?? null }}">
                                                        </div>


                                                        <div class="form-group col-md-12">
                                                            <label>LC Purpose</label>
                                                            <select class="select2-box-manual form-control" name="lc_purpose">
                                                                <option value="{{ $isSetModel->lc_purpose ?? null }}">{{ $isSetModel->lc_purpose ?? 'Select...' }}</option>
                                                                <option value="ForOrder">For Order</option>
                                                                <option value="ForFactoryCash">For Factory Cash</option>
                                                                <option value="For_B2B_Adjustment">For BTB Adjustment</option>
                                                            </select>
                                                        </div>

                                                    </div>

                                                    <div class="form-row">
                                                        <div class="form-group col-md-12">
                                                            <label>About {{ $pageData['pageName'] }}</label>
                                                            <textarea v-model="aboutUser" name="description" class="form-control" rows="5">{{$isSetModel->description ?? null}}</textarea>
                                                        </div>
                                                    </div>
                                                    <button type="submit" class="btn btn-accent">Save</button>

                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>

                </div>

                            {{--Budget--}}

            </div>

        </form>
                    <!-- End Default Light Table -->
    </div>
@endsection

@section('vue-script')

@endsection

