@extends('layouts.master')

@section('content')

    @include('layouts.partial.notice')

    <div class="main-content-container container-fluid px-4">
        <!-- Page Header -->
        <div class="page-header row no-gutters py-4">
            <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
                <span class="text-uppercase page-subtitle">Overview</span>
                <h3 class="page-title"> {{ isset($isSetModel)? 'Edit':'Place' }} {{ $pageData['pageName'] }}
                    <a class="btn btn-outline-info" href="{{ route('budget-post-cost-list') }}">List</a>
                </h3>
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Default Light Table -->

        @include('layouts.orderFilterForm')

        <div class="row">
            <div class="col-lg-4 col-md-12 mb-4">
                @if(request()->coming != 'fromList')
                    <div class="card card-small mb-2">
                        <div class="card-header border-bottom">
                            <h6 class="m-0">Search by Order ID</h6>
                        </div>
                        <form action="">
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item p-3">
                                    <div class="row">
                                        <div class="col">
                                            <div class="form-row">
                                                <div class="form-group col-md-1 sc-legend">
                                                    ID
                                                </div>
                                                <div class="form-group col-md-8">
                                                    <select class="select2-box-field-filter form-control" name="id" laravel-get-from="id" laravel-model="Order">
                                                        <option value="{{ $id }}">{{ $id }}</option>
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-3">
                                                    <button class="form-control btn btn-primary">
                                                        Filter
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </form>
                    </div>
                @endif
            <!-- Sales by Category -->
                @if(isset($order))
                    <div class="card card-small user-details mb-4 text-capitalize">
                        <div class="card-header p-0">
                            <div class="user-details__bg">
                                <img src="{{ asset('profile-pic/system/up-user-details-background.jpg') }}" alt="User Details Background Image">
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <div class="user-details__avatar mx-auto ">
                                <img class="rounded" src="{{ $order->getGarmentsPicture() }}" alt="User Avatar">
                            </div>
                            <h4 class="text-center m-0 mt-2">{{ $order->name }}</h4>
                            <p class="text-center text-light m-0 mb-2">{{ $order->buyer->name }} ({{ $order->buyer->agent->name ?? 'None' }})</p>
                            {{--<ul class="user-details__social user-details__social--primary d-table mx-auto mb-4">
                                <li class="mx-1"><a href="#"><i class="fab fa-facebook-f"></i></a></li>
                                <li class="mx-1"><a href="#"><i class="fab fa-twitter"></i></a></li>
                                <li class="mx-1"><a href="#"><i class="fab fa-github"></i></a></li>
                                <li class="mx-1"><a href="#"><i class="fab fa-slack"></i></a></li>
                            </ul>--}}
                            <div class="user-details__user-data border-top border-bottom p-4">
                                <div class="row mb-3">
                                    <div class="col w-50">
                                        <span>Create</span>
                                        <span>{{ $order->user->name }}</span>
                                    </div>
                                    <div class="col w-50">
                                        <span>Sale's</span>
                                        <span>{{ $order->sales_user->name ?? 'None' }}</span>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col w-50">
                                        <span>Reporting to</span>
                                        <span>{{ $order->reporting_user->name ?? 'None'}}</span>
                                    </div>

                                </div>
                            </div>

                        </div>
                    </div>
            @endif
            <!-- End Sales by Category -->
            </div>
            <div class="col col-lg-8 col-md-12 mb-4">
                <!-- Sales Report -->
                <div class="card card-small production-entry">
                    <div class="card-header border-bottom">
                        <h6 class="m-0">{{$pageData['pageName']}} Entry</h6>
                        <div class="block-handle"></div>
                    </div>
                    @if($order)
                    <form action="{{ route($pageData['routeFirstName'].'-store', ['order_id' => $order->id??'', 'budget_id'=>$order->budget->id]) }}" method="post">
                        @csrf
                        <div class="card-body pt-0">


                            <div class="p-3">
                                @if(isset($order))

                                    <div class="form-row">
                                        <div class="col-12 col-sm-12 d-flex mb-2 mb-sm-0 pt-2 pb-4 w-100">
                                            <div class="card card-small overflow-hidden mb-4">
                                                <div class="card-header">
                                                    <h6 class="m-0">Budgets</h6>
                                                </div>
                                                @php
                                                    $orderQty = $order->ord_quantity;
                                                    $yarn_consumption = $order->budget->yarn_consumption ?? null
                                                @endphp

                                                <summary class="card-body p-0 text-center">
                                                    <table class="table table-bordered table-hover table-striped table-sm mb-0" id="BudgetPostCostTbl">
                                                        <thead class="">
                                                        <tr>
                                                            <th scope="col" class="border-bottom-0">#</th>
                                                            <th scope="col" class="border-bottom-0">Field</th>
                                                            <th scope="col" class="border-bottom-0">Value</th>
                                                            <th scope="col" class="border-bottom-0"></th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>

                                                        <tr>
                                                            <td>
                                                                <input type="radio" class="btn" name="budget_cost_type" value="Yarn">
                                                            </td>
                                                            <td>
                                                                <label>YrnPrice ({{ $yarn_price = $order->budget->yarn_price ?? null }})</label>
                                                            </td>
                                                            <td>
                                                                <label >{{ round($yarn_price * $yarn_consumption * $orderQty / 12, 2) ?? null }}</label>
                                                            </td>
                                                            <td>

                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td>
                                                                <input type="radio" class="btn" name="budget_cost_type" value="Knitting">
                                                            </td>
                                                            <td>
                                                                <label >KnttngPrice ({{ $knitting_price = $order->budget->knitting_price ?? null }})</label>
                                                            </td>
                                                            <td>
                                                                <label >{{ $knitting_price = round($knitting_price * $yarn_consumption * $orderQty / 12, 2) ?? null }}</label>
                                                            </td>
                                                            <td>

                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td>
                                                                <input type="radio" class="btn" name="budget_cost_type" value="Dying">
                                                            </td>
                                                            <td>
                                                                <label >Dyng ({{ $dyeing_price = $order->budget->dyeing_price ?? null }})</label>
                                                            </td>
                                                            <td>
                                                                <label >{{ $dyeing_price = round($dyeing_price * $yarn_consumption * $orderQty / 12, 2) ?? null }}</label>
                                                            </td>
                                                            <td>

                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td>
                                                                <input type="radio" class="btn" name="budget_cost_type" value="AOP">
                                                            </td>
                                                            <td>
                                                                <label >AOP ({{ $aop = $order->budget->aop ?? null }})</label>
                                                            </td>
                                                            <td>
                                                                <label >{{ $aop = round($aop * $yarn_consumption * $orderQty / 12, 2) ?? null }}</label>
                                                            </td>
                                                            <td>

                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td>
                                                                <input type="radio" class="btn" name="budget_cost_type" value="YD">
                                                            </td>
                                                            <td>
                                                                <label >YD ({{ $yd = $order->budget->yd ?? null }})</label>
                                                            </td>
                                                            <td>
                                                                <label >{{ $yd = round($yd * $yarn_consumption * $orderQty / 12, 2) ?? null }}</label>
                                                            </td>
                                                            <td>

                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td>
                                                                <input type="radio" class="btn" name="budget_cost_type" value="Accessories">
                                                            </td>
                                                            <td>
                                                                <label >Accessories ({{ $accessories = $order->budget->accessories ?? null }})</label>
                                                            </td>
                                                            <td>
                                                                <label >{{ $accessories = round($accessories * $orderQty / 12, 2) ?? null }} </label>
                                                            </td>
                                                            <td>

                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td>
                                                                <input type="radio" class="btn" name="budget_cost_type" value="Test">
                                                            </td>
                                                            <td>
                                                                <label >TstCst ({{ $test_cost = $order->budget->test_cost ?? null }})</label>
                                                            </td>
                                                            <td>
                                                                <label >{{ $test_cost = round($test_cost * $orderQty / 12, 2) ?? null }}</label>
                                                            </td>
                                                            <td>

                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td>
                                                                <input type="radio" class="btn" name="budget_cost_type" value="Print">
                                                            </td>
                                                            <td>
                                                                <label >Print ({{ $print = $order->budget->print ?? null }})</label>
                                                            </td>
                                                            <td>
                                                                <label >{{ $print = round($print * $orderQty / 12, 2) ?? null }}</label>
                                                            </td>
                                                            <td>

                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td>
                                                                <input type="radio" class="btn" name="budget_cost_type" value="Embroidery">
                                                            </td>
                                                            <td>
                                                                <label >Embroidery ({{ $embroidery = $order->budget->embroidery ?? null }})</label>
                                                            </td>
                                                            <td>
                                                                <label >{{ $embroidery = round($embroidery * $orderQty / 12, 2) ?? null }}</label>
                                                            </td>
                                                            <td>

                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td>
                                                                <input type="radio" class="btn" name="budget_cost_type" value="Commercial">
                                                            </td>
                                                            <td>
                                                                <label >BgtCommercial ({{ $commercial = $order->budget->bank_charge ?? null }})</label>
                                                            </td>
                                                            <td>
                                                                <label >{{ $commercial = round($commercial * $orderQty / 12, 2) ?? null }}</label>
                                                            </td>
                                                            <td>

                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td>
                                                                <input type="radio" class="btn" name="budget_cost_type" value="Buying">
                                                            </td>
                                                            <td>
                                                                <label >Cmmssn ({{ $buyingCommission = $order->budget->commission ?? null }})</label>
                                                            </td>
                                                            <td>
                                                                <label >{{ $buyingCommission = round($buyingCommission * $orderQty / 12, 2) ?? null }}</label>
                                                            </td>
                                                            <td>

                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td>
                                                                <input type="radio" class="btn" name="budget_cost_type" value="CM">
                                                            </td>
                                                            <td>
                                                                <label >Cm ({{ $cm = $order->budget->cm ?? null }})</label>
                                                            </td>
                                                            <td>
                                                                <label >{{ $cm = round($cm * $orderQty / 12, 2) ?? null }}</label>
                                                            </td>
                                                            <td>

                                                            </td>
                                                        </tr>



                                                        <tr>
                                                            <td>
                                                                <input type="radio" class="btn" name="budget_cost_type" value="Other">
                                                            </td>
                                                            <td>
                                                                <label >Others ({{ $other = $order->budget->others ?? null }})</label>
                                                            </td>
                                                            <td>
                                                                <label >{{ $other = round($other * $orderQty / 12, 2) ?? null }}</label>
                                                            </td>
                                                            <td>

                                                            </td>
                                                        </tr>


                                                        </tbody>
                                                        <tfoot class="">
                                                        <tr>
                                                            <th scope="col" class="border-bottom-0"></th>
                                                            <th scope="col" class="border-bottom-0"></th>
                                                            <th scope="col" class="border-bottom-0"></th>
                                                            <th scope="col" class="border-bottom-0"></th>
                                                        </tr>
                                                        </tfoot>
                                                    </table>
                                                </summary>

                                            </div>


                                            <div class="form-group col-md-6">
                                                <h5>Budget Post Cost Entry (<b class="text-info">@{{ budgetPostCostType }}</b>)</h5>
                                                <input name="date" type="date" class="form-control" placeholder="date">
                                                <br>
                                                <input name="chalan_no" class="form-control" placeholder="Bill No">
                                                <br>
                                                <div>
                                                    <label> Supplier
                                                        <a target="_blank" href="{{ route('supplier-create') }}">
                                                            <i class="material-icons">control_point</i>
                                                        </a>
                                                    </label>
                                                    <br>
                                                    <select class="select2-box form-control" name="supplier_id" laravel-model="Supplier" laravel-get-from="name">

                                                    </select>
                                                </div>
                                                <br>

                                                <input name="cost" class="form-control" placeholder="Cost">
                                            </div>

                                        </div>

                                    </div>


                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <button class="btn btn-success col-md-6">Save</button>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </form>
                    @endif
                </div>
                <!-- End Sales Report -->
            </div>

        </div>

    {{--@if(isset($isSetModel))
    <form action="{{ route($pageData['routeFirstName'].'-update', $isSetModel->id) }}" method="post" enctype="multipart/form-data">
        @method('PATCH')
    @else
    <form action="{{ route($pageData['routeFirstName'].'-store') }}" method="post" enctype="multipart/form-data">
    @endif
        @csrf

    </form>--}}
    <!-- End Default Light Table -->
    </div>
@endsection

@section('vue-script')
    <script>
        var error = new Howl({
            src: ["{{ asset('sound/to-the-point.ogg') }}"]
        });

        /*let disabledElem = 'form input,form select,form button';
        function prodEntryEnable(disabledElem, bool){
            $('.production-entry').find(disabledElem).prop('disabled', bool);
        }*/
        $(function () {

            //prodEntryEnable(disabledElem, true);

            @if(isset($order))

            /*prodEntryEnable('.production-entry-btn input[type="radio"]', false);

            $('input[name="production_type"]').closest('form').submit(function (e) {
                e.preventDefault();
            });

            $('input[name="production_type"]').change(function () {

                prodEntryEnable(disabledElem, false);

                if ($(this).val() == 'swing_in' || $(this).val() == 'swing_out'){
                    $('[name="line_id"]').closest('div').css('display', 'block');
                } else {
                    $('[name="line_id"]').closest('div').css('display', 'none');
                }
                $(this).closest('form').unbind('submit');
            });
            $('input[name="operation"]').change(function () {
                if ($(this).val() == 'SubContract'){
                    $('.sub-contract').css('display', 'block');
                } else {
                    $('.sub-contract').closest('div').css('display', 'none');
                }
            });*/
            @endif
        });

    </script>

    <script>

        $(document).ready(function (){
            $('#BudgetPostCostTbl tr').click(function (){
                //console.log($(this).find('input').val());
                app.budgetPostCostType = $(this).find('input').val();
                $(this).find('input').prop('checked', true);
            });
        });

        const data = {

            budgetPostCostType: '',

            productionType: '{{ old('production_type') }}',
            prQuantityFld: 0,
            operation:'{{ old('operation') }}',

            testInput: {
                cutting:[],
                swing_in:[],
                swing_out:[],
                iron:[],
                packing:[],

                Yarn: [],
                Knitting: [],
                Dying: [],
                AOP: [],
                YD: [],
                Print: [],
                Embroidery: [],
                Accessories: [],
                Test: [],
                CM: [],
                Commercial: [],
                Buying: [],
                Other: [],
                Profit: [],
            },


            validateQuantity: {},

            @if($order)

                @foreach($order->quantity as $sNcWiseQty)
                    test{{ $sNcWiseQty->id }}: false,
                @endforeach

                test{{old('order_quantity_id')}}: true,


                cutting: "{{ $order->cutting->sum('quantity') }}",
                swingIn: "{{ $order->swingIn->sum('quantity') }}",
                swingOut: "{{ $order->swingOut->sum('quantity') }}",
                iron: "{{ $order->iron->sum('quantity') }}",
                packing: "{{ $order->packing->sum('quantity') }}",

                Yarn: "",
                Knitting: "",
                Dying: "",
                AOP: "",
                YD: "",
                Print: "",
                Embroidery: "",
                Accessories: "",
                Test: "",
                CM: "",
                Commercial: "",
                Buying: "",
                Other: "",
                Profit: "",
            @endif
        };

        const app = new Vue({
            el: '#app',
            data,
            methods: {
                @if($order)
                    @foreach($order->quantity as $sNcWiseQty)
                testInpFun{{$sNcWiseQty->id}}(dbQty = 0, fld) {
                    return dbQty + (this.testInput[fld][{{$sNcWiseQty->id}}] || 0);
                },
                @endforeach

                validateQtyProduction() {
                    return (this.validateQuantity.cutting
                        >= this.validateQuantity.swing_in)
                        &&
                        (this.validateQuantity.swing_in
                            >= this.validateQuantity.swing_out
                        )
                        &&
                        (this.validateQuantity.swing_out
                            >= this.validateQuantity.iron
                        )
                        &&
                        (this.validateQuantity.iron
                            >= this.validateQuantity.packing
                        );
                },

                selectQtyRowFalse() {
                    @foreach($order->quantity as $sNcWiseQty)
                        this.test{{ $sNcWiseQty->id }} = false;
                    @endforeach
                },

                @endif

                roundWithFrac(number){
                    return Math.round(number * 100)/100;
                },
                prQuantitySumOnInp(field, fieldName, compare){
                    let userInpQtySum = Number(field) + Number(this.prQuantity[fieldName] || 0);
                    let dangerBtn = '';
                    if (compare < userInpQtySum) {
                        dangerBtn = 'btn-danger';
                        if (fieldName != 'cutting') {
                            error.play();
                        }
                    }

                    return { qty: userInpQtySum, status: dangerBtn };
                }
            },
            updated(){
                console.log(this.operation);
            },
            mounted(){
                let productionEntryEnable = (boolVal) => {
                    document.querySelectorAll('.production-entry-btn').forEach((item)=>{
                        item.querySelectorAll('input').forEach((input)=>{
                            input.disabled = !boolVal;
                        })
                    });
                };

                productionEntryEnable(false);

                @if($order)
                productionEntryEnable(true);
                @endif
            },
            computed: {
                cuttingQtyInpSum() {
                    return this.prQuantitySumOnInp(this.cutting, 'cutting', 0);
                },
                swingInQtyInpSum() {
                    return this.prQuantitySumOnInp(this.swingIn, 'swing_in', this.cuttingQtyInpSum.qty);
                },
                swingOutQtyInpSum() {
                    return this.prQuantitySumOnInp(this.swingOut, 'swing_out', this.swingInQtyInpSum.qty);
                },
                ironQtyInpSum() {
                    return this.prQuantitySumOnInp(this.iron, 'iron', this.swingOutQtyInpSum.qty);
                },
                packingQtyInpSum() {
                    return this.prQuantitySumOnInp(this.packing, 'packing', this.ironQtyInpSum.qty);
                },
            }

        });

    </script>
@endsection

