function deleteThisData(link){
    swal({
        title: "Are you sure to do this action ?",
        text: "",
        icon: "warning",
        buttons: true,
        dangerMode: true,
    }).then((willDelete) => {
        if (willDelete) {
            swal("Done! This action has been done !", {
                icon: "success",
            });
            window.location.href = link;
        }
    });

    return false;
}

function comingSoonAlert(text) {
    swal({
        title: text+" options Coming Soon ! ",
        text: "",
        icon: "warning",
    });
}

var oTable;

$(function () {


    var tblCanvas = false;
    var myCanvas = document.createElement("canvas");
    let tr = document.createElement("tr");
    let td = document.createElement("td");
    let tblPosition = 240+'px';


    window.onscroll = function() {

        if (window.pageYOffset > document.querySelector('.col').offsetTop) {
            //console.log();
            /*$(".main-data-table thead tr th").each(function (a, elm){ console.log(a, elm); //51 });*/

            tr.classList.remove("d-none");

            if (tblCanvas === false) {

                tblCanvas = true;
                html2canvas(document.querySelector(".main-data-table thead tr")).then(canvas => {

                    myCanvas = canvas;

                    tr.classList.add("table-fixed-position");

                    td.colSpan = 51;

                    td.appendChild(myCanvas);
                    tr.appendChild(td);

                    document.querySelector(".main-data-table thead").appendChild(tr);
                    //console.log(tr);
                });
            }

        } else {
            $(".table-fixed-position").addClass("d-none");
        }

        //console.log(document.querySelector('#search-area .card-small .list-group-item').offsetLeft);
        //console.log(document.querySelector('#main-table_wrapper').offsetTop);
        //console.log(document.querySelector('.col').offsetTop);


        document.querySelector('.dataTables_scrollBody').onscroll = function () {

            //  console.log(document.querySelector('.dataTables_scrollBody').scrollLeft); //search-area
            //tr.style.left = 18.5+'vw';
            var dataTables_scrollBody = document.querySelector('.dataTables_scrollBody');
            var searchArea = document.querySelector('#search-area .card-small')?.offsetLeft;
            var dataTables_scrollBodyOffsetLeft = document.querySelector('main').offsetLeft;

            tblPosition = dataTables_scrollBody.scrollLeft;

            //console.log('tblPosition: '+tblPosition, 'offsetLeft: '+dataTables_scrollBodyOffsetLeft, searchArea);

            tr.style.left = -tblPosition + dataTables_scrollBodyOffsetLeft + searchArea + 8 + 'px';
        };

    };

    $(".toggle-menu").click(function () {
        $(".main-sidebar").toggle(function () {

            let $mainContent = $(".main-content");
            let menuHideClass = 'menu-hide-done';
            let menuShowClass = 'col-lg-10 col-md-9 offset-lg-2 offset-md-3';

            if ( $mainContent.is( ".menu-hide-done" ) ) {
                $mainContent.removeClass(menuHideClass);
                $mainContent.addClass(menuShowClass);
            } else {
                $mainContent.removeClass(menuShowClass);
                $mainContent.addClass(menuHideClass);
            }

        });
    });





    /* for filter year */
    //document.querySelector("select[name='filterYear']").value = (new Date()).getFullYear();
    //document.querySelector("select[name='filterYearChart']").value = (new Date()).getFullYear();
    $("select[name='filterYear']").val((new Date()).getFullYear());
    $("select[name='filterYearChart']").val((new Date()).getFullYear());

    const urlParams = new URLSearchParams(window.location.search);
    const filterYearChart = urlParams.get('filterYearChart');


    if (filterYearChart) {
        document.querySelector("select[name='filterYearChart']").value = filterYearChart;
    }

    let filterYear = $("select[name='filterYear']").val();

    if (filterYear) {
        document.querySelector("select[name='filterYear']").value = filterYear;
    }

    //console.log(document.querySelector("#filterYear").value)
    $('.select2-box-manual').select2();
    $('.select2-box-manual-year').select2();
    /* end for filter year */

    $('#analytics-overview-date-range').datepicker({
        format: 'yyyy-mm-dd',
        todayHighlight: true,
        //startDate: "2021-01-01"
    });
    // Initialize the datatable.
    $(".summary-table").DataTable({
        ordering: false,
        paging: false,
        initComplete: function(settings, json) {

            let mainWrapper = settings.nTableWrapper;
            let copySearchDiv = mainWrapper.querySelector('div');
            let collapseTwo = "#collapseTwo"
            $(mainWrapper).prepend('<div class="'+copySearchDiv.className+'"><button class="btn btn-primary" onclick="$(collapseTwo).printElement()">Print</button></div>');
            //mainWrapper.appendChild(copySearchDiv);
            //console.log(copySearchDiv.className)

        }
    });

    //

    let summaryTableFirstRowText = $(".summary-table tbody tr").text();

    if ('No data available in table' === summaryTableFirstRowText) {
        $(".summary-table tbody tr").remove(); //remove first row from summery table
    }

    /******************/

    /**
     * Sorts a HTML table.
     *
     * @param {HTMLTableElement} table The table to sort
     * @param {number} column The index of the column to sort
     * @param {boolean} asc Determines if the sorting will be in ascending
     */
    function sortTableByColumn(table, column, asc = true) {
        //console.log(table)
        const dirModifier = asc ? 1 : -1;
        const tBody = table.tBodies[0];
        const rows = Array.from(tBody.querySelectorAll("tr"));

        // Sort each row
        const sortedRows = rows.sort((a, b) => {
            const aColText = a.querySelector(`td:nth-child(${ column + 1 })`).textContent.trim();
            const bColText = b.querySelector(`td:nth-child(${ column + 1 })`).textContent.trim();

            //console.log(aColText, bColText)

            return Number(aColText) > Number(bColText) ? (1 * dirModifier) : (-1 * dirModifier);
        });

        // Remove all existing TRs from the table
        while (tBody.firstChild) {
            tBody.removeChild(tBody.firstChild);
        }

        // Re-add the newly sorted rows
        tBody.append(...sortedRows);

        // Remember how the column is currently sorted
        table.querySelectorAll("th").forEach(th => th.classList.remove("th-sort-asc", "th-sort-desc"));
        table.querySelector(`th:nth-child(${ column + 1})`).classList.toggle("th-sort-asc", asc);
        table.querySelector(`th:nth-child(${ column + 1})`).classList.toggle("th-sort-desc", !asc);
    }

    document.querySelectorAll(".summary-table th").forEach(headerCell => {
        headerCell.addEventListener("click", () => {
            const tableElement = headerCell.parentElement.parentElement.parentElement;
            const headerIndex = Array.prototype.indexOf.call(headerCell.parentElement.children, headerCell);
            const currentIsAscending = headerCell.classList.contains("th-sort-asc");

            sortTableByColumn(tableElement, headerIndex, !currentIsAscending);
        });
    });

    /******************/

    var detailsTable = $('.details-table').DataTable({
        dom: 't',
        info: false,
        bFilter: false,
        scrollX: true,
        paging: false
    });

    $('.filter-data-table').DataTable({
        paging: false,
        info: false,
        searching: false,

    });

    // main report table
    oTable = $('.main-data-table').DataTable({
        dom: 't',
        searching: true,
        bFilter: false,
        paging: false,
        info: false,
        scrollCollapse: true,
        "scrollX": true,
        fixedHeader: true,
        //"order": [[ 1, 'asc' ]],
        fixedColumns:   {
            leftColumns: 0,
            rightColumns: 1
        }
    });   //pay attention to capital D, which is mandatory to retrieve "api" datatables' object, as @Lionel said

    oTable.on( 'order.dt search.dt', function () { //indexing first column
        oTable.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
            cell.innerHTML = i+1;
        } );
    } ).draw();

    $('#dataTableSearch').keyup(function(){
        oTable.search($(this).val()).draw() ;
    });

    $('.main-data-table tbody').on( 'click', 'tr', function () {
        $(this).toggleClass('tbl-row-selected');
    } );

    $('.summary-table').on( 'click', 'tr', function () {
        $(this).toggleClass('tbl-row-selected');
    } );

    if (typeof dataTableFooterSum === "function") {
        dataTableFooterSum({
            table: oTable
        });
    }


    //extra-menu open on hover
    $('.nav-item.border-right.dropdown.extra-menu').hover(function() {
        $(this).find('.dropdown-menu').stop(true, true).delay(5).fadeIn(200);
    }, function() {
        $(this).find('.dropdown-menu').stop(true, true).delay(5).fadeOut(200);
    });

    // password change form
    let re_password_match = true;
    var password_reset_form = document.forms["password_reset_form"];

    let new_password = password_reset_form.querySelector('input[name="new_password"]');
    let re_password = password_reset_form.querySelector('input[name="re_password"]');
    re_password.onkeyup = new_password.onkeyup = function () {
        if (new_password.value != re_password.value) {
            password_reset_form.querySelector("p").classList.add("d-block");
            re_password_match = false;
            re_password.style.border = "1px solid red";
        } else {
            password_reset_form.querySelector("p").classList.remove("d-block");
            re_password_match = true;
            re_password.style.removeProperty('border');
        }
    };

    password_reset_form.onsubmit = function (e) {
        if (!re_password_match) {
            e.preventDefault();
        }
    };
});

let horizontalScrollBtnObj = {
    leftScroll() {
        alert('leftScroll')
    },
    rightScroll() {
        alert('rightScroll')
    },

    leftPartialScroll() {
        alert('leftPartialScroll')
    },
    rightPartialScroll() {
        alert('rightPartialScroll')
    },

};






