<?php

use App\Accessories;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        $accessoriesFields = ['Forced Loan', 'EDF Loan', 'FDBP', 'Packing Credit (PC)'];

        foreach ($accessoriesFields as $field) {
            $hasField = $this->fieldChecker(Accessories::class, $field);

            if (!$hasField) {
                Accessories::insert([
                    'name' => $field,
                    'unit_name' => $field,
                ]);
            }
        }

        /**/

        // $this->call(UsersTableSeeder::class);
    }

    public function fieldChecker($model, $value)
    {
        return (new $model)->where('name', $value)->exists();
    }
}
