<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCommercialInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('commercial_invoices', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id')->nullable()->unsigned();
            $table->integer('update_user_id')->nullable()->unsigned();
            $table->integer('reporting_to_user_id')->nullable()->unsigned();
            $table->integer('prev_status_id')->nullable()->unsigned();
            $table->integer('order_id')->nullable()->unsigned();
            $table->integer('production_id')->nullable()->unsigned();
            $table->integer('commercial_id')->nullable()->unsigned();

            $table->string('invoice_number')->nullable();
            $table->date('invoice_date')->nullable();
            $table->float('invoice_value')->nullable();
            $table->integer('buyer_id')->nullable()->unsigned();
            $table->integer('payment_mode')->nullable()->unsigned();
            $table->string('master_lc_no_OR_sc_no')->nullable();
            $table->date('ex_factory_date')->nullable();
            $table->date('bl_date')->nullable();
            $table->date('payment_receive_date')->nullable();
            $table->float('payment_receive_amount')->nullable()->unsigned();
            $table->enum('payment_receive_status', ['ReceiveDue', 'FullyReceive', 'PartialReceive'])->default('ReceiveDue');
            $table->date('document_purchase_date')->nullable();
            $table->float('document_purchase_amount')->nullable()->unsigned();
            $table->float('short_or_access_payment')->nullable()->unsigned(); // automatic
            $table->integer('payment_overdue_days')->nullable()->unsigned(); // automatic

            $table->enum('data_status', ['running', 'edit', 'done', 'delete'])->default('running');
            $table->enum('approve_status', ['Pending', 'Approve', 'NotApprove'])->default('Approve');

            $table->text('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('commercial_invoices');
    }
}
