<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CommercialsTblAddFieldDataStatus extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('commercials', function (Blueprint $table) {
            $table->date('maturity_date')->nullable()->after('tenor');
            $table
                ->enum('data_status', [
                    'running',
                    'edit',
                    'delete'
                ])
                ->default('running')
                ->after('description');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('commercials', function (Blueprint $table) {
            $table->dropColumn('maturity_date');
            $table->dropColumn('data_status');
        });
    }
}
