<?php

namespace App\Http\Controllers;

use App\Budget;
use App\Buyer;
use App\Department;
use App\EmailList;
use App\Exports\OrdersExport;
use App\Mail\OrderCreated;
use App\Order;
use App\OrderEditRequest;
use App\OrderHistory;
use App\OrderSizeNColor;
use Illuminate\Support\Facades\Mail;
use Illuminate\Validation\Rule;
use Maatwebsite\Excel\Facades\Excel;
use Str;
use Image, Auth;
use App\OrderCategory;
use App\OrderStatus;
use App\OrderSubCategory;
use App\Role;
use App\Team;
use App;
use App\User;
use Illuminate\Http\Request;

class OrderController extends Controller
{
    public $_profile_pic_folder = 'profile-pic/garments';
    public $pageData = [];
    public $pageName = 'Order';
    public $viewFolder = 'orders';

    public function __construct()
    {
        $pageName = 'order';
        $this->pageData = [
            'no' => 0,
            'pageName' => Str::studly($pageName),
            'routeFirstName' => $pageName,
            'ignoreColsInExport' => '[0]',
        ];

        view()->share('pageData', $this->pageData);

    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function filterOrder($request)
    {
        $query = Order::query()->whereIn('history_type', ['Running', 'OldERP']);

        $query = $query->with(['budget:order_id,cm,yarn_consumption', 'buyer', 'quantity', 'status', 'shipment']);
        $id = $request->get('id') ?? null;
        $buyer_id = $request->get('buyer_id') ?? null;
        $name = $request->get('name') ?? null;
        $ord_quantity = $request->get('ord_quantity') ?? null;
        $style = $request->get('style') ?? null;
        $style_desc = $request->get('style_desc') ?? null;
        $statuses = $request->get('statuses') ?? null;
        $category_id = $request->get('category_id') ?? null;
        $sub_category_id = $request->get('sub_category_id') ?? null;
        $from = $request->get('from') ?? null;
        $to = $request->get('to') ?? null;
        $filterYear = $request->get('filterYear') ?? null;

        //$date_type = $request->get('date_type') ?? null;

        $per_page=(int)$request->input('per_page');

        if($per_page<=0)
        {
            $per_page = 20;
        }

        if($request->filled('id')) {
            $query = $query->where('id', $request->get('id') );
            //$phone = $request->get('phone');
        }
        if($request->filled('buyer_id')) {
            $query = $query->where('buyer_id', $request->get('buyer_id') );
            //$phone = $request->get('phone');
        }
        if($request->filled('name')) {
            $query = $query->where('name', $request->get('name') );
            //$phone = $request->get('phone');
        }
        if($request->filled('ord_quantity')) {
            $query = $query->where('ord_quantity', $request->get('ord_quantity') );
            //$phone = $request->get('phone');
        }
        if($request->filled('style')) {
            $query = $query->where('style', $request->get('style') );
            //$phone = $request->get('phone');
        }
        if($request->filled('style_desc')) {
            $query = $query->where('style_desc', $request->get('style_desc') );
            //$phone = $request->get('phone');
        }
        if($request->filled('statuses')) {
            $query = $query->where('statuses', $request->get('statuses') );
            //$phone = $request->get('phone');
        }
        if($request->filled('sub_category_id')) {
            $query = $query->where('sub_category_id', $request->get('sub_category_id') );
            //$phone = $request->get('phone');
        }
        if($request->filled('from') && $request->filled('to') && !$request->filled('today_order_entry')) {

            if ($request->get('date_type') == 'actual_shipDate') {
                $query = $query->where('statuses', 'ShipOut')
                    ->whereBetween('updated_at', [$request->get('from'), $request->get('to')] )
                ;
            } else {
                $query = $query->whereBetween($request->get('date_type'), [$request->get('from'), $request->get('to')] );
            }

            //$phone = $request->get('phone');
        }

        $today = date('Y-m-d');

        if($request->has('direct')) {

            $hasDays = date('Y-m-d', strtotime('10 days', strtotime($today)));

            $query = $query->whereBetween('date_of_ship', [$today, $hasDays]);

        }

        if($request->filled('today_order_entry')) {
            $from = $today;
            $to = $today;
            $request['date_type'] = 'order_accept_date';
            $query = $query->where('order_accept_date', $today);
        }


        //$orders = $query->get();
        $orders = $query->orderBy('date_of_ship')->get();
        //dd($orders);
        //$orders->setpath($request->fullUrl()."&per_page=$per_page");

        $compact = compact(
            'id',
            'buyer_id',
            'name',
            'ord_quantity',
            'style',
            'style_desc',
            'statuses',
            'category_id',
            'sub_category_id',
            'from',
            'to',
            'filterYear',
            'per_page',
            'orders'
        );

        //dd($orders);

        return $compact;
    }

    public function filterNotApprovalOrder($request, $orderType=['notApprove'])
    {
        $query = Order::query()->whereIn('history_type', $orderType);

        $query = $query->with(['budget:order_id,cm,yarn_consumption', 'buyer', 'quantity', 'status', 'shipment']);
        $id = $request->get('id') ?? null;
        $buyer_id = $request->get('buyer_id') ?? null;
        $name = $request->get('name') ?? null;
        $ord_quantity = $request->get('ord_quantity') ?? null;
        $style = $request->get('style') ?? null;
        $style_desc = $request->get('style_desc') ?? null;
        $statuses = $request->get('statuses') ?? null;
        $category_id = $request->get('category_id') ?? null;
        $sub_category_id = $request->get('sub_category_id') ?? null;
        $from = $request->get('from') ?? null;
        $to = $request->get('to') ?? null;
        $filterYear = $request->get('filterYear') ?? null;

        //$date_type = $request->get('date_type') ?? null;

        $per_page=(int)$request->input('per_page');

        if($per_page<=0)
        {
            $per_page = 20;
        }

        if($request->filled('id')) {
            $query = $query->where('id', $request->get('id') );
            //$phone = $request->get('phone');
        }
        if($request->filled('buyer_id')) {
            $query = $query->where('buyer_id', $request->get('buyer_id') );
            //$phone = $request->get('phone');
        }
        if($request->filled('name')) {
            $query = $query->where('name', $request->get('name') );
            //$phone = $request->get('phone');
        }
        if($request->filled('ord_quantity')) {
            $query = $query->where('ord_quantity', $request->get('ord_quantity') );
            //$phone = $request->get('phone');
        }
        if($request->filled('style')) {
            $query = $query->where('style', $request->get('style') );
            //$phone = $request->get('phone');
        }
        if($request->filled('style_desc')) {
            $query = $query->where('style_desc', $request->get('style_desc') );
            //$phone = $request->get('phone');
        }
        if($request->filled('statuses')) {
            $query = $query->where('statuses', $request->get('statuses') );
            //$phone = $request->get('phone');
        }
        if($request->filled('sub_category_id')) {
            $query = $query->where('sub_category_id', $request->get('sub_category_id') );
            //$phone = $request->get('phone');
        }
        if($request->filled('from') && $request->filled('to') && !$request->filled('today_order_entry')) {

            if ($request->get('date_type') == 'actual_shipDate') {
                $query = $query->where('statuses', 'ShipOut')
                    ->whereBetween('updated_at', [$request->get('from'), $request->get('to')] )
                ;
            } else {
                $query = $query->whereBetween($request->get('date_type'), [$request->get('from'), $request->get('to')] );
            }

            //$phone = $request->get('phone');
        }

        $today = date('Y-m-d');


        if($request->filled('today_order_entry')) {
            $from = $today;
            $to = $today;
            $request['date_type'] = 'order_accept_date';
            $query = $query->where('order_accept_date', $today);
        }


        //$orders = $query->get();
        $orders = $query->orderBy('date_of_ship')->get();
        //dd($orders);
        //$orders->setpath($request->fullUrl()."&per_page=$per_page");

        $compact = compact(
            'id',
            'buyer_id',
            'name',
            'ord_quantity',
            'style',
            'style_desc',
            'statuses',
            'category_id',
            'sub_category_id',
            'from',
            'to',
            'filterYear',
            'per_page',
            'orders'
        );

        //dd($orders);

        return $compact;
    }

    public function export($compact)
    {
        return Excel::download(new OrdersExport($compact), 'orders_'.date("d-m-Y").'.xlsx');
    }

    public function approveOrder(Order $order)
    {
        //dd($order);
        if(auth()->user()->isUserCanAccess(['order approve'])){
            $order->history_type = 'Running';
            $order->save();
            return redirect()->route($this->pageData['routeFirstName'].'-notApprove-list')->with(['success'=>$this->pageData['pageName'].' Approved Successfully.']);
        } else {
            return redirect()->route($this->pageData['routeFirstName'].'-notApprove-list')->with(['fail'=>'Unauthorised action! please inform your superior.']);
        }
        //return redirect()->to(session()->get('url.intended'));
    }

    public function index(Request $request)
    {
        //env('MAIL_USERNAME');
        //dd(App::isProduction());
        /*$msg = "New order place in Order List \n";

        $msg .= "\n \n ERROR";
        $msg .= "\n \n ERROR";
        $msg .= "\n \n ERROR";

        $headers = "From: newrmgerp@gmail.com";
        // send email
        mail("biplob@westapparelltd.com","My subject",$msg,$headers);
        mail("tanvir603@gmail.com","My subject",$msg,$headers);*/


        //dd($request->all());
        //$query = Order::query()->where('history_type', 'Running');
        $compact = $this->filterOrder($request);

        if($request->filled('excel')) {
            return $this->export($compact);
        }

        //dd($orders);

        return view('orders.index', $compact)
            ->withCount($compact['orders']->count())
            ;
    }

    public function cancelListIndex(Request $request)
    {
        $compact = $this->filterNotApprovalOrder($request, ['OrderDel']);

        if($request->filled('excel')) {
            return $this->export($compact);
        }

        //array_push($compact, ['module' => 'cancelOrders']);
        $compact['moduleName'] = 'cancelOrders';

        //dd($compact);

        return view('orders.index', $compact)
            ->withCount($compact['orders']->count())
            ;
    }

    public function notApproveIndex(Request $request)
    {
        $compact = $this->filterNotApprovalOrder($request, ['notApprove']);

        if($request->filled('excel')) {
            return $this->export($compact);
        }

        //dd($orders);

        return view('orders.index', $compact)
            ->withCount($compact['orders']->count())
            ;
    }

    public function editRequestIndex(Request $request)
    {
        $compact = $this->filterOrder($request);

        if($request->filled('excel')) {
            return $this->export($compact);
        }

        $editRequestArray = [];

        foreach ($compact['orders'] as $order) {

            if ($order->editRequest()->exists()) {
                //dump($item);
                $editRequestArray[] = $order;
            }
        }

        $compact['orders'] = collect($editRequestArray);

        //$orders = collect($editRequestArray);
        //dd($compact);

        return view('orders.editRequestIndex', $compact)
            ->withCount($compact['orders']->count())
            ;
    }

    public function indexForTable(Request $request)
    {
        $compact = $this->filterOrder($request);

        //return $compact;
        return view('orders.table', $compact)
            ->withCount($compact['orders']->count())
            ;
    }

    public function indexForPieChart(Request $request)
    {
        $pieChartMaterials = [];
        $totalQtyInfo = [];

        $compact = $this->filterOrder($request);

        $orders = $compact['orders'];

        foreach($orders as $order){
            //$order->quantity->sum('quantity')
            //dd($order); //$shipmentQty*$order->unit_price

            $totalQtyInfo['quantity']   = $quantity   = $order->ord_quantity;
            $totalQtyInfo['value']      = $value      = $order->ord_quantity*$order->unit_price;
            $totalQtyInfo['shipValue']  = $shipValue  = $order->shipment->sum('quantity')*$order->unit_price;
            $totalQtyInfo['shipQty']    = $shipQty    = $order->shipment->sum('quantity');

            $pieChartMaterials[$order->buyer->name]['quantity'][] = $quantity;
            $pieChartMaterials[$order->buyer->name]['value'][] = $value;
            $pieChartMaterials[$order->buyer->name]['shipValue'][] = $shipValue;
            $pieChartMaterials[$order->buyer->name]['shipQty'][] = $shipQty;
        }

        //$totalQtyInfo // not use this line code
        return $pieChartMaterials;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function create()
    {
        $prevBudgetForShow = new Budget();

        $checkEditedValueMatch = function(){
            return false;
        };

        return view('orders.create')
            ->withCheckEditedValueMatch($checkEditedValueMatch)
            ->withPrevBudget($prevBudgetForShow)
            ;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //dd($request->all());
        ini_set('max_execution_time', 1600);
        //dd($request['order_qty'][0]['qty']);
        //dd($request->all());
        /*echo '<pre>';
        print_r($request->all());
        echo '</pre>';*/
        //dd($request->all());
        $loggedUser = Auth::user();
        if(!$loggedUser->can_manage_user())
        {
            //return redirect()->back()->with(['fail'=>'Unauthorized Access.']);
        }
        $team_ids = $loggedUser->role->managed_user_team_ids();
        //dd($team_ids);
        $request->validate([
            'name' => 'required|max:255',
            'order_qty.*.qty' => 'required|integer',
            'buyer_id' => 'required|integer',
            //'style' => 'required',
            //'order_accept_date' => 'required',
            'date_of_ship' => 'required',
            //'quantity' => 'required|integer',
            'unit_price' => 'required|numeric',
            //'sub_category_id' => 'required|integer',
            //'status_id' => 'required|integer',
            //'sales_user_id' => 'required|integer',
            'image' => 'mimes:jpeg,jpg,png,JPEG,JPG,PNG|nullable|max:1000',

            //Budget
            "yarn_consumption" => 'numeric|required',
            "yarn_price" => 'numeric|required',
            "accessories" => 'numeric|required',
            "bank_charge" => 'numeric|required',
            "cm" => 'numeric|required',
            "finish_fab_consumption" => 'numeric|required',

            "knitting_price" => 'numeric|nullable',
            "dyeing_price" => 'numeric|nullable',
            "aop" => 'numeric|nullable',
            "lycra" => 'numeric|nullable',
            "lycra_percentage" => 'numeric|nullable',
            "yd" => 'numeric|nullable',
            "test_cost" => 'numeric|nullable',
            "print" => 'numeric|nullable',
            "embroidery" => 'numeric|nullable',
            "commission" => 'numeric|nullable',
            "freight_charge" => 'numeric|nullable',
            "others" => 'numeric|nullable',
            "others_type" => Rule::requiredIf($request['others'] == true),
            "lc_or_sales_contract" => 'numeric|nullable'
        ], [
            'name.required' => 'The Order Name ( ORDER NO ) field is required.',
            'order_qty.*.qty.required' => 'The Order Quantity field must be fill .',
        ]);
        if(!in_array($loggedUser->team->id,$team_ids))
        {
            //return redirect()->back()->with(['fail'=>'Permission denied to assign user to this team.']);
        }

        $model = new Order();
        $model->user_id = $loggedUser->id;
        $model->name = $request['name'];
        $model->buyer_id = $request['buyer_id'];
        $model->style = $request['style'];
        $model->style_desc = $request['style_desc'];

        $model->order_accept_date = date('Y-m-d');
        if($request->filled('order_accept_date')) {
            //$model->order_accept_date = $request['order_accept_date'];
        }

        $model->date_of_ship = $request['date_of_ship'];

        $model->ord_quantity = collect($request['order_qty'])->sum('qty');

        $model->unit_price = $request['unit_price'];
        $model->sub_category_id = $request['sub_category_id'];
        $model->status_id = $request['status_id'];
        $model->smv = $request['smv'];
        $model->sales_user_id = $request['sales_user_id'];
        if ($request->has('reporting_to_user_id')) {
            $model->reporting_to_user_id = $request['reporting_to_user_id'];
        }
        $model->description = $request['description'];

        if($request->hasFile('image'))
        {
            $image = $request->file('image');
            $model->image = $filename = time() . '.' . $image->getClientOriginalExtension();
            $image_resize = Image::make($image->getRealPath());
            $image_resize->widen(250);
            $image_resize->save(public_path($this->_profile_pic_folder.'/' .$filename));
        }

        $model->save();

        //Budget Save in DB
        $model2 = new Budget();
        $model2->order_id =             $model->id;
        $model2->user_id =              $loggedUser->id;
        $model2->yarn_price =           $request['yarn_price'];
        $model2->knitting_price =       $request['knitting_price'];
        $model2->dyeing_price =         $request['dyeing_price'];
        $model2->aop =                  $request['aop'];
        $model2->lycra =                $request['lycra'];
        $model2->lycra_percentage =     $request['lycra_percentage'];
        $model2->yd =                   $request['yd'];
        $model2->accessories =          $request['accessories'];
        $model2->test_cost =            $request['test_cost'];
        $model2->print =                $request['print'];
        $model2->embroidery =           $request['embroidery'];
        $model2->bank_charge =          $request['bank_charge'];
        $model2->commission =           $request['commission'];
        $model2->cm =                   $request['cm'];
        $model2->finish_fab_consumption = $request['finish_fab_consumption'];
        $model2->yarn_consumption =     $request['yarn_consumption'];
        $model2->freight_charge =       $request['freight_charge'];
        $model2->others =               $request['others'];
        $model2->lc_or_sales_contract = $request['lc_or_sales_contract'];
        $model2->description =          $request['budget_description'];

        if ($request['others']) {
            $model2->others_type = $request['others_type'];
        }

        $model2->save();

        //dd(collect($request['order_qty'])->sum('qty'));

        foreach ($request['order_qty'] as $key => $qty) {
            //Order Quantity Save in DB
            $model3 = new OrderSizeNColor();
            $model3->user_id =              $loggedUser->id;
            $model3->order_id =             $model->id;
            $model3->quantity =             $qty['qty'];
            $model3->color_id =             isset($qty['color_id'])?$qty['color_id']:1;
            $model3->size_id  =             isset($qty['size_id'])?$qty['size_id']:1;
            $model3->save();
        }


        /**************/
        // the message
        //$msg = "New order place in Order List \n";

        /*$msg .= "Buyer: ".$model->buyer->name ."\n";
        $msg .= "Order No: $model->name \n";
        $msg .= "Style No: $model->style \n";
        $msg .= "Quantity: ".$model->quantity->sum('quantity') ."\n";
        $msg .= "Unit Price: $model->unit_price \n";
        $msg .= "Order Value: ". $model->unit_price * $model->quantity->sum('quantity') ."\n";
        $msg .= "Shipment: ". $model->date_of_ship ."\n";
        $msg .= "Order Place by: ".$model->user->name;*/

        //$headers = "From: newrmgerp@gmail.com";
        // send email
        //mail("biplob@westapparelltd.com","New Order Place",$msg,$headers);
        //mail("tanvir603@gmail.com","New Order Place",$msg,$headers);
        /**************/
        $order = [
            "OrderUniqueID" => $model->id,
            "Buyer" => $model->buyer->name,
            "OrderNo" => $model->name,
            "StyleNo" => $model->style,
            "Quantity" => $model->ord_quantity,
            "UnitPrice" => $model->unit_price,
            "OrderValue" => $model->unit_price * $model->ord_quantity,
            "Shipment" => $model->date_of_ship,
            "OrderPlaceBy" => $model->user->name,
        ];

        //Mail::to('tanvir603@gmail.com')->send(new OrderCreated($order));

        foreach (EmailList::where([['type', 'order'], ['status', 'active']])->get() as $emailObj) {
            Mail::to($emailObj->email)->send(new OrderCreated($order));
        }
/*
        Mail::to("tanvir603@gmail.com")->send(new OrderCreated($order));
        //Mail::to("rudrogang@gmail.com")->send(new OrderCreated($order));

        Mail::to("biplob@westapparelltd.com")->send(new OrderCreated($order));
        Mail::to("kanon@westapparelltd.com")->send(new OrderCreated($order));

        Mail::to("emran@knitgarden.co")->send(new OrderCreated($order));
        Mail::to("al-amin@knitgarden.co")->send(new OrderCreated($order));
        Mail::to("ahnaf@knitgarden.co")->send(new OrderCreated($order));
        Mail::to("yasir@knitgarden.co")->send(new OrderCreated($order));
        Mail::to("chisty@knitgarden.co")->send(new OrderCreated($order));
        Mail::to("rakibol@knitgarden.co")->send(new OrderCreated($order));
        Mail::to("commercial@knitgarden.co")->send(new OrderCreated($order));
        Mail::to("accounts@knitgarden.co")->send(new OrderCreated($order));
        Mail::to("p.m@knitgarden.co")->send(new OrderCreated($order));
        Mail::to("knitting@knitgarden.co")->send(new OrderCreated($order));*/

        return redirect()->route($this->pageData['routeFirstName'].'-list', 'id='.$model->id)->with(['success'=>$this->pageData['pageName'].' Created Successfully.']);

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Order  $order
     * @return \Illuminate\Http\Response
     */
    public function show(Order $order)
    {
        session()->put('url.intended',url()->previous());

        if ($order->history_type == 'Running') {
            return view('layouts.orderDetails.show')
                ->withOrder($order)
                ;
        }

        return redirect()->route($this->pageData['routeFirstName'].'-list')->with(['fail'=>$this->pageData['pageName'].' id '.$order->id.' not found.']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Order  $order
     * @return \Illuminate\Http\Response
     */

    public function edit(Order $order, Request $request)
    {
        //order quantity for vue
        $vueArr = [];
        $prev_Budget = null;
        $prevBudgetForShow =  new Budget();

        foreach ($order->quantity as $key => $qty) {
            $vueArr[] = [
                'quantity_id' => $qty->id,
                'clrName' => isset($qty['color_id'])?$qty->color->name:'',
                'szName' => isset($qty['size_id'])?$qty->size->name:'',
                'clr' => isset($qty['color_id'])?$qty['color_id']:'',
                'sz' => isset($qty['size_id'])?$qty['size_id']:'',
                'qty' => $qty['quantity']
            ];
        }

        if(auth()->user()->isUserCanAccess(['order approve']) && $request['type'] === 'edit_request'){
            //$prevBudgetForShow = new Budget();
            $prev_Budget = $order->budget;
            $order->budget = $order->orderEditRequest;
        }


        $checkEditedValueMatch = function($field) use ($prev_Budget, $prevBudgetForShow, $order){

            if ($has_prev_Budget = $prev_Budget ? $prev_Budget->$field != $order->budget->$field: null) {
                $prevBudgetForShow->$field = '<b class="text-success bg-white">('.$prev_Budget->$field.')</b>';
            }

            return $has_prev_Budget;
        };

        //dd($prevBudgetForShow);


        return $this->create()
            ->withIsSetModel($order)
            ->withPrevBudget($prevBudgetForShow)
            ->withCheckEditedValueMatch($checkEditedValueMatch)
            ->withVueArr($vueArr)
        ;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Order  $order
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Order $order)
    {
        //dd($request['others'], $request['others'] == true, $request['others'] == null);
        if ($request['copy_order'] === 'copy_order_value') {
            $this->store($request);
            return redirect()->route($this->pageData['routeFirstName'].'-list', 'id='.$order->id)->with(['success'=>$this->pageData['pageName'].' Copied Successfully from this order ID : '.$order->id]);
        }
        //dd($request['copy_order'], $request->all()); // copy_order_value
        //budgetEditEnable
        $loggedUser = Auth::user();
        if(!$loggedUser->can_manage_user())
        {
            return redirect()->back()->with(['fail'=>'Unauthorized Access.']);
        }
        $team_ids = $loggedUser->role->managed_user_team_ids();
        //dd($team_ids);
        $request->validate([
            'name' => 'required|max:255',
            'buyer_id' => 'required|integer',
            //'style' => 'required',
            //'order_accept_date' => 'required',
            'date_of_ship' => 'required',
            //'quantity' => 'required|integer',
            'unit_price' => 'required|numeric',
            //'sub_category_id' => 'required|integer',
            //'status_id' => 'required|integer',
            //'sales_user_id' => 'required|integer',
            'image' => 'mimes:jpeg,jpg,png,JPEG,JPG,PNG|nullable|max:1000',

        ], [
            'name.required' => 'The Order Name ( ORDER NO ) field is required.',
        ]);

        if ($request['budgetEditEnable']) {

            $request->validate([

                //Budget
                "yarn_consumption" => 'numeric|required',
                "yarn_price" => 'numeric|required',
                "accessories" => 'numeric|required',
                "bank_charge" => 'numeric|required',
                "cm" => 'numeric|required',
                "finish_fab_consumption" => 'numeric|required',

                "knitting_price" => 'numeric|nullable',
                "dyeing_price" => 'numeric|nullable',
                "aop" => 'numeric|nullable',
                "lycra" => 'numeric|nullable',
                "lycra_percentage" => 'numeric|nullable',
                "yd" => 'numeric|nullable',
                "test_cost" => 'numeric|nullable',
                "print" => 'numeric|nullable',
                "embroidery" => 'numeric|nullable',
                "commission" => 'numeric|nullable',
                "freight_charge" => 'numeric|nullable',
                "others" => 'numeric|nullable',
                "others_type" => Rule::requiredIf($request['others'] == true),
                "lc_or_sales_contract" => 'numeric|nullable'
            ]);

        }

        if(!in_array($loggedUser->team->id,$team_ids))
        {
            return redirect()->back()->with(['fail'=>'Permission denied to assign user to this team.']);
        }

        /*order history*/
        $orderHistory = new OrderHistory();
        $orderHistory->user_id              = $order->user_id;
        $orderHistory->order_id             = $order->id;
        $orderHistory->name                 = $order->name;
        $orderHistory->buyer_id             = $order->buyer_id;
        $orderHistory->style                = $order->style;
        $orderHistory->style_desc           = $order->style_desc;
        $orderHistory->order_accept_date    = $order->order_accept_date;
        $orderHistory->date_of_ship         = $order->date_of_ship;
        //$orderHistory->quantity             = $order->quantity;
        $orderHistory->unit_price           = $order->unit_price;
        $orderHistory->sub_category_id      = $order->sub_category_id;
        $orderHistory->status_id            = $order->status_id;
        $orderHistory->smv                  = $order->smv;
        $orderHistory->sales_user_id        = $order->sales_user_id;
        $orderHistory->reporting_to_user_id = $order->reporting_to_user_id;
        $orderHistory->description          = $order->description;
        $orderHistory->image                = $order->image;
        //$orderHistory->save();

        if ($request['budgetEditEnable']) {
            if ($order->budget) {
                //$prevBudget = $order->budget;
                /*History Budget*/
                /*$budgetHistory = new Budget(); // new budget instance
                $budgetHistory->history_type            = 'Edit';
                $budgetHistory->order_id                = $prevBudget->order_id;
                $budgetHistory->user_id                 = $prevBudget->user_id ?? $loggedUser->id;
                $budgetHistory->yarn_price              = $prevBudget->yarn_price;
                $budgetHistory->knitting_price          = $prevBudget->knitting_price;
                $budgetHistory->dyeing_price            = $prevBudget->dyeing_price;
                $budgetHistory->aop                     = $prevBudget->aop;
                $budgetHistory->lycra               = $prevBudget->lycra;
                $budgetHistory->lycra_percentage         = $prevBudget->lycra_percentage;
                $budgetHistory->yd               = $prevBudget->yd;
                $budgetHistory->accessories             = $prevBudget->accessories;
                $budgetHistory->test_cost               = $prevBudget->test_cost;
                $budgetHistory->print    = $prevBudget->print;
                $budgetHistory->embroidery    = $prevBudget->embroidery;
                $budgetHistory->bank_charge             = $prevBudget->bank_charge;
                $budgetHistory->commission              = $prevBudget->commission;
                $budgetHistory->cm                      = $prevBudget->cm;
                $budgetHistory->finish_fab_consumption  = $prevBudget->finish_fab_consumption;
                $budgetHistory->yarn_consumption        = $prevBudget->yarn_consumption;
                $budgetHistory->freight_charge          = $prevBudget->freight_charge;
                $budgetHistory->others                  = $prevBudget->others;
                $budgetHistory->lc_or_sales_contract    = $prevBudget->lc_or_sales_contract;
                $budgetHistory->description             = $prevBudget->budget_description;
                $budgetHistory->save();*/

                /*Update Budget*/

                $orderEditRequestArr = OrderEditRequest::where([['order_id', $order->id], ['request', 'pending']])->get();

                $orderApproveRule = auth()->user()->isUserCanAccess(['order approve']);

                if (!$orderApproveRule) {
                    foreach ($orderEditRequestArr as $key => $orderEditRequestSingle){
                        $orderEditRequestSingle->request = 'cancel';
                        $orderEditRequestSingle->save();
                    }
                }


                $model2 = new OrderEditRequest();
                $model2->order_id   = $order->id;
                $model2->user_id    = auth()->user()->id;

                if($orderApproveRule){
                    $model2             = $order->budget;

                    $orderEditRequest = OrderEditRequest::where([['order_id', $order->id], ['request', 'pending']])->latest()->first();
                    //dd($orderEditRequest);
                    if ($orderEditRequest) {
                        $orderEditRequest->request = 'done';
                        $orderEditRequest->save();
                    }
                }

                $model2->yarn_price =               $request['yarn_price'];
                $model2->knitting_price =           $request['knitting_price'];
                $model2->dyeing_price =             $request['dyeing_price'];
                $model2->aop =                      $request['aop'];
                $model2->lycra =                    $request['lycra'];
                $model2->lycra_percentage =         $request['lycra_percentage'];
                $model2->yd =                       $request['yd'];
                $model2->accessories =              $request['accessories'];
                $model2->test_cost =                $request['test_cost'];
                $model2->print =                    $request['print'];
                $model2->embroidery =               $request['embroidery'];
                $model2->bank_charge =              $request['bank_charge'];
                $model2->commission =               $request['commission'];
                $model2->cm =                       $request['cm'];
                $model2->finish_fab_consumption =   $request['finish_fab_consumption'];
                $model2->yarn_consumption =         $request['yarn_consumption'];
                $model2->freight_charge =           $request['freight_charge'];
                $model2->others =                   $request['others'];
                $model2->lc_or_sales_contract =     $request['lc_or_sales_contract'];
                $model2->description =              $request['budget_description'];

                if ($request['others']) {
                    $model2->others_type =          $request['others_type'];
                }

                $model2->save();


            } else {
                $model2 = new Budget();
                $model2->order_id =             $order->id;
                $model2->yarn_price =           $request['yarn_price'];
                $model2->knitting_price =       $request['knitting_price'];
                $model2->dyeing_price =         $request['dyeing_price'];
                $model2->aop=                   $request['aop'];
                $model2->lycra=                 $request['lycra'];
                $model2->lycra_percentage=      $request['lycra_percentage'];
                $model2->yd =                   $request['yd'];
                $model2->accessories =          $request['accessories'];
                $model2->test_cost =            $request['test_cost'];
                $model2->print =                $request['print'];
                $model2->embroidery =           $request['embroidery'];
                $model2->bank_charge =          $request['bank_charge'];
                $model2->commission =           $request['commission'];
                $model2->cm =                   $request['cm'];
                $model2->finish_fab_consumption = $request['finish_fab_consumption'];
                $model2->yarn_consumption =     $request['yarn_consumption'];
                $model2->freight_charge =       $request['freight_charge'];
                $model2->others =               $request['others'];
                $model2->lc_or_sales_contract = $request['lc_or_sales_contract'];
                $model2->description =          $request['budget_description'];
                $model2->save();
            }
        }

        /*order history*/

        $model = $order;
        $model->user_id = $loggedUser->id;
        $model->name = $request['name'];
        $model->buyer_id = $request['buyer_id'];
        $model->style = $request['style'];
        $model->style_desc = $request['style_desc'];
        //$model->order_accept_date = $request['order_accept_date'];
        $model->date_of_ship = $request['date_of_ship'];
        //$model->quantity = $request['quantity'];

        //$model->ord_quantity = collect($request['order_qty'])->sum('qty');

        $model->unit_price = $request['unit_price'];
        $model->sub_category_id = $request['sub_category_id'];
        $model->status_id = $request['status_id'];
        $model->smv = $request['smv'];
        $model->sales_user_id = $request['sales_user_id'];
        if ($request->has('reporting_to_user_id')) {
            $model->reporting_to_user_id = $request['reporting_to_user_id'];
        }
        $model->description = $request['description'];

        if($request->hasFile('image'))
        {
            $image = $request->file('image');
            $model->image = $filename = time() . '.' . $image->getClientOriginalExtension();
            $image_resize = Image::make($image->getRealPath());
            $image_resize->widen(250);
            $image_resize->save(public_path($this->_profile_pic_folder.'/' .$filename));
        }


        //dd($request['removeQtyRows'], count($request['order_qty']));

        $removeQtyRows = explode(',', $request['removeQtyRows']);

        OrderSizeNColor::destroy($removeQtyRows);

        $orderSizeNColors = OrderSizeNColor::where('order_id', $order->id)->get();

        $order_qty = [];

        if (count($request['order_qty']) > $orderSizeNColors->count()) { // if user added new data then "order_qty" array not match with DB given data
            $newQtyAdded = count($request['order_qty']) - $orderSizeNColors->count(); //calculate how many data is added

            for ($i = 0; $i < $newQtyAdded; $i++) {

                $newQtyData = array_reverse($request['order_qty'])[$i]; // after calculate data make array revers

                $newOrderSizeNColorQty = new OrderSizeNColor();
                $newOrderSizeNColorQty->user_id =              $loggedUser->id;
                $newOrderSizeNColorQty->order_id =             $model->id;
                $newOrderSizeNColorQty->quantity =             $newQtyData['qty'];
                $newOrderSizeNColorQty->color_id =             isset($newQtyData['color_id'])?$newQtyData['color_id']:null;
                $newOrderSizeNColorQty->size_id  =             isset($newQtyData['size_id'])?$newQtyData['size_id']:null;

                $order_qty[] = $newOrderSizeNColorQty->quantity;

                $newOrderSizeNColorQty->save(); // save only last new added data
            }
        }


        foreach ($orderSizeNColors as $k=>$orderSizeNColor) {
            $orderSizeNColor->quantity = $request['order_qty'][$k]['qty'];
            $orderSizeNColor->color_id = $request['order_qty'][$k]['color_id'];
            $orderSizeNColor->size_id = $request['order_qty'][$k]['size_id'];

            $order_qty[] = $orderSizeNColor->quantity;

            $orderSizeNColor->save();
        }

        //dd($order_qty);
        $model->ord_quantity = array_sum($order_qty);
        $model->save(); // main order save


        if($model->history_type == 'notApprove'){
            return redirect()->back();
        }


        return redirect()->route('order-show', $order->id)->with(['success'=>$this->pageData['pageName'].' Updated Successfully.']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Order  $order
     * @return \Illuminate\Http\Response
     */
    public function destroy(Order $order)
    {
        //dd(session()->get('url.intended'));
        $order->deleteOrder();
        return redirect()->to(session()->get('url.intended'));
    }

    public function destroyFromNotApproveOrder(Order $order)
    {
        //dd('dddd');
        //dd(session()->get('url.intended'));
        $order->deleteOrder('beforeApprove');
        return back();
    }

    /**
     * Print order information.
     *
     * @param  \App\Order  $order
     * @return \Illuminate\Http\Response
     */

    public function print(Order $order)
    {
        //dd($order);
        return view($this->viewFolder.'.print.index')
            ->withOrder($order)
            ;
    }

}
