<?php

namespace App\Http\Controllers;

use App\Budget;
use App\Buyer;
use App\OldErp;
use App\Order;
use App\OrderSizeNColor;
use Illuminate\Http\Request;

class OldErpController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function test()
    {
        dd(OldErp::with('old_budget')->find(25)) ;
    }

    public function index()
    {
        set_time_limit(600);

        $old = OldErp::with('old_budget')->get()->groupBy('customer_name');


        foreach ($old as $name=>$datas) {

            try {

                $name = rtrim($name, ' ');
                $name = ltrim($name, ' ');

                $buyer = new Buyer();
                $buyer->name = $name;
                if ($name == '') {
                    $buyer->name = "Not set name";
                }

                //$buyer->address = 'old erp';
                //$buyer->description = 'old erp';

                $buyer->save();

            } catch (\Exception $exception){

                continue;

            }


            foreach ($datas as $data) {

                try {
                    $order = new Order();
                    $order->registered_from = 'OldERP';
                    $order->unit_price = ($data->unit_price != '') ? $data->unit_price : 0;
                    $order->statuses = $data->order_status;

                    if ($data->order_status == 'Partial Shipment') {
                        $order->statuses = 'Partial';
                    }

                    $order->history_type = 'Running';

                    if ($data->shipStatus == 'running') {
                        $order->history_type = 'Running';
                    }

                    if ($data->shipStatus == 'cancel') {
                        $order->history_type = 'Cancel';
                    }

                    //Partial Shipment = Partial, Running = Running, ShipOut = ShipOut

                    $order->user_id = 1;

                    //order_quantity
                    //OrderSizeNColor

                    $order->smv = $data->smv;
                    $order->description = 'old erp';
                    $order->order_accept_date = $data->date_of_entry;
                    $order->date_of_ship = $data->date_of_ship;
                    $order->style_desc = $data->style_description;
                    $order->style = $data->article_no;
                    $order->previous_status_id = 0;
                    $order->status_id = 0;
                    $order->sub_category_id = 0;
                    $order->reporting_to_user_id = 1;
                    $order->sales_user_id = 1;
                    $order->image = $data->garmentImg;
                    $order->name = $data->order_number;

                    $customer_name = rtrim($data->customer_name, ' ');
                    $customer_name = ltrim($customer_name, ' ');

                    if ($customer_name == '') {
                        $customer_name = 'Not set name';
                    }

                    $buyer_id = Buyer::where('name', $customer_name)->first()->id;
                    $order->buyer_id = $buyer_id;
                    $order->save();

                    if ($data->old_budget) {

                        $budget = new Budget();
                        $budget->order_id = $order->id;
                        $budget->yarn_price = (double) $data->old_budget->yrnPrice;
                        $budget->knitting_price = (double) $data->old_budget->kntngPrice;
                        $budget->dyeing_price = (double) $data->old_budget->dyngPrice;
                        $budget->aop = (double) $data->old_budget->aopPrint;
                        $budget->accessories = (double) $data->old_budget->accessories;
                        $budget->test_cost = (double) $data->old_budget->testCost;
                        $budget->print = (double) $data->old_budget->print;
                        $budget->bank_charge = (double) $data->old_budget->bankCharge;
                        $budget->commission = (double) $data->old_budget->commission;
                        //$budget-> = $data->buyingComssn;
                        $budget->finish_fab_consumption = (double) $data->old_budget->fnshFabrcConsump;
                        $budget->freight_charge = (double) $data->old_budget->freightChrge;
                        $budget->others = (double) $data->old_budget->others;
                        $budget->yarn_consumption = (double) $data->old_budget->yrnConsumption;
                        $budget->user_id = 1;
                        $budget->save();
                        //dump($data->old_budget->yrnPrice);

                        /* this new erp
                            /"order_id" => 3
                            //"user_id" => 1
                            /"yarn_price" => 1.5
                            /"knitting_price" => 1.6
                            /"dyeing_price" => 10.0
                            /"aop" => 1.7
                            /"accessories" => 1.0
                            /"test_cost" => 1.0
                            /"print" => 10.0
                            /"bank_charge" => 1.0
                            /"commission" => 1.0
                            /"finish_fab_consumption" => 3.0
                            /"yarn_consumption" => 4.0
                            /"freight_charge" => 4.0
                            /"others" => 7.0

                            "history_type" => "Running"
                            "description" => "dasd"
                            "lc_or_sales_contract" => 8.0
                            "cm" => 2.0
                            "yd" => 2.3
                            "embroidery" => null
                         * */

                        /* this new old erp
                         *
                            /"order_id" => 25
                            /"yrnPrice" => "3.25"
                            /"kntngPrice" => "0.20"
                            /"dyngPrice" => "1.40"
                            /"aopPrint" => ""
                            /"accessories" => "3.00"
                            /"testCost" => ""
                            /"print" => "9"
                            /"bankCharge" => "0.18"
                            /"commission" => ""
                            /"buyingComssn" => null
                            /"fnshFabrcConsump" => "1.82"
                            /"freightChrge" => ""
                            /"others" => ""
                            /"yrnConsumption" => "2.13"
                        */
                    }


                    $orderQty = new OrderSizeNColor();
                    $orderQty->history_type = 'Running';
                    $orderQty->order_id = $order->id;
                    $orderQty->user_id = 1;
                    $orderQty->color_id = 0;
                    $orderQty->size_id = 0;
                    $orderQty->quantity = $data->order_quantity;
                    $orderQty->save();

                }catch (\Exception $exception){

                    dump($data);
                    dump($exception);

                }
            }
        }

        dd($old);

        //return OldErp::all();
    }

    public function rmData()
    {
        //dd('dsa');
        Order::truncate();
        Buyer::truncate();
        OrderSizeNColor::truncate();
        Budget::truncate();
    }

}
