/*
 Highstock JS v7.2.0 (2019-09-03)

 All technical indicators for Highstock

 (c) 2010-2019 Pawel Fus

 License: www.highcharts.com/license
*/
(function(g){"object"===typeof module&&module.exports?(g["default"]=g,module.exports=g):"function"===typeof define&&define.amd?define("highcharts/indicators/indicators-all",["highcharts","highcharts/modules/stock"],function(r){g(r);g.Highcharts=r;return g}):g("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(g){function r(d,p,k,l){d.hasOwnProperty(p)||(d[p]=l.apply(null,k))}g=g?g._modules:{};r(g,"mixins/indicator-required.js",[g["parts/Globals.js"]],function(d){var p=d.error;return{isParentLoaded:function(d,
l,e,c,b){if(d)return c?c(d):!0;p(b||this.generateMessage(e,l));return!1},generateMessage:function(d,l){return'Error: "'+d+'" indicator type requires "'+l+'" indicator loaded before. Please read docs: https://api.highcharts.com/highstock/plotOptions.'+d}}});r(g,"indicators/indicators.src.js",[g["parts/Globals.js"],g["parts/Utilities.js"],g["mixins/indicator-required.js"]],function(d,p,k){var l=p.isArray,e=p.splat,c=d.pick,b=d.error,a=d.Series,f=d.addEvent;p=d.seriesType;var u=d.seriesTypes,h=d.seriesTypes.ohlc.prototype,
w=k.generateMessage;f(d.Series,"init",function(a){a=a.options;a.useOhlcData&&"highcharts-navigator-series"!==a.id&&d.extend(this,{pointValKey:h.pointValKey,keys:h.keys,pointArrayMap:h.pointArrayMap,toYData:h.toYData})});f(a,"afterSetOptions",function(a){a=a.options;var b=a.dataGrouping;b&&a.useOhlcData&&"highcharts-navigator-series"!==a.id&&(b.approximation="ohlc")});p("sma","line",{name:void 0,tooltip:{valueDecimals:4},linkedTo:void 0,compareToMain:!1,params:{index:0,period:14}},{processData:function(){var b=
this.options.compareToMain,f=this.linkedParent;a.prototype.processData.apply(this,arguments);f&&f.compareValue&&b&&(this.compareValue=f.compareValue)},bindTo:{series:!0,eventName:"updatedData"},hasDerivedData:!0,useCommonDataGrouping:!0,nameComponents:["period"],nameSuffixes:[],calculateOn:"init",requiredIndicators:[],requireIndicators:function(){var a={allLoaded:!0};this.requiredIndicators.forEach(function(b){u[b]?u[b].prototype.requireIndicators():(a.allLoaded=!1,a.needed=b)});return a},init:function(c,
u){function h(){var a=m.points||[],b=(m.xData||[]).length,f=m.getValues(m.linkedParent,m.options.params)||{values:[],xData:[],yData:[]},c=[],u=!0;if(b&&!m.hasGroupedData&&m.visible&&m.points)if(m.cropped){if(m.xAxis){var h=m.xAxis.min;var n=m.xAxis.max}b=m.cropData(f.xData,f.yData,h,n);for(h=0;h<b.xData.length;h++)c.push([b.xData[h]].concat(e(b.yData[h])));b=f.xData.indexOf(m.xData[0]);h=f.xData.indexOf(m.xData[m.xData.length-1]);-1===b&&h===f.xData.length-2&&c[0][0]===a[0].x&&c.shift();m.updateData(c)}else f.xData.length!==
b-1&&f.xData.length!==b+1&&(u=!1,m.updateData(f.values));u&&(m.xData=f.xData,m.yData=f.yData,m.options.data=f.values);!1===m.bindTo.series&&(delete m.processedXData,m.isDirty=!0,m.redraw());m.isDirtyData=!1}var m=this,n=m.requireIndicators();if(!n.allLoaded)return b(w(m.type,n.needed));a.prototype.init.call(m,c,u);c.linkSeries();m.dataEventsToUnbind=[];if(!m.linkedParent)return b("Series "+m.options.linkedTo+" not found! Check `linkedTo`.",!1,c);m.dataEventsToUnbind.push(f(m.bindTo.series?m.linkedParent:
m.linkedParent.xAxis,m.bindTo.eventName,h));if("init"===m.calculateOn)h();else var t=f(m.chart,m.calculateOn,function(){h();t()});return m},getName:function(){var a=this.name,b=[];a||((this.nameComponents||[]).forEach(function(a,f){b.push(this.options.params[a]+c(this.nameSuffixes[f],""))},this),a=(this.nameBase||this.type.toUpperCase())+(this.nameComponents?" ("+b.join(", ")+")":""));return a},getValues:function(a,b){var f=b.period,c=a.xData;a=a.yData;var h=a.length,u=0,e=0,w=[],n=[],t=[],d=-1;if(c.length<
f)return!1;for(l(a[0])&&(d=b.index?b.index:0);u<f-1;)e+=0>d?a[u]:a[u][d],u++;for(b=u;b<h;b++){e+=0>d?a[b]:a[b][d];var k=[c[b],e/f];w.push(k);n.push(k[0]);t.push(k[1]);e-=0>d?a[b-u]:a[b-u][d]}return{values:w,xData:n,yData:t}},destroy:function(){this.dataEventsToUnbind.forEach(function(a){a()});a.prototype.destroy.call(this)}})});r(g,"indicators/accumulation-distribution.src.js",[g["parts/Globals.js"]],function(d){var p=d.seriesType;p("ad","sma",{params:{volumeSeriesID:"volume"}},{nameComponents:!1,
nameBase:"Accumulation/Distribution",getValues:function(k,l){var e=l.period,c=k.xData,b=k.yData,a=l.volumeSeriesID,f=k.chart.get(a);l=f&&f.yData;var u=b?b.length:0,h=[],w=[],t=[];if(c.length<=e&&u&&4!==b[0].length)return!1;if(!f)return d.error("Series "+a+" not found! Check `volumeSeriesID`.",!0,k.chart);for(;e<u;e++){k=h.length;a=b[e][1];f=b[e][2];var n=b[e][3],q=l[e];a=[c[e],n===a&&n===f||a===f?0:(2*n-f-a)/(a-f)*q];0<k&&(a[1]+=h[k-1][1]);h.push(a);w.push(a[0]);t.push(a[1])}return{values:h,xData:w,
yData:t}}})});r(g,"indicators/ao.src.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(d,p){var k=p.isArray,l=d.correctFloat;d.seriesType("ao","sma",{greaterBarColor:"#06B535",lowerBarColor:"#F21313",threshold:0,groupPadding:.2,pointPadding:.2,states:{hover:{halo:{size:0}}}},{nameBase:"AO",nameComponents:!1,markerAttribs:d.noop,getColumnMetrics:d.seriesTypes.column.prototype.getColumnMetrics,crispCol:d.seriesTypes.column.prototype.crispCol,translate:d.seriesTypes.column.prototype.translate,
drawPoints:d.seriesTypes.column.prototype.drawPoints,drawGraph:function(){var e=this.options,c=this.points,b=e.greaterBarColor;e=e.lowerBarColor;var a=c[0];if(!this.userOptions.color&&a)for(a.color=b,a=1;a<c.length;a++)c[a].color=c[a].y>c[a-1].y?b:c[a].y<c[a-1].y?e:c[a-1].color},getValues:function(e){var c=e.xData||[];e=e.yData||[];var b=e.length,a=[],f=[],u=[],h=0,w=0,t;if(34>=c.length||!k(e[0])||4!==e[0].length)return!1;for(t=0;33>t;t++){var n=(e[t][1]+e[t][2])/2;29<=t&&(h=l(h+n));w=l(w+n)}for(t=
33;t<b;t++){n=(e[t][1]+e[t][2])/2;h=l(h+n);w=l(w+n);n=h/5;var d=w/34;n=l(n-d);a.push([c[t],n]);f.push(c[t]);u.push(n);n=t+1-5;d=t+1-34;h=l(h-(e[n][1]+e[n][2])/2);w=l(w-(e[d][1]+e[d][2])/2)}return{values:a,xData:f,yData:u}}})});r(g,"mixins/multipe-lines.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(d,p){var k=p.defined,l=d.each,e=d.merge,c=d.error,b=d.seriesTypes.sma;return{pointArrayMap:["top","bottom"],pointValKey:"top",linesApiNames:["bottomLine"],getTranslatedLinesNames:function(a){var b=
[];l(this.pointArrayMap,function(f){f!==a&&b.push("plot"+f.charAt(0).toUpperCase()+f.slice(1))});return b},toYData:function(a){var b=[];l(this.pointArrayMap,function(f){b.push(a[f])});return b},translate:function(){var a=this,f=a.pointArrayMap,c=[],h;c=a.getTranslatedLinesNames();b.prototype.translate.apply(a,arguments);l(a.points,function(b){l(f,function(f,e){h=b[f];null!==h&&(b[c[e]]=a.yAxis.toPixels(h,!0))})})},drawGraph:function(){var a=this,f=a.linesApiNames,u=a.points,h=u.length,w=a.options,
t=a.graph,n={options:{gapSize:w.gapSize}},d=[],m=a.getTranslatedLinesNames(a.pointValKey),D;l(m,function(a,b){for(d[b]=[];h--;)D=u[h],d[b].push({x:D.x,plotX:D.plotX,plotY:D[a],isNull:!k(D[a])});h=u.length});l(f,function(f,m){d[m]?(a.points=d[m],w[f]?a.options=e(w[f].styles,n):c('Error: "There is no '+f+' in DOCS options declared. Check if linesApiNames are consistent with your DOCS line names." at mixin/multiple-line.js:34'),a.graph=a["graph"+f],b.prototype.drawGraph.call(a),a["graph"+f]=a.graph):
c('Error: "'+f+" doesn't have equivalent in pointArrayMap. To many elements in linesApiNames relative to pointArrayMap.\"")});a.points=u;a.options=w;a.graph=t;b.prototype.drawGraph.call(a)}}});r(g,"indicators/aroon.src.js",[g["parts/Globals.js"],g["mixins/multipe-lines.js"]],function(d,p){function k(d,e){var c=d[0],b=0,a;for(a=1;a<d.length;a++)if("max"===e&&d[a]>=c||"min"===e&&d[a]<=c)c=d[a],b=a;return b}d.seriesType("aroon","sma",{params:{period:25},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Aroon Up: {point.y}<br/>Aroon Down: {point.aroonDown}<br/>'},
aroonDown:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}},d.merge(p,{nameBase:"Aroon",pointArrayMap:["y","aroonDown"],pointValKey:"y",linesApiNames:["aroonDown"],getValues:function(l,e){e=e.period;var c=l.xData,b=(l=l.yData)?l.length:0,a=[],f=[],u=[],h;for(h=e-1;h<b;h++){var w=l.slice(h-e+1,h+2);var t=k(w.map(function(a){return d.pick(a[2],a)}),"min");w=k(w.map(function(a){return d.pick(a[1],a)}),"max");w=w/e*100;t=t/e*100;c[h+1]&&(a.push([c[h+1],w,t]),f.push(c[h+
1]),u.push([w,t]))}return{values:a,xData:f,yData:u}}}))});r(g,"indicators/aroon-oscillator.src.js",[g["parts/Globals.js"],g["mixins/multipe-lines.js"],g["mixins/indicator-required.js"]],function(d,p,k){var l=d.seriesTypes.aroon;d.seriesType("aroonoscillator","aroon",{params:{period:25},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b>: {point.y}'}},d.merge(p,{nameBase:"Aroon Oscillator",pointArrayMap:["y"],pointValKey:"y",linesApiNames:[],init:function(){var e=
arguments,c=this;k.isParentLoaded(l,"aroon",c.type,function(b){b.prototype.init.apply(c,e)})},getValues:function(e,c){var b=[],a=[],f=[];e=l.prototype.getValues.call(this,e,c);for(c=0;c<e.yData.length;c++){var u=e.yData[c][0];var h=e.yData[c][1];u-=h;b.push([e.xData[c],u]);a.push(e.xData[c]);f.push(u)}return{values:b,xData:a,yData:f}}}))});r(g,"indicators/atr.src.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(d,p){function k(c,b){return Math.max(c[1]-c[2],b===e?0:Math.abs(c[1]-b[3]),
b===e?0:Math.abs(c[2]-b[3]))}var l=p.isArray;d=d.seriesType;var e;d("atr","sma",{params:{period:14}},{getValues:function(c,b){b=b.period;var a=c.xData,f=(c=c.yData)?c.length:0,e=1,h=0,w=0,d=[],n=[],q=[],m;var D=[[a[0],c[0]]];if(a.length<=b||!l(c[0])||4!==c[0].length)return!1;for(m=1;m<=f;m++)if(D.push([a[m],c[m]]),b<e){var y=b;var p=a[m-1],g=k(c[m-1],c[m-2]);y=[p,(h*(y-1)+g)/y];h=y[1];d.push(y);n.push(y[0]);q.push(y[1])}else b===e?(h=w/(m-1),d.push([a[m-1],h]),n.push(a[m-1]),q.push(h)):w+=k(c[m-1],
c[m-2]),e++;return{values:d,xData:n,yData:q}}})});r(g,"indicators/bollinger-bands.src.js",[g["parts/Globals.js"],g["parts/Utilities.js"],g["mixins/multipe-lines.js"]],function(d,p,k){var l=p.isArray,e=d.merge,c=d.seriesTypes.sma;d.seriesType("bb","sma",{params:{period:20,standardDeviation:2,index:3},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},
marker:{enabled:!1},dataGrouping:{approximation:"averages"}},d.merge(k,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameComponents:["period","standardDeviation"],linesApiNames:["topLine","bottomLine"],init:function(){c.prototype.init.apply(this,arguments);this.options=e({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)},getValues:function(b,a){var f=a.period,e=a.standardDeviation,h=b.xData,w=(b=b.yData)?b.length:0,d=[],n=[],q=[],m;
if(h.length<f)return!1;var D=l(b[0]);for(m=f;m<=w;m++){var y=h.slice(m-f,m);var k=b.slice(m-f,m);var p=c.prototype.getValues.call(this,{xData:y,yData:k},a);y=p.xData[0];p=p.yData[0];for(var g=0,z=k.length,v=0;v<z;v++){var A=(D?k[v][a.index]:k[v])-p;g+=A*A}A=Math.sqrt(g/(z-1));k=p+e*A;A=p-e*A;d.push([y,k,p,A]);n.push(y);q.push([k,p,A])}return{values:d,xData:n,yData:q}}}))});r(g,"indicators/cci.src.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(d,p){function k(e){return e.reduce(function(c,
b){return c+b},0)}var l=p.isArray;d=d.seriesType;d("cci","sma",{params:{period:14}},{getValues:function(e,c){c=c.period;var b=e.xData,a=(e=e.yData)?e.length:0,f=[],u=1,h=[],w=[],d=[];if(b.length<=c||!l(e[0])||4!==e[0].length)return!1;for(;u<c;){var n=e[u-1];f.push((n[1]+n[2]+n[3])/3);u++}for(u=c;u<=a;u++){n=e[u-1];n=(n[1]+n[2]+n[3])/3;var q=f.push(n);var m=f.slice(q-c);q=k(m)/c;var D,y=m.length,p=0;for(D=0;D<y;D++)p+=Math.abs(q-m[D]);m=p/c;n=(n-q)/(.015*m);h.push([b[u-1],n]);w.push(b[u-1]);d.push(n)}return{values:h,
xData:w,yData:d}}})});r(g,"indicators/cmf.src.js",[g["parts/Globals.js"]],function(d){d.seriesType("cmf","sma",{params:{period:14,volumeSeriesID:"volume"}},{nameBase:"Chaikin Money Flow",isValid:function(){var d=this.chart,k=this.options,l=this.linkedParent;d=this.volumeSeries||(this.volumeSeries=d.get(k.params.volumeSeriesID));var e=l&&l.yData&&4===l.yData[0].length;return!!(l&&d&&l.xData&&l.xData.length>=k.params.period&&d.xData&&d.xData.length>=k.params.period&&e)},getValues:function(d,k){return this.isValid()?
this.getMoneyFlow(d.xData,d.yData,this.volumeSeries.yData,k.period):!1},getMoneyFlow:function(d,k,l,e){function c(a,b){var f=a[1],c=a[2];a=a[3];return null!==b&&null!==f&&null!==c&&null!==a&&f!==c?(a-c-(f-a))/(f-c)*b:(q=n,null)}var b=k.length,a=[],f=0,u=0,h=[],w=[],t=[],n,q=-1;if(0<e&&e<=b){for(n=0;n<e;n++)a[n]=c(k[n],l[n]),f+=l[n],u+=a[n];h.push(d[n-1]);w.push(n-q>=e&&0!==f?u/f:null);for(t.push([h[0],w[0]]);n<b;n++){a[n]=c(k[n],l[n]);f-=l[n-e];f+=l[n];u-=a[n-e];u+=a[n];var m=[d[n],n-q>=e?u/f:null];
h.push(m[0]);w.push(m[1]);t.push([m[0],m[1]])}}return{values:t,xData:h,yData:w}}})});r(g,"indicators/dpo.src.js",[g["parts/Globals.js"]],function(d){function g(e,c,b,a,f){c=l(c[b][a],c[b]);return f?k(e-c):k(e+c)}var k=d.correctFloat,l=d.pick;d.seriesType("dpo","sma",{params:{period:21}},{nameBase:"DPO",getValues:function(e,c){var b=c.period;c=c.index;var a=b+Math.floor(b/2+1),f=e.xData||[];e=e.yData||[];var u=e.length,h=[],d=[],t=[],n=0,q,m;if(f.length<=a)return!1;for(q=0;q<b-1;q++)n=g(n,e,q,c);for(m=
0;m<=u-a;m++){var D=m+b-1;q=m+a-1;n=g(n,e,D,c);D=l(e[q][c],e[q]);D-=n/b;n=g(n,e,m,c,!0);h.push([f[q],D]);d.push(f[q]);t.push(D)}return{values:h,xData:d,yData:t}}})});r(g,"indicators/ema.src.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(d,g){var k=g.isArray;g=d.seriesType;var l=d.correctFloat;g("ema","sma",{params:{index:3,period:9}},{accumulatePeriodPoints:function(e,c,b){for(var a=0,f=0,u;f<e;)u=0>c?b[f]:b[f][c],a+=u,f++;return a},calculateEma:function(e,c,b,a,f,u,h){e=e[b-1];c=0>
u?c[b-1]:c[b-1][u];a=void 0===f?h:l(c*a+f*(1-a));return[e,a]},getValues:function(e,c){var b=c.period,a=e.xData,f=(e=e.yData)?e.length:0,u=2/(b+1),h=[],d=[],t=[],n=-1;if(f<b)return!1;k(e[0])&&(n=c.index?c.index:0);for(c=this.accumulatePeriodPoints(b,n,e)/b;b<f+1;b++){var l=this.calculateEma(a,e,b,u,l,n,c);h.push(l);d.push(l[0]);t.push(l[1]);l=l[1]}return{values:h,xData:d,yData:t}}})});r(g,"indicators/chaikin.src.js",[g["parts/Globals.js"],g["mixins/indicator-required.js"]],function(d,g){var k=d.seriesTypes.ema,
l=d.seriesTypes.ad,e=d.error,c=d.correctFloat;d.seriesType("chaikin","ema",{params:{volumeSeriesID:"volume",periods:[3,10]}},{nameBase:"Chaikin Osc",nameComponents:["periods"],init:function(){var b=arguments,a=this;g.isParentLoaded(k,"ema",a.type,function(f){f.prototype.init.apply(a,b)})},getValues:function(b,a){var f=a.periods,u=a.period,h=[],d=[],t=[],n;if(2!==f.length||f[1]<=f[0])return e('Error: "Chaikin requires two periods. Notice, first period should be lower than the second one."'),!1;a=l.prototype.getValues.call(this,
b,{volumeSeriesID:a.volumeSeriesID,period:u});if(!a)return!1;b=k.prototype.getValues.call(this,a,{period:f[0]});a=k.prototype.getValues.call(this,a,{period:f[1]});if(!b||!a)return!1;f=f[1]-f[0];for(n=0;n<a.yData.length;n++)u=c(b.yData[n+f]-a.yData[n]),h.push([a.xData[n],u]),d.push(a.xData[n]),t.push(u);return{values:h,xData:d,yData:t}}})});r(g,"indicators/dema.src.js",[g["parts/Globals.js"],g["parts/Utilities.js"],g["mixins/indicator-required.js"]],function(d,g,k){var l=g.isArray,e=d.seriesTypes.ema,
c=d.correctFloat;d.seriesType("dema","ema",{},{init:function(){var b=arguments,a=this;k.isParentLoaded(e,"ema",a.type,function(f){f.prototype.init.apply(a,b)})},getEMA:function(b,a,f,c,h,d){return e.prototype.calculateEma(d||[],b,void 0===h?1:h,this.chart.series[0].EMApercent,a,void 0===c?-1:c,f)},getValues:function(b,a){var f=a.period,u=2*f,h=b.xData,d=b.yData,t=d?d.length:0,n=-1,q=[],m=[],D=[],y=0,g=[],k;b.EMApercent=2/(f+1);if(t<2*f-1)return!1;l(d[0])&&(n=a.index?a.index:0);b=e.prototype.accumulatePeriodPoints(f,
n,d);a=b/f;b=0;for(k=f;k<t+2;k++){k<t+1&&(y=this.getEMA(d,p,a,n,k)[1],g.push(y));var p=y;if(k<u)b+=y;else{k===u&&(a=b/f);y=g[k-f-1];var z=this.getEMA([y],z,a)[1];var v=[h[k-2],c(2*y-z)];q.push(v);m.push(v[0]);D.push(v[1])}}return{values:q,xData:m,yData:D}}})});r(g,"indicators/tema.src.js",[g["parts/Globals.js"],g["parts/Utilities.js"],g["mixins/indicator-required.js"]],function(d,g,k){var l=g.isArray,e=d.seriesTypes.ema,c=d.correctFloat;d.seriesType("tema","ema",{},{init:function(){var b=arguments,
a=this;k.isParentLoaded(e,"ema",a.type,function(f){f.prototype.init.apply(a,b)})},getEMA:function(b,a,f,c,h,d){return e.prototype.calculateEma(d||[],b,void 0===h?1:h,this.chart.series[0].EMApercent,a,void 0===c?-1:c,f)},getTemaPoint:function(b,a,f,e){return[b[e-3],c(3*f.level1-3*f.level2+f.level3)]},getValues:function(b,a){var f=a.period,c=2*f,h=3*f,d=b.xData,t=b.yData,n=t?t.length:0,q=-1,m=[],D=[],y=[],k=[],g=[],p,z,v={};b.EMApercent=2/(f+1);if(n<3*f-2)return!1;l(t[0])&&(q=a.index?a.index:0);b=e.prototype.accumulatePeriodPoints(f,
q,t);a=b/f;b=0;for(p=f;p<n+3;p++){p<n+1&&(v.level1=this.getEMA(t,A,a,q,p)[1],k.push(v.level1));var A=v.level1;if(p<c)b+=v.level1;else{p===c&&(a=b/f,b=0);v.level1=k[p-f-1];v.level2=this.getEMA([v.level1],C,a)[1];g.push(v.level2);var C=v.level2;if(p<h)b+=v.level2;else{p===h&&(a=b/f);p===n+1&&(v.level1=k[p-f-1],v.level2=this.getEMA([v.level1],C,a)[1],g.push(v.level2));v.level1=k[p-f-2];v.level2=g[p-2*f-1];v.level3=this.getEMA([v.level2],v.prevLevel3,a)[1];if(z=this.getTemaPoint(d,h,v,p))m.push(z),D.push(z[0]),
y.push(z[1]);v.prevLevel3=v.level3}}}return{values:m,xData:D,yData:y}}})});r(g,"indicators/trix.src.js",[g["parts/Globals.js"],g["mixins/indicator-required.js"]],function(d,g){var k=d.correctFloat,l=d.seriesTypes.tema;d.seriesType("trix","tema",{},{init:function(){var e=arguments,c=this;g.isParentLoaded(l,"tema",c.type,function(b){b.prototype.init.apply(c,e)})},getTemaPoint:function(e,c,b,a){if(a>c)var f=[e[a-3],0!==b.prevLevel3?k(b.level3-b.prevLevel3)/b.prevLevel3*100:null];return f}})});r(g,"indicators/apo.src.js",
[g["parts/Globals.js"],g["mixins/indicator-required.js"]],function(d,g){var k=d.seriesTypes.ema,l=d.error;d.seriesType("apo","ema",{params:{periods:[10,20]}},{nameBase:"APO",nameComponents:["periods"],init:function(){var e=arguments,c=this;g.isParentLoaded(k,"ema",c.type,function(b){b.prototype.init.apply(c,e)})},getValues:function(e,c){var b=c.periods,a=c.index;c=[];var f=[],u=[],h;if(2!==b.length||b[1]<=b[0])return l('Error: "APO requires two periods. Notice, first period should be lower than the second one."'),
!1;var d=k.prototype.getValues.call(this,e,{index:a,period:b[0]});e=k.prototype.getValues.call(this,e,{index:a,period:b[1]});if(!d||!e)return!1;b=b[1]-b[0];for(h=0;h<e.yData.length;h++)a=d.yData[h+b]-e.yData[h],c.push([e.xData[h],a]),f.push(e.xData[h]),u.push(a);return{values:c,xData:f,yData:u}}})});r(g,"indicators/ichimoku-kinko-hyo.src.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(d,g){function k(a){return a.reduce(function(a,b){return Math.max(a,b[1])},-Infinity)}function l(a){return a.reduce(function(a,
b){return Math.min(a,b[2])},Infinity)}function e(a){return{high:k(a),low:l(a)}}function c(a){var b,f,c,m,e;a.series.forEach(function(a){if(a.xData)for(m=a.xData,e=f=a.xIncrement?1:m.length-1;0<e;e--)if(c=m[e]-m[e-1],b===w||c<b)b=c});return b}function b(a,b,f,c){if(a&&b&&f&&c){var m=b.plotX-a.plotX;b=b.plotY-a.plotY;var e=c.plotX-f.plotX;c=c.plotY-f.plotY;var h=a.plotX-f.plotX,d=a.plotY-f.plotY;f=(-b*h+m*d)/(-e*b+m*c);e=(e*d-c*h)/(-e*b+m*c);if(0<=f&&1>=f&&0<=e&&1>=e)return{plotX:a.plotX+e*m,plotY:a.plotY+
e*b}}return!1}function a(a){var b=a.indicator;b.points=a.points;b.nextPoints=a.nextPoints;b.color=a.color;b.options=t(a.options.senkouSpan.styles,a.gap);b.graph=a.graph;b.fillGraph=!0;q.prototype.drawGraph.call(b)}var f=g.defined,u=g.isArray,h=g.objectEach,w;g=d.seriesType;var t=d.merge,n=d.color,q=d.seriesTypes.sma;d.approximations["ichimoku-averages"]=function(){var a=[],b;[].forEach.call(arguments,function(f,c){a.push(d.approximations.average(f));b=!b&&void 0===a[c]});return b?void 0:a};g("ikh",
"sma",{params:{period:26,periodTenkan:9,periodSenkouSpanB:52},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>TENKAN SEN: {point.tenkanSen:.3f}<br/>KIJUN SEN: {point.kijunSen:.3f}<br/>CHIKOU SPAN: {point.chikouSpan:.3f}<br/>SENKOU SPAN A: {point.senkouSpanA:.3f}<br/>SENKOU SPAN B: {point.senkouSpanB:.3f}<br/>'},tenkanLine:{styles:{lineWidth:1,lineColor:void 0}},kijunLine:{styles:{lineWidth:1,lineColor:void 0}},chikouLine:{styles:{lineWidth:1,
lineColor:void 0}},senkouSpanA:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanB:{styles:{lineWidth:1,lineColor:void 0}},senkouSpan:{styles:{fill:"rgba(255, 0, 0, 0.5)"}},dataGrouping:{approximation:"ichimoku-averages"}},{pointArrayMap:["tenkanSen","kijunSen","chikouSpan","senkouSpanA","senkouSpanB"],pointValKey:"tenkanSen",nameComponents:["periodSenkouSpanB","period","periodTenkan"],init:function(){q.prototype.init.apply(this,arguments);this.options=t({tenkanLine:{styles:{lineColor:this.color}},
kijunLine:{styles:{lineColor:this.color}},chikouLine:{styles:{lineColor:this.color}},senkouSpanA:{styles:{lineColor:this.color,fill:n(this.color).setOpacity(.5).get()}},senkouSpanB:{styles:{lineColor:this.color,fill:n(this.color).setOpacity(.5).get()}},senkouSpan:{styles:{fill:n(this.color).setOpacity(.2).get()}}},this.options)},toYData:function(a){return[a.tenkanSen,a.kijunSen,a.chikouSpan,a.senkouSpanA,a.senkouSpanB]},translate:function(){var a=this;q.prototype.translate.apply(a);a.points.forEach(function(b){a.pointArrayMap.forEach(function(c){f(b[c])&&
(b["plot"+c]=a.yAxis.toPixels(b[c],!0),b.plotY=b["plot"+c],b.tooltipPos=[b.plotX,b["plot"+c]],b.isNull=!1)})})},drawGraph:function(){var c=this,e=c.points,d=e.length,u=c.options,n=c.graph,w=c.color,l={options:{gapSize:u.gapSize}},g=c.pointArrayMap.length,k=[[],[],[],[],[],[]],p={tenkanLine:k[0],kijunLine:k[1],chikouLine:k[2],senkouSpanA:k[3],senkouSpanB:k[4],senkouSpan:k[5]},r=[],B=c.options.senkouSpan,H=B.color||B.styles.fill,N=B.negativeColor,M=[[],[]],K=[[],[]],O=0,J,P,L;for(c.ikhMap=p;d--;){var E=
e[d];for(J=0;J<g;J++)B=c.pointArrayMap[J],f(E[B])&&k[J].push({plotX:E.plotX,plotY:E["plot"+B],isNull:!1});N&&d!==e.length-1&&(B=p.senkouSpanB.length-1,E=b(p.senkouSpanA[B-1],p.senkouSpanA[B],p.senkouSpanB[B-1],p.senkouSpanB[B]),J={plotX:E.plotX,plotY:E.plotY,isNull:!1,intersectPoint:!0},E&&(p.senkouSpanA.splice(B,0,J),p.senkouSpanB.splice(B,0,J),r.push(B)))}h(p,function(a,b){u[b]&&"senkouSpan"!==b&&(c.points=k[O],c.options=t(u[b].styles,l),c.graph=c["graph"+b],c.fillGraph=!1,c.color=w,q.prototype.drawGraph.call(c),
c["graph"+b]=c.graph);O++});c.graphCollection&&c.graphCollection.forEach(function(a){c[a].destroy();delete c[a]});c.graphCollection=[];if(N&&p.senkouSpanA[0]&&p.senkouSpanB[0]){r.unshift(0);r.push(p.senkouSpanA.length-1);for(g=0;g<r.length-1;g++){B=r[g];E=r[g+1];d=p.senkouSpanB.slice(B,E+1);B=p.senkouSpanA.slice(B,E+1);if(1<=Math.floor(d.length/2))if(E=Math.floor(d.length/2),d[E].plotY===B[E].plotY){for(L=J=E=0;L<d.length;L++)E+=d[L].plotY,J+=B[L].plotY;E=E>J?0:1}else E=d[E].plotY>B[E].plotY?0:1;
else E=d[0].plotY>B[0].plotY?0:1;M[E]=M[E].concat(d);K[E]=K[E].concat(B)}["graphsenkouSpanColor","graphsenkouSpanNegativeColor"].forEach(function(b,f){M[f].length&&K[f].length&&(P=0===f?H:N,a({indicator:c,points:M[f],nextPoints:K[f],color:P,options:u,gap:l,graph:c[b]}),c[b]=c.graph,c.graphCollection.push(b))})}else a({indicator:c,points:p.senkouSpanB,nextPoints:p.senkouSpanA,color:H,options:u,gap:l,graph:c.graphsenkouSpan}),c.graphsenkouSpan=c.graph;delete c.nextPoints;delete c.fillGraph;c.points=
e;c.options=u;c.graph=n},getGraphPath:function(a){var b=[];a=a||this.points;if(this.fillGraph&&this.nextPoints){var c=q.prototype.getGraphPath.call(this,this.nextPoints);c[0]="L";var f=q.prototype.getGraphPath.call(this,a);c=c.slice(0,f.length);for(var e=c.length-1;0<e;e-=3)b.push(c[e-2],c[e-1],c[e]);f=f.concat(b)}else f=q.prototype.getGraphPath.apply(this,arguments);return f},getValues:function(a,b){var f=b.period,h=b.periodTenkan;b=b.periodSenkouSpanB;var d=a.xData,n=a.yData,m=n&&n.length||0;a=
c(a.xAxis);var l=[],t=[],q;if(d.length<=f||!u(n[0])||4!==n[0].length)return!1;var g=d[0]-f*a;for(q=0;q<f;q++)t.push(g+q*a);for(q=0;q<m;q++){if(q>=h){var k=n.slice(q-h,q);k=e(k);k=(k.high+k.low)/2}if(q>=f){var p=n.slice(q-f,q);p=e(p);p=(p.high+p.low)/2;var D=(k+p)/2}if(q>=b){var r=n.slice(q-b,q);r=e(r);r=(r.high+r.low)/2}g=n[q][3];var K=d[q];l[q]===w&&(l[q]=[]);l[q+f]===w&&(l[q+f]=[]);l[q+f][0]=k;l[q+f][1]=p;l[q+f][2]=w;l[q][2]=g;q<=f&&(l[q+f][3]=w,l[q+f][4]=w);l[q+2*f]===w&&(l[q+2*f]=[]);l[q+2*f][3]=
D;l[q+2*f][4]=r;t.push(K)}for(q=1;q<=f;q++)t.push(K+q*a);return{values:l,xData:t,yData:l}}})});r(g,"indicators/keltner-channels.src.js",[g["parts/Globals.js"],g["mixins/multipe-lines.js"]],function(d,g){var k=d.seriesTypes.sma,l=d.seriesTypes.ema,e=d.seriesTypes.atr,c=d.merge,b=d.correctFloat;d.seriesType("keltnerchannels","sma",{params:{period:20,periodATR:10,multiplierATR:2},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Upper Channel: {point.top}<br/>EMA({series.options.params.period}): {point.middle}<br/>Lower Channel: {point.bottom}<br/>'},
marker:{enabled:!1},dataGrouping:{approximation:"averages"},lineWidth:1},c(g,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameBase:"Keltner Channels",nameComponents:["period","periodATR","multiplierATR"],linesApiNames:["topLine","bottomLine"],requiredIndicators:["ema","atr"],init:function(){k.prototype.init.apply(this,arguments);this.options=c({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)},getValues:function(a,c){var f=c.period,
h=c.periodATR,d=c.multiplierATR,t=a.yData;t=t?t.length:0;var n=[];c=l.prototype.getValues(a,{period:f,index:c.index});var q=e.prototype.getValues(a,{period:h}),m=[],g=[],k;if(t<f)return!1;for(k=f;k<=t;k++){var p=c.values[k-f];var r=q.values[k-h];var x=p[0];a=b(p[1]+d*r[1]);r=b(p[1]-d*r[1]);p=p[1];n.push([x,a,p,r]);m.push(x);g.push([a,p,r])}return{values:n,xData:m,yData:g}}}))});r(g,"indicators/macd.src.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(d,g){var k=g.defined;g=d.seriesType;
var l=d.merge,e=d.seriesTypes.sma,c=d.seriesTypes.ema,b=d.correctFloat;g("macd","sma",{params:{shortPeriod:12,longPeriod:26,signalPeriod:9,period:26},signalLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},macdLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},threshold:0,groupPadding:.1,pointPadding:.1,states:{hover:{halo:{size:0}}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Value: {point.MACD}<br/>Signal: {point.signal}<br/>Histogram: {point.y}<br/>'},
dataGrouping:{approximation:"averages"},minPointLength:0},{nameComponents:["longPeriod","shortPeriod","signalPeriod"],requiredIndicators:["ema"],pointArrayMap:["y","signal","MACD"],parallelArrays:["x","y","signal","MACD"],pointValKey:"y",markerAttribs:d.noop,getColumnMetrics:d.seriesTypes.column.prototype.getColumnMetrics,crispCol:d.seriesTypes.column.prototype.crispCol,init:function(){e.prototype.init.apply(this,arguments);this.options&&(this.options=l({signalLine:{styles:{lineColor:this.color}},
macdLine:{styles:{color:this.color}}},this.options),this.macdZones={zones:this.options.macdLine.zones,startIndex:0},this.signalZones={zones:this.macdZones.zones.concat(this.options.signalLine.zones),startIndex:this.macdZones.zones.length},this.resetZones=!0)},toYData:function(a){return[a.y,a.signal,a.MACD]},translate:function(){var a=this,b=["plotSignal","plotMACD"];d.seriesTypes.column.prototype.translate.apply(a);a.points.forEach(function(c){[c.signal,c.MACD].forEach(function(f,e){null!==f&&(c[b[e]]=
a.yAxis.toPixels(f,!0))})})},destroy:function(){this.graph=null;this.graphmacd=this.graphmacd&&this.graphmacd.destroy();this.graphsignal=this.graphsignal&&this.graphsignal.destroy();e.prototype.destroy.apply(this,arguments)},drawPoints:d.seriesTypes.column.prototype.drawPoints,drawGraph:function(){for(var a=this,b=a.points,c=b.length,h=a.options,d=a.zones,t={options:{gapSize:h.gapSize}},n=[[],[]],q;c--;)q=b[c],k(q.plotMACD)&&n[0].push({plotX:q.plotX,plotY:q.plotMACD,isNull:!k(q.plotMACD)}),k(q.plotSignal)&&
n[1].push({plotX:q.plotX,plotY:q.plotSignal,isNull:!k(q.plotMACD)});["macd","signal"].forEach(function(b,c){a.points=n[c];a.options=l(h[b+"Line"].styles,t);a.graph=a["graph"+b];a.currentLineZone=b+"Zones";a.zones=a[a.currentLineZone].zones;e.prototype.drawGraph.call(a);a["graph"+b]=a.graph});a.points=b;a.options=h;a.zones=d;a.currentLineZone=null},getZonesGraphs:function(a){var b=e.prototype.getZonesGraphs.call(this,a),c=b;this.currentLineZone&&(c=b.splice(this[this.currentLineZone].startIndex+1),
c.length?c.splice(0,0,a[0]):c=[a[0]]);return c},applyZones:function(){var a=this.zones;this.zones=this.signalZones.zones;e.prototype.applyZones.call(this);this.options.macdLine.zones.length&&this.graphmacd.hide();this.zones=a},getValues:function(a,f){var e=0,h=[],d=[],l=[];if(a.xData.length<f.longPeriod+f.signalPeriod)return!1;var n=c.prototype.getValues(a,{period:f.shortPeriod});var q=c.prototype.getValues(a,{period:f.longPeriod});n=n.values;q=q.values;for(a=1;a<=n.length;a++)k(q[a-1])&&k(q[a-1][1])&&
k(n[a+f.shortPeriod+1])&&k(n[a+f.shortPeriod+1][0])&&h.push([n[a+f.shortPeriod+1][0],0,null,n[a+f.shortPeriod+1][1]-q[a-1][1]]);for(a=0;a<h.length;a++)d.push(h[a][0]),l.push([0,null,h[a][3]]);f=c.prototype.getValues({xData:d,yData:l},{period:f.signalPeriod,index:2});f=f.values;for(a=0;a<h.length;a++)h[a][0]>=f[0][0]&&(h[a][2]=f[e][1],l[a]=[0,f[e][1],h[a][3]],null===h[a][3]?(h[a][1]=0,l[a][0]=0):(h[a][1]=b(h[a][3]-f[e][1]),l[a][0]=b(h[a][3]-f[e][1])),e++);return{values:h,xData:d,yData:l}}})});r(g,
"indicators/mfi.src.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(d,g){function k(c){return c.reduce(function(b,a){return b+a})}function l(c){return(c[1]+c[2]+c[3])/3}var e=g.isArray;d.seriesType("mfi","sma",{params:{period:14,volumeSeriesID:"volume",decimals:4}},{nameBase:"Money Flow Index",getValues:function(c,b){var a=b.period,f=c.xData,u=c.yData,h=u?u.length:0,w=b.decimals,t=1,n=c.chart.get(b.volumeSeriesID),q=n&&n.yData,m=[],g=[],p=[],F=[],r=[];if(!n)return d.error("Series "+b.volumeSeriesID+
" not found! Check `volumeSeriesID`.",!0,c.chart);if(f.length<=a||!e(u[0])||4!==u[0].length||!q)return!1;for(c=l(u[t]);t<a+1;)b=c,c=l(u[t]),b=c>=b,n=c*q[t],F.push(b?n:0),r.push(b?0:n),t++;for(a=t-1;a<h;a++)a>t-1&&(F.shift(),r.shift(),b=c,c=l(u[a]),b=c>b,n=c*q[a],F.push(b?n:0),r.push(b?0:n)),b=k(r),n=k(F),b=n/b,b=parseFloat((100-100/(1+b)).toFixed(w)),m.push([f[a],b]),g.push(f[a]),p.push(b);return{values:m,xData:g,yData:p}}})});r(g,"indicators/momentum.src.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],
function(d,g){function k(e,c,b,a,f){b=b[a-1][3]-b[a-f-1][3];c=c[a-1];e.shift();return[c,b]}var l=g.isArray;d=d.seriesType;d("momentum","sma",{params:{period:14}},{nameBase:"Momentum",getValues:function(e,c){c=c.period;var b=e.xData,a=(e=e.yData)?e.length:0,f=b[0],d=[],h=[],w=[];if(b.length<=c||!l(e[0]))return!1;var t=[[f,e[0][3]]];for(f=c+1;f<a;f++){var n=k(t,b,e,f,c,void 0);d.push(n);h.push(n[0]);w.push(n[1])}n=k(t,b,e,f,c,void 0);d.push(n);h.push(n[0]);w.push(n[1]);return{values:d,xData:h,yData:w}}})});
r(g,"indicators/natr.src.js",[g["parts/Globals.js"]],function(d){var g=d.seriesTypes.atr;d.seriesType("natr","sma",{tooltip:{valueSuffix:"%"}},{requiredIndicators:["atr"],getValues:function(d,l){for(var e=g.prototype.getValues.apply(this,arguments),c=e.values.length,b=l.period-1,a=d.yData,f=0;f<c;f++)e.yData[f]=e.values[f][1]/a[b][3]*100,e.values[f][1]=e.yData[f],b++;return e}})});r(g,"indicators/pivot-points.src.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(d,g){function k(b,a){var f=
b.series.pointArrayMap,e=f.length;for(c.prototype.pointClass.prototype[a].call(b);e--;)a="dataLabel"+f[e],b[a]&&b[a].element&&b[a].destroy(),b[a]=null}var l=g.defined,e=g.isArray,c=d.seriesTypes.sma;d.seriesType("pivotpoints","sma",{params:{period:28,algorithm:"standard"},marker:{enabled:!1},enableMouseTracking:!1,dataLabels:{enabled:!0,format:"{point.pivotLine}"},dataGrouping:{approximation:"averages"}},{nameBase:"Pivot Points",pointArrayMap:"R4 R3 R2 R1 P S1 S2 S3 S4".split(" "),pointValKey:"P",
toYData:function(b){return[b.P]},translate:function(){var b=this;c.prototype.translate.apply(b);b.points.forEach(function(a){b.pointArrayMap.forEach(function(c){l(a[c])&&(a["plot"+c]=b.yAxis.toPixels(a[c],!0))})});b.plotEndPoint=b.xAxis.toPixels(b.endPoint,!0)},getGraphPath:function(b){for(var a=this,f=b.length,e=[[],[],[],[],[],[],[],[],[]],d=[],w=a.plotEndPoint,t=a.pointArrayMap.length,n,q,m;f--;){q=b[f];for(m=0;m<t;m++)n=a.pointArrayMap[m],l(q[n])&&e[m].push({plotX:q.plotX,plotY:q["plot"+n],isNull:!1},
{plotX:w,plotY:q["plot"+n],isNull:!1},{plotX:w,plotY:null,isNull:!0});w=q.plotX}e.forEach(function(b){d=d.concat(c.prototype.getGraphPath.call(a,b))});return d},drawDataLabels:function(){var b=this,a=b.pointArrayMap,f,e,d;if(b.options.dataLabels.enabled){var l=b.points.length;a.concat([!1]).forEach(function(h,n){for(d=l;d--;)e=b.points[d],h?(e.y=e[h],e.pivotLine=h,e.plotY=e["plot"+h],f=e["dataLabel"+h],n&&(e["dataLabel"+a[n-1]]=e.dataLabel),e.dataLabels||(e.dataLabels=[]),e.dataLabels[0]=e.dataLabel=
f=f&&f.element?f:null):e["dataLabel"+a[n-1]]=e.dataLabel;c.prototype.drawDataLabels.apply(b,arguments)})}},getValues:function(b,a){var c=a.period,d=b.xData,h=(b=b.yData)?b.length:0;a=this[a.algorithm+"Placement"];var l=[],g=[],n=[],q;if(d.length<c||!e(b[0])||4!==b[0].length)return!1;for(q=c+1;q<=h+c;q+=c){var m=d.slice(q-c-1,q);var k=b.slice(q-c-1,q);var p=m.length;var F=m[p-1];k=this.getPivotAndHLC(k);k=a(k);k=l.push([F].concat(k));g.push(F);n.push(l[k-1].slice(1))}this.endPoint=m[0]+(F-m[0])/p*
c;return{values:l,xData:g,yData:n}},getPivotAndHLC:function(b){var a=-Infinity,c=Infinity,e=b[b.length-1][3];b.forEach(function(b){a=Math.max(a,b[1]);c=Math.min(c,b[2])});return[(a+c+e)/3,a,c,e]},standardPlacement:function(b){var a=b[1]-b[2];return[null,null,b[0]+a,2*b[0]-b[2],b[0],2*b[0]-b[1],b[0]-a,null,null]},camarillaPlacement:function(b){var a=b[1]-b[2];return[b[3]+1.5*a,b[3]+1.25*a,b[3]+1.1666*a,b[3]+1.0833*a,b[0],b[3]-1.0833*a,b[3]-1.1666*a,b[3]-1.25*a,b[3]-1.5*a]},fibonacciPlacement:function(b){var a=
b[1]-b[2];return[null,b[0]+a,b[0]+.618*a,b[0]+.382*a,b[0],b[0]-.382*a,b[0]-.618*a,b[0]-a,null]}},{destroyElements:function(){k(this,"destroyElements")},destroy:function(){k(this,"destroyElements")}})});r(g,"indicators/ppo.src.js",[g["parts/Globals.js"],g["mixins/indicator-required.js"]],function(d,g){var k=d.seriesTypes.ema,l=d.error,e=d.correctFloat;d.seriesType("ppo","ema",{params:{periods:[12,26]}},{nameBase:"PPO",nameComponents:["periods"],init:function(){var c=arguments,b=this;g.isParentLoaded(k,
"ema",b.type,function(a){a.prototype.init.apply(b,c)})},getValues:function(c,b){var a=b.periods,f=b.index;b=[];var d=[],h=[],g;if(2!==a.length||a[1]<=a[0])return l('Error: "PPO requires two periods. Notice, first period should be lower than the second one."'),!1;var t=k.prototype.getValues.call(this,c,{index:f,period:a[0]});c=k.prototype.getValues.call(this,c,{index:f,period:a[1]});if(!t||!c)return!1;a=a[1]-a[0];for(g=0;g<c.yData.length;g++)f=e((t.yData[g+a]-c.yData[g])/c.yData[g]*100),b.push([c.xData[g],
f]),d.push(c.xData[g]),h.push(f);return{values:b,xData:d,yData:h}}})});r(g,"mixins/reduce-array.js",[g["parts/Globals.js"]],function(d){var g=d.reduce;return{minInArray:function(d,l){return g(d,function(e,c){return Math.min(e,c[l])},Number.MAX_VALUE)},maxInArray:function(d,l){return g(d,function(e,c){return Math.max(e,c[l])},-Number.MAX_VALUE)},getArrayExtremes:function(d,l,e){return g(d,function(c,b){return[Math.min(c[0],b[l]),Math.max(c[1],b[e])]},[Number.MAX_VALUE,-Number.MAX_VALUE])}}});r(g,"indicators/price-channel.src.js",
[g["parts/Globals.js"],g["mixins/reduce-array.js"],g["mixins/multipe-lines.js"]],function(d,g,k){var l=g.getArrayExtremes;g=d.merge;d.seriesType("pc","sma",{params:{period:20},lineWidth:1,topLine:{styles:{lineColor:"#90ed7d",lineWidth:1}},bottomLine:{styles:{lineColor:"#f45b5b",lineWidth:1}},dataGrouping:{approximation:"averages"}},g(k,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameBase:"Price Channel",nameComponents:["period"],linesApiNames:["topLine","bottomLine"],getValues:function(e,
c){c=c.period;var b=e.xData,a=(e=e.yData)?e.length:0,f=[],d=[],h=[],g;if(a<c)return!1;for(g=c;g<=a;g++){var t=b[g-1];var n=e.slice(g-c,g);var q=l(n,2,1);n=q[1];var m=q[0];q=(n+m)/2;f.push([t,n,q,m]);d.push(t);h.push([n,q,m])}return{values:f,xData:d,yData:h}}}))});r(g,"indicators/price-envelopes.src.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(d,g){var k=g.isArray,l=d.merge,e=d.seriesTypes.sma;d.seriesType("priceenvelopes","sma",{marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},
params:{period:20,topBand:.1,bottomBand:.1},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}},{nameComponents:["period","topBand","bottomBand"],nameBase:"Price envelopes",pointArrayMap:["top","middle","bottom"],parallelArrays:["x","y","top","bottom"],pointValKey:"middle",init:function(){e.prototype.init.apply(this,arguments);this.options=l({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)},
toYData:function(c){return[c.top,c.middle,c.bottom]},translate:function(){var c=this,b=["plotTop","plotMiddle","plotBottom"];e.prototype.translate.apply(c);c.points.forEach(function(a){[a.top,a.middle,a.bottom].forEach(function(f,e){null!==f&&(a[b[e]]=c.yAxis.toPixels(f,!0))})})},drawGraph:function(){for(var c=this,b=c.points,a=b.length,f=c.options,d=c.graph,h={options:{gapSize:f.gapSize}},g=[[],[]],t;a--;)t=b[a],g[0].push({plotX:t.plotX,plotY:t.plotTop,isNull:t.isNull}),g[1].push({plotX:t.plotX,
plotY:t.plotBottom,isNull:t.isNull});["topLine","bottomLine"].forEach(function(a,b){c.points=g[b];c.options=l(f[a].styles,h);c.graph=c["graph"+a];e.prototype.drawGraph.call(c);c["graph"+a]=c.graph});c.points=b;c.options=f;c.graph=d;e.prototype.drawGraph.call(c)},getValues:function(c,b){var a=b.period,f=b.topBand,d=b.bottomBand,h=c.xData,l=(c=c.yData)?c.length:0,g=[],n=[],q=[],m;if(h.length<a||!k(c[0])||4!==c[0].length)return!1;for(m=a;m<=l;m++){var p=h.slice(m-a,m);var y=c.slice(m-a,m);y=e.prototype.getValues.call(this,
{xData:p,yData:y},b);p=y.xData[0];y=y.yData[0];var F=y*(1+f);var r=y*(1-d);g.push([p,F,y,r]);n.push(p);q.push([F,y,r])}return{values:g,xData:n,yData:q}}})});r(g,"indicators/psar.src.js",[g["parts/Globals.js"]],function(d){d.seriesType("psar","sma",{lineWidth:0,marker:{enabled:!0},states:{hover:{lineWidthPlus:0}},params:{initialAccelerationFactor:.02,maxAccelerationFactor:.2,increment:.02,index:2,decimals:4}},{nameComponents:!1,getValues:function(d,g){var l=d.xData;d=d.yData;var e=d[0][1],c=g.maxAccelerationFactor,
b=g.increment,a=g.initialAccelerationFactor,f=d[0][2],u=g.decimals,h=g.index,w=[],t=[],n=[],q=1,m;if(h>=d.length)return!1;for(m=0;m<h;m++)e=Math.max(d[m][1],e),f=Math.min(d[m][2],parseFloat(f.toFixed(u)));var k=d[m][1]>f?1:-1;g=g.initialAccelerationFactor;var p=g*(e-f);w.push([l[h],f]);t.push(l[h]);n.push(parseFloat(f.toFixed(u)));for(m=h+1;m<d.length;m++){h=d[m-1][2];var r=d[m-2][2];var G=d[m-1][1];var x=d[m-2][1];var z=d[m][1];var v=d[m][2];null!==r&&null!==x&&null!==h&&null!==G&&null!==z&&null!==
v&&(f=k===q?1===k?f+p<Math.min(r,h)?f+p:Math.min(r,h):f+p>Math.max(x,G)?f+p:Math.max(x,G):e,h=1===k?z>e?z:e:v<e?v:e,z=1===q&&v>f||-1===q&&z>f?1:-1,q=z,p=h,v=b,r=c,G=a,g=q===k?1===q&&p>e?g===r?r:parseFloat((g+v).toFixed(2)):-1===q&&p<e?g===r?r:parseFloat((g+v).toFixed(2)):g:G,e=h-f,p=g*e,w.push([l[m],parseFloat(f.toFixed(u))]),t.push(l[m]),n.push(parseFloat(f.toFixed(u))),q=k,k=z,e=h)}return{values:w,xData:t,yData:n}}})});r(g,"indicators/roc.src.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],
function(d,g){var k=g.isArray;d=d.seriesType;d("roc","sma",{params:{index:3,period:9}},{nameBase:"Rate of Change",getValues:function(d,e){var c=e.period,b=d.xData,a=(d=d.yData)?d.length:0,f=[],g=[],h=[],l=-1;if(b.length<=c)return!1;k(d[0])&&(l=e.index);for(e=c;e<a;e++){var t=0>l?(t=d[e-c])?(d[e]-t)/t*100:null:(t=d[e-c][l])?(d[e][l]-t)/t*100:null;t=[b[e],t];f.push(t);g.push(t[0]);h.push(t[1])}return{values:f,xData:g,yData:h}}})});r(g,"indicators/rsi.src.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],
function(d,g){var k=g.isArray;d.seriesType("rsi","sma",{params:{period:14,decimals:4}},{getValues:function(d,e){var c=e.period,b=d.xData,a=(d=d.yData)?d.length:0;e=e.decimals;var f=1,g=[],h=[],l=[],t=0,n=0,q;if(b.length<c||!k(d[0])||4!==d[0].length)return!1;for(;f<c;){var m=parseFloat((d[f][3]-d[f-1][3]).toFixed(e));0<m?t+=m:n+=Math.abs(m);f++}var p=parseFloat((t/(c-1)).toFixed(e));for(q=parseFloat((n/(c-1)).toFixed(e));f<a;f++)m=parseFloat((d[f][3]-d[f-1][3]).toFixed(e)),0<m?(t=m,n=0):(t=0,n=Math.abs(m)),
p=parseFloat(((p*(c-1)+t)/c).toFixed(e)),q=parseFloat(((q*(c-1)+n)/c).toFixed(e)),t=0===q?100:0===p?0:parseFloat((100-100/(1+p/q)).toFixed(e)),g.push([b[f],t]),h.push(b[f]),l.push(t);return{values:g,xData:h,yData:l}}})});r(g,"indicators/stochastic.src.js",[g["parts/Globals.js"],g["parts/Utilities.js"],g["mixins/reduce-array.js"],g["mixins/multipe-lines.js"]],function(d,g,k,l){var e=g.isArray,c=d.merge,b=d.seriesTypes.sma,a=k.getArrayExtremes;d.seriesType("stochastic","sma",{params:{periods:[14,3]},
marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>%K: {point.y}<br/>%D: {point.smoothed}<br/>'},smoothedLine:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}},d.merge(l,{nameComponents:["periods"],nameBase:"Stochastic",pointArrayMap:["y","smoothed"],parallelArrays:["x","y","smoothed"],pointValKey:"y",linesApiNames:["smoothedLine"],init:function(){b.prototype.init.apply(this,arguments);this.options=c({smoothedLine:{styles:{lineColor:this.color}}},
this.options)},getValues:function(c,d){var f=d.periods[0];d=d.periods[1];var g=c.xData,l=(c=c.yData)?c.length:0,n=[],q=[],m=[],u=null,k;if(l<f||!e(c[0])||4!==c[0].length)return!1;for(k=f-1;k<l;k++){var p=c.slice(k-f+1,k+1);var r=a(p,2,1);var x=r[0];p=c[k][3]-x;x=r[1]-x;p=p/x*100;q.push(g[k]);m.push([p,null]);k>=f-1+(d-1)&&(u=b.prototype.getValues.call(this,{xData:q.slice(-d),yData:m.slice(-d)},{period:d}),u=u.yData[0]);n.push([g[k],p,u]);m[m.length-1][1]=u}return{values:n,xData:q,yData:m}}}))});r(g,
"indicators/supertrend.src.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(d,g){function k(a,b,c){return{index:b,close:a.yData[b][c],x:a.xData[b]}}var l=g.isArray,e=g.objectEach,c=d.seriesTypes.atr,b=d.seriesTypes.sma,a=d.merge,f=d.correctFloat;d.seriesType("supertrend","sma",{params:{multiplier:3,period:10},risingTrendColor:"#06B535",fallingTrendColor:"#F21313",changeTrendLine:{styles:{lineWidth:1,lineColor:"#333333",dashStyle:"LongDash"}}},{nameBase:"Supertrend",nameComponents:["multiplier",
"period"],requiredIndicators:["atr"],init:function(){b.prototype.init.apply(this,arguments);var a=this.options;a.cropThreshold=this.linkedParent.options.cropThreshold-(a.params.period-1)},drawGraph:function(){var c=this,f=c.options,d=c.linkedParent,g=d?d.points:[],n=c.points,l=c.graph,m=n.length,p=g.length-m;p=0<p?p:0;for(var y={options:{gapSize:f.gapSize}},r={top:[],bottom:[],intersect:[]},G={top:{styles:{lineWidth:f.lineWidth,lineColor:f.fallingTrendColor,dashStyle:f.dashStyle}},bottom:{styles:{lineWidth:f.lineWidth,
lineColor:f.risingTrendColor,dashStyle:f.dashStyle}},intersect:f.changeTrendLine},x,z,v,A,C,I,B,H;m--;)x=n[m],z=n[m-1],v=g[m-1+p],A=g[m-2+p],C=g[m+p],I=g[m+p+1],B=x.options.color,H={x:x.x,plotX:x.plotX,plotY:x.plotY,isNull:!1},!A&&v&&d.yData[v.index-1]&&(A=k(d,v.index-1,3)),!I&&C&&d.yData[C.index+1]&&(I=k(d,C.index+1,3)),!v&&A&&d.yData[A.index+1]?v=k(d,A.index+1,3):!v&&C&&d.yData[C.index-1]&&(v=k(d,C.index-1,3)),x&&v&&C&&A&&x.x!==v.x&&(x.x===C.x?(A=v,v=C):x.x===A.x?(v=A,A={close:d.yData[v.index-1][3],
x:d.xData[v.index-1]}):I&&x.x===I.x&&(v=I,A=C)),z&&A&&v?(C={x:z.x,plotX:z.plotX,plotY:z.plotY,isNull:!1},x.y>=v.close&&z.y>=A.close?(x.color=B||f.fallingTrendColor,r.top.push(H)):x.y<v.close&&z.y<A.close?(x.color=B||f.risingTrendColor,r.bottom.push(H)):(r.intersect.push(H),r.intersect.push(C),r.intersect.push(a(C,{isNull:!0})),x.y>=v.close&&z.y<A.close?(x.color=B||f.fallingTrendColor,z.color=B||f.risingTrendColor,r.top.push(H),r.top.push(a(C,{isNull:!0}))):x.y<v.close&&z.y>=A.close&&(x.color=B||f.risingTrendColor,
z.color=B||f.fallingTrendColor,r.bottom.push(H),r.bottom.push(a(C,{isNull:!0}))))):v&&(x.y>=v.close?(x.color=B||f.fallingTrendColor,r.top.push(H)):(x.color=B||f.risingTrendColor,r.bottom.push(H)));e(r,function(f,d){c.points=f;c.options=a(G[d].styles,y);c.graph=c["graph"+d+"Line"];b.prototype.drawGraph.call(c);c["graph"+d+"Line"]=c.graph});c.points=n;c.options=f;c.graph=l},getValues:function(a,b){var d=b.period;b=b.multiplier;var e=a.xData,g=a.yData,h=[],m=[],k=[],u=0===d?0:d-1,p=[],r=[],x;if(e.length<=
d||!l(g[0])||4!==g[0].length||0>d)return!1;a=c.prototype.getValues.call(this,a,{period:d}).yData;for(x=0;x<a.length;x++){var z=g[u+x];var v=g[u+x-1]||[];var A=p[x-1];var C=r[x-1];var I=k[x-1];0===x&&(A=C=I=0);d=f((z[1]+z[2])/2+b*a[x]);var B=f((z[1]+z[2])/2-b*a[x]);p[x]=d<A||v[3]>A?d:A;r[x]=B>C||v[3]<C?B:C;if(I===A&&z[3]<p[x]||I===C&&z[3]<r[x])var H=p[x];else if(I===A&&z[3]>p[x]||I===C&&z[3]>r[x])H=r[x];h.push([e[u+x],H]);m.push(e[u+x]);k.push(H)}return{values:h,xData:m,yData:k}}})});r(g,"indicators/volume-by-price.src.js",
[g["parts/Globals.js"],g["parts/Utilities.js"]],function(d,g){var k=g.isArray,l=Math.abs;g=d.noop;var e=d.addEvent,c=d.correctFloat,b=d.seriesType,a=d.seriesTypes.column.prototype;b("vbp","sma",{params:{ranges:12,volumeSeriesID:"volume"},zoneLines:{enabled:!0,styles:{color:"#0A9AC9",dashStyle:"LongDash",lineWidth:1}},volumeDivision:{enabled:!0,styles:{positiveColor:"rgba(144, 237, 125, 0.8)",negativeColor:"rgba(244, 91, 91, 0.8)"}},animationLimit:1E3,enableMouseTracking:!1,pointPadding:0,zIndex:-1,
crisp:!0,dataGrouping:{enabled:!1},dataLabels:{allowOverlap:!0,enabled:!0,format:"P: {point.volumePos:.2f} | N: {point.volumeNeg:.2f}",padding:0,style:{fontSize:"7px"},verticalAlign:"top"}},{nameBase:"Volume by Price",bindTo:{series:!1,eventName:"afterSetExtremes"},calculateOn:"render",markerAttribs:g,drawGraph:g,getColumnMetrics:a.getColumnMetrics,crispCol:a.crispCol,init:function(a){d.seriesTypes.sma.prototype.init.apply(this,arguments);var b=this.options.params;var c=this.linkedParent;b=a.get(b.volumeSeriesID);
this.addCustomEvents(c,b);return this},addCustomEvents:function(a,b){function c(){f.chart.redraw();f.setData([]);f.zoneStarts=[];f.zoneLinesSVG&&(f.zoneLinesSVG.destroy(),delete f.zoneLinesSVG)}var f=this;f.dataEventsToUnbind.push(e(a,"remove",function(){c()}));b&&f.dataEventsToUnbind.push(e(b,"remove",function(){c()}));return f},animate:function(a){var b=this,c={};d.svg&&!a&&(c.translateX=b.yAxis.pos,b.group.animate(c,d.extend(d.animObject(b.options.animation),{step:function(a,c){b.group.attr({scaleX:Math.max(.001,
c.pos)})}})),b.animate=null)},drawPoints:function(){this.options.volumeDivision.enabled&&(this.posNegVolume(!0,!0),a.drawPoints.apply(this,arguments),this.posNegVolume(!1,!1));a.drawPoints.apply(this,arguments)},posNegVolume:function(a,b){var c=b?["positive","negative"]:["negative","positive"],f=this.options.volumeDivision,d=this.points.length,e=[],g=[],m=0,l;a?(this.posWidths=e,this.negWidths=g):(e=this.posWidths,g=this.negWidths);for(;m<d;m++){var k=this.points[m];k[c[0]+"Graphic"]=k.graphic;k.graphic=
k[c[1]+"Graphic"];if(a){var u=k.shapeArgs.width;var p=this.priceZones[m];(l=p.wholeVolumeData)?(e.push(u/l*p.positiveVolumeData),g.push(u/l*p.negativeVolumeData)):(e.push(0),g.push(0))}k.color=b?f.styles.positiveColor:f.styles.negativeColor;k.shapeArgs.width=b?this.posWidths[m]:this.negWidths[m];k.shapeArgs.x=b?k.shapeArgs.x:this.posWidths[m]}},translate:function(){var b=this,e=b.options,g=b.chart,k=b.yAxis,t=k.min,n=b.options.zoneLines,q=b.priceZones,m=0,p,r,F;a.translate.apply(b);var G=b.points;
if(G.length){var x=.5>e.pointPadding?e.pointPadding:.1;e=b.volumeDataArray;var z=d.arrayMax(e);var v=g.plotWidth/2;var A=g.plotTop;var C=l(k.toPixels(t)-k.toPixels(t+b.rangeStep));var I=l(k.toPixels(t)-k.toPixels(t+b.rangeStep));x&&(t=l(C*(1-2*x)),m=l((C-t)/2),C=l(t));G.forEach(function(a,d){r=a.barX=a.plotX=0;F=a.plotY=k.toPixels(q[d].start)-A-(k.reversed?C-I:C)-m;p=c(v*q[d].wholeVolumeData/z);a.pointWidth=p;a.shapeArgs=b.crispCol.apply(b,[r,F,p,C]);a.volumeNeg=q[d].negativeVolumeData;a.volumePos=
q[d].positiveVolumeData;a.volumeAll=q[d].wholeVolumeData});n.enabled&&b.drawZones(g,k,b.zoneStarts,n.styles)}},getValues:function(a,b){var c=a.processedXData,f=a.processedYData,e=this.chart,g=b.ranges,l=[],m=[],p=[],u;if(!a.chart)return d.error("Base series not found! In case it has been removed, add a new one.",!0,e);if(!(u=e.get(b.volumeSeriesID)))return d.error("Series "+b.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,e);if((b=k(f[0]))&&4!==f[0].length)return d.error("Type of "+a.name+
" series is different than line, OHLC or candlestick.",!0,e);(this.priceZones=this.specifyZones(b,c,f,g,u)).forEach(function(a,b){l.push([a.x,a.end]);m.push(l[b][0]);p.push(l[b][1])});return{values:l,xData:m,yData:p}},specifyZones:function(a,b,e,g,l){if(a){var f=e.length;for(var h=e[0][3],m=h,k=1,t;k<f;k++)t=e[k][3],t<h&&(h=t),t>m&&(m=t);f={min:h,max:m}}else f=!1;f=(h=f)?h.min:d.arrayMin(e);t=h?h.max:d.arrayMax(e);h=this.zoneStarts=[];m=[];var p=0;k=1;if(!f||!t)return this.points.length&&(this.setData([]),
this.zoneStarts=[],this.zoneLinesSVG.destroy()),[];var u=this.rangeStep=c(t-f)/g;for(h.push(f);p<g-1;p++)h.push(c(h[p]+u));h.push(t);for(g=h.length;k<g;k++)m.push({index:k-1,x:b[0],start:h[k-1],end:h[k]});return this.volumePerZone(a,m,l,b,e)},volumePerZone:function(a,b,c,d,e){var f=this,g=c.processedXData,h=c.processedYData,k=b.length-1,t=e.length;c=h.length;var p,u,w,r,v;l(t-c)&&(d[0]!==g[0]&&h.unshift(0),d[t-1]!==g[c-1]&&h.push(0));f.volumeDataArray=[];b.forEach(function(b){b.wholeVolumeData=0;
b.positiveVolumeData=0;for(v=b.negativeVolumeData=0;v<t;v++)w=u=!1,r=a?e[v][3]:e[v],p=v?a?e[v-1][3]:e[v-1]:r,r<=b.start&&0===b.index&&(u=!0),r>=b.end&&b.index===k&&(w=!0),(r>b.start||u)&&(r<b.end||w)&&(b.wholeVolumeData+=h[v],p>r?b.negativeVolumeData+=h[v]:b.positiveVolumeData+=h[v]);f.volumeDataArray.push(b.wholeVolumeData)});return b},drawZones:function(a,b,c,d){var f=a.renderer,e=this.zoneLinesSVG,g=[],h=a.plotWidth,l=a.plotTop,k;c.forEach(function(c){k=b.toPixels(c)-l;g=g.concat(a.renderer.crispLine(["M",
0,k,"L",h,k],d.lineWidth))});e?e.animate({d:g}):e=this.zoneLinesSVG=f.path(g).attr({"stroke-width":d.lineWidth,stroke:d.color,dashstyle:d.dashStyle,zIndex:this.group.zIndex+.1}).add(this.group)}},{destroy:function(){this.negativeGraphic&&(this.negativeGraphic=this.negativeGraphic.destroy());return d.Point.prototype.destroy.apply(this,arguments)}})});r(g,"indicators/vwap.src.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(d,g){var k=g.isArray;g=d.seriesType;g("vwap","sma",{params:{period:30,
volumeSeriesID:"volume"}},{getValues:function(g,e){var c=g.chart,b=g.xData;g=g.yData;var a=e.period,f=!0,l;if(!(l=c.get(e.volumeSeriesID)))return d.error("Series "+e.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,c);k(g[0])||(f=!1);return this.calculateVWAPValues(f,b,g,l,a)},calculateVWAPValues:function(d,e,c,b,a){var f=b.yData,g=b.xData.length,h=e.length;b=[];var l=[],k=[],n=[],q=[],m;g=h<=g?h:g;for(m=h=0;h<g;h++){var p=d?(c[h][1]+c[h][2]+c[h][3])/3:c[h];p*=f[h];p=m?b[h-1]+p:p;var r=m?l[h-
1]+f[h]:f[h];b.push(p);l.push(r);q.push([e[h],p/r]);k.push(q[h][0]);n.push(q[h][1]);m++;m===a&&(m=0)}return{values:q,xData:k,yData:n}}})});r(g,"indicators/williams-r.src.js",[g["parts/Globals.js"],g["parts/Utilities.js"],g["mixins/reduce-array.js"]],function(d,g,k){var l=g.isArray,e=k.getArrayExtremes;d.seriesType("williamsr","sma",{params:{period:14}},{nameBase:"Williams %R",getValues:function(c,b){b=b.period;var a=c.xData,d=(c=c.yData)?c.length:0,g=[],h=[],k=[],p;if(a.length<b||!l(c[0])||4!==c[0].length)return!1;
for(p=b-1;p<d;p++){var n=c.slice(p-b+1,p+1);var q=e(n,2,1);n=q[0];q=q[1];var m=c[p][3];n=(q-m)/(q-n)*-100;a[p]&&(g.push([a[p],n]),h.push(a[p]),k.push(n))}return{values:g,xData:h,yData:k}}})});r(g,"indicators/wma.src.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(d,g){function k(c,b){b*=(b+1)/2;return c.reduce(function(a,b,c){return[null,a[1]+b[1]*(c+1)]})[1]/b}function l(c,b,a,d){a=k(c,c.length);b=b[d-1];c.shift();return[b,a]}var e=g.isArray;d=d.seriesType;d("wma","sma",{params:{index:3,
period:9}},{getValues:function(c,b){var a=b.period,d=c.xData,g=(c=c.yData)?c.length:0,h=1,k=d[0],p=c[0],n=[],q=[],m=[],r=-1;if(d.length<a)return!1;e(c[0])&&(r=b.index,p=c[0][r]);for(b=[[k,p]];h!==a;)b.push([d[h],0>r?c[h]:c[h][r]]),h++;for(a=h;a<g;a++)h=l(b,d,c,a),n.push(h),q.push(h[0]),m.push(h[1]),b.push([d[a],0>r?c[a]:c[a][r]]);h=l(b,d,c,a);n.push(h);q.push(h[0]);m.push(h[1]);return{values:n,xData:q,yData:m}}})});r(g,"indicators/zigzag.src.js",[g["parts/Globals.js"]],function(d){d=d.seriesType;
d("zigzag","sma",{params:{lowIndex:2,highIndex:1,deviation:1}},{nameComponents:["deviation"],nameSuffixes:["%"],nameBase:"Zig Zag",getValues:function(d,g){var l=g.lowIndex,e=g.highIndex,c=g.deviation/100;g=1+c;var b=1-c;c=d.xData;var a=d.yData;d=a?a.length:0;var f=[],k=[],h=[],p,t,n=!1,q=!1;if(1>=c.length||d&&(void 0===a[0][l]||void 0===a[0][e]))return!1;var m=a[0][l];var r=a[0][e];for(p=1;p<d;p++){if(a[p][l]<=r*b){f.push([c[0],r]);var y=[c[p],a[p][l]];n=t=!0}else a[p][e]>=m*g&&(f.push([c[0],m]),
y=[c[p],a[p][e]],t=!1,n=!0);if(n){k.push(f[0][0]);h.push(f[0][1]);var F=p++;p=d}}for(p=F;p<d;p++)t?(a[p][l]<=y[1]&&(y=[c[p],a[p][l]]),a[p][e]>=y[1]*g&&(q=e)):(a[p][e]>=y[1]&&(y=[c[p],a[p][e]]),a[p][l]<=y[1]*b&&(q=l)),!1!==q&&(f.push(y),k.push(y[0]),h.push(y[1]),y=[c[p],a[p][q]],t=!t,q=!1);l=f.length;0!==l&&f[l-1][0]<c[d-1]&&(f.push(y),k.push(y[0]),h.push(y[1]));return{values:f,xData:k,yData:h}}})});r(g,"indicators/regressions.src.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(d,g){var k=
g.isArray;d=d.seriesType;d("linearRegression","sma",{params:{xAxisUnit:void 0},tooltip:{valueDecimals:4}},{nameBase:"Linear Regression Indicator",getRegressionLineParameters:function(d,e){var c=this.options.params.index,b=function(a,b){return k(a)?a[b]:a},a=d.reduce(function(a,b){return b+a},0),f=e.reduce(function(a,d){return b(d,c)+a},0);a/=d.length;f/=e.length;var g=0,h=0,l;for(l=0;l<d.length;l++){var p=d[l]-a;var n=b(e[l],c)-f;g+=p*n;h+=Math.pow(p,2)}d=h?g/h:0;return{slope:d,intercept:f-d*a}},
getEndPointY:function(d,e){return d.slope*e+d.intercept},transformXData:function(d,e){var c=d[0];return d.map(function(b){return(b-c)/e})},findClosestDistance:function(d){var e,c;for(c=1;c<d.length-1;c++){var b=d[c]-d[c-1];0<b&&(void 0===e||b<e)&&(e=b)}return e},getValues:function(d,e){var c=d.xData;d=d.yData;e=e.period;var b,a={xData:[],yData:[],values:[]},f=this.options.params.xAxisUnit||this.findClosestDistance(c);for(b=e-1;b<=c.length-1;b++){var g=b-e+1;var h=b+1;var k=c[b];var l=c.slice(g,h);
g=d.slice(g,h);h=this.transformXData(l,f);l=this.getRegressionLineParameters(h,g);g=this.getEndPointY(l,h[h.length-1]);a.values.push({regressionLineParameters:l,x:k,y:g});a.xData.push(k);a.yData.push(g)}return a}});d("linearRegressionSlope","linearRegression",{},{nameBase:"Linear Regression Slope Indicator",getEndPointY:function(d){return d.slope}});d("linearRegressionIntercept","linearRegression",{},{nameBase:"Linear Regression Intercept Indicator",getEndPointY:function(d){return d.intercept}});
d("linearRegressionAngle","linearRegression",{tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span>{series.name}: <b>{point.y}\u00b0</b><br/>'}},{nameBase:"Linear Regression Angle Indicator",slopeToAngle:function(d){return 180/Math.PI*Math.atan(d)},getEndPointY:function(d){return this.slopeToAngle(d.slope)}})});r(g,"indicators/acceleration-bands.src.js",[g["parts/Globals.js"],g["mixins/multipe-lines.js"]],function(d,g){var k=d.seriesTypes.sma,l=d.merge,e=d.correctFloat;d.seriesType("abands",
"sma",{params:{period:20,factor:.001,index:3},lineWidth:1,topLine:{styles:{lineWidth:1}},bottomLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}},l(g,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameBase:"Acceleration Bands",nameComponents:["period","factor"],linesApiNames:["topLine","bottomLine"],getValues:function(c,b){var a=b.period,d=b.factor;b=b.index;var g=c.xData,h=(c=c.yData)?c.length:0,l=[],p=[],n=[],q=[],m=[],r;if(h<a)return!1;for(r=0;r<=h;r++){if(r<h){var y=
c[r][2];var F=c[r][1];var G=d;y=e(F-y)/(e(F+y)/2)*1E3*G;l.push(c[r][1]*e(1+2*y));p.push(c[r][2]*e(1-2*y))}if(r>=a){y=g.slice(r-a,r);var x=c.slice(r-a,r);G=k.prototype.getValues.call(this,{xData:y,yData:l.slice(r-a,r)},{period:a});F=k.prototype.getValues.call(this,{xData:y,yData:p.slice(r-a,r)},{period:a});x=k.prototype.getValues.call(this,{xData:y,yData:x},{period:a,index:b});y=x.xData[0];G=G.yData[0];F=F.yData[0];x=x.yData[0];n.push([y,G,x,F]);q.push(y);m.push([G,x,F])}}return{values:n,xData:q,yData:m}}}))});
r(g,"indicators/trendline.src.js",[g["parts/Globals.js"],g["parts/Utilities.js"]],function(d,g){var k=g.isArray;d=d.seriesType;d("trendline","sma",{params:{index:3}},{nameBase:"Trendline",nameComponents:!1,getValues:function(d,e){var c=d.xData,b=d.yData;d=[];var a=[],f=[],g=0,h=0,l=0,p=0,n=c.length,q=e.index;for(e=0;e<n;e++){var m=c[e];var r=k(b[e])?b[e][q]:b[e];g+=m;h+=r;l+=m*r;p+=m*m}b=(n*l-g*h)/(n*p-g*g);isNaN(b)&&(b=0);g=(h-b*g)/n;for(e=0;e<n;e++)m=c[e],r=b*m+g,d[e]=[m,r],a[e]=m,f[e]=r;return{xData:a,
yData:f,values:d}}})});r(g,"masters/indicators/indicators-all.src.js",[],function(){})});
//# sourceMappingURL=indicators-all.js.map