<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class AddEnumNotApproveInHistoryTypeColumnOnOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::statement("ALTER TABLE `orders` CHANGE `history_type` `history_type` ENUM('Running', 'Edit', 'Delete', 'OrderDel', 'Cancel', 'notApprove') NOT NULL DEFAULT 'notApprove'");
        // Delete ** delete before approve
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement("ALTER TABLE `orders` CHANGE `history_type` `history_type` ENUM('Running', 'Edit', 'Delete', 'OrderDel', 'Cancel') NOT NULL DEFAULT 'Running'");
    }
}
