<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBudgetPostCostsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('budget_post_costs', function (Blueprint $table) {
            $table->id();
            $table->date('date');
            $table->integer('order_id')->unsigned();
            $table->integer('budget_id')->unsigned();
            $table->integer('supplier_id')->unsigned();
            $table->string('chalan_no'); // bill_no
            $table->float('cost')->unsigned();
            $table->enum('post_cost_type', [
                    'Yarn',
                    'Knitting',
                    'Dying',
                    'AOP',
                    'YD',
                    'Print',
                    'Embroidery',
                    'Accessories',
                    'Test',
                    'CM',
                    'Commercial',
                    'Buying', //use as commission
                    'Other',
                    'Profit',
                ])->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('budget_post_costs');
    }
}
