<?php

namespace App\Http\Middleware;

use App\Setting;
use Closure;

class SettingsMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $debug = Setting::where('name', 'Debug')->first()->value ?? 'true';
        $debugBool = $debug === 'true';

        config(['app.debug' => $debugBool]);
        config(["mail.from.name" => (Setting::where('name', 'companyName')->first()->value) ?? "ERP Software"]);

        return $next($request);
    }
}
