<?php

namespace App\Http\Controllers;

use App\Mail\TestMail;
use App\Order;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Mail;

class UtilityController extends Controller
{
    public function env()
    {

        return $tt;
        //return env('app_debug');
        //config(['app.debug', false]);

        return env('APP_DEBUG');
    }

    public function notSetMethode()
    {
        dd('Empty method call');
    }

    public function methodeNotFound()
    {
        dd('Methode not found');
    }

    public function orderQtySumGetFromQtyTableAndInsertIntoOrderTable()
    {
        $ord = Order::where('ord_quantity', 0)->get();

        foreach ($ord as $or) {
            $or->ord_quantity = $or->quantity->sum('quantity');
            $or->save();
        }



        dd($ord);
    }
    public function emailCheck(Request $request)
    {
        // Route
        //http://localhost/rmg_erp/public/utility/mail-check

        //dd(now()->addMinutes(10)->date);
        //Mail::to('tanvir603@gmail.com')->send(new TestMail($request['data']));
        //mehedi@westapparelltd.com
        Mail::to('tanvir603@gmail.com')->later(now()->addMinutes(5), new TestMail($request['data']));
    }
    public function searchData($model, $name, $data, $erpModuleName = null)
    {
        $modelName = $model;
        $model = 'App\\'.$model;
        $model = $model::query();

        //dd($erpModuleName);



        if ($modelName == 'Order') {
            /*if ($erpModuleName) {
                $history_type = '';

                switch ($erpModuleName){
                    case 'cancelOrders':
                        $history_type = 'OrderDel';
                    default:
                        $history_type = 'Running';
                }

                $model = $model->where('history_type', $history_type);
            } else {
                $model = $model->where('history_type', 'Running');
            }*/

            $history_type = '';

            switch ($erpModuleName){
                case 'cancelOrders':
                    $history_type = 'OrderDel';
                    break;
                default:
                    $history_type = 'Running';
            }

            //dd($history_type);

            $model = $model->where('history_type', $history_type);

        }

        return $model->where($name, 'like', $data.'%')->distinct()->pluck($name);
    }
    public function selectDropdownData($model, $belongs=false)
    {
        $model = 'App\\'.$model;
        return $belongs? $model::with($belongs)->get() : $model::get();
    }

    public function selectHasManyData($model, $id, $belongs=false)
    {
        $model = 'App\\'.$model;
        $selectedModel = $model::find($id);
        return $belongs? $selectedModel->$belongs : $model::get();
    }

    public function colorWiseQuantity($model, $id, $belongs=false)
    {
        $model = 'App\\'.$model;
        $selectedModel = $model::find($id);
        //dd($selectedModel->orderColorAndSizeQtyArrFunc());
        $colorWiseQuantity = [];
        foreach ($selectedModel->orderColorAndSizeQtyArrFunc() as $colorName=>$order) {
            $colorWiseQuantity[$colorName] = [
                'color_id' => $order['color_id'],
                'qty' => array_sum($order['qty'])
            ];
        }
        //dd($colorWiseQuantity);
        return $colorWiseQuantity;
    }

    public function filterOrder($request)
    {
        $query = Order::query()->where('history_type', 'Running');

        $orders = [];

        $query = $query->with(['budget:order_id,cm', 'buyer', 'quantity', 'status', 'shipment']);
        $id = $request->get('id') ?? null;
        $buyer_id = $request->get('buyer_id') ?? null;
        $name = $request->get('name') ?? null;
        $style = $request->get('style') ?? null;
        $style_desc = $request->get('style_desc') ?? null;
        $statuses = $request->get('statuses') ?? null;
        $category_id = $request->get('category_id') ?? null;
        $sub_category_id = $request->get('sub_category_id') ?? null;
        $from = $request->get('from') ?? null;
        $to = $request->get('to') ?? null;
        $ord_quantity = $request->get('ord_quantity') ?? null;

        $per_page=(int)$request->input('per_page');

        if($per_page<=0)
        {
            $per_page = 200;
        }

        if($request->filled('id')) {
            $query = $query->where('id', $request->get('id') );
            //$phone = $request->get('phone');
        }
        if($request->filled('buyer_id')) {
            $query = $query->where('buyer_id', $request->get('buyer_id') );
            //$phone = $request->get('phone');
        }
        if($request->filled('name')) {
            $query = $query->where('name', $request->get('name') );
            //$phone = $request->get('phone');
        }
        if($request->filled('style')) {
            $query = $query->where('style', $request->get('style') );
            //$phone = $request->get('phone');
        }
        if($request->filled('style_desc')) {
            $query = $query->where('style_desc', $request->get('style_desc') );
            //$phone = $request->get('phone');
        }
        if($request->filled('statuses')) {
            $query = $query->where('statuses', $request->get('statuses') );
            //$phone = $request->get('phone');
        }
        if($request->filled('sub_category_id')) {
            $query = $query->where('sub_category_id', $request->get('sub_category_id') );
            //$phone = $request->get('phone');
        }
        if($request->filled('ord_quantity')) {
            $query = $query->where('ord_quantity', $request->get('ord_quantity') );
            //$phone = $request->get('phone');
        }
        if($request->filled('from') && $request->filled('to')) {
            $query = $query->whereBetween('date_of_ship', [$request->get('from'), $request->get('to')] );
            //$phone = $request->get('phone');
        }

        if($request->filled('order_filter_form') || $request->filled('id')) {
            $orders = $query->paginate($per_page);
            $orders->setpath($request->fullUrl()."&per_page=$per_page");
        }



        $compact = compact(
            'id',
            'buyer_id',
            'name',
            'style',
            'style_desc',
            'statuses',
            'category_id',
            'sub_category_id',
            'from',
            'to',
            'per_page',
            'ord_quantity',
            'orders'
        );
        //dd($orders);

        return $compact;
    }
}
