<?php

namespace App\Http\Controllers;

use App\Buyer;
use App\Order;
use App\Production;
use App\Shipment;
use App\User;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //dd((new Order())->pendingOrderRange('Y-m-01', 'Y-m-d')->count());

        $buyerName = [];
        $orders = Order::whereBetween('date_of_ship', [date('Y-m-01'), date('Y-m-31')]);
        foreach($orders->get() as $key => $order){
            $buyerName[$order->buyer->name] = $key;
        }



        return view('dashboard.index')
            ->withOrdersCount($orders->count())
            ->withPendingOrdersCount((new Order())->pendingOrderRange('Y-m-01', 'Y-m-d')->count())
            ->withUsersCount(User::count())
            ->withUsers(User::all())
            ->withBuyersCount(count($buyerName))
            ->withBuyers(Buyer::all())
            ->withProductionCount(Production::whereBetween('date', [date('Y-m-01'), date('Y-m-31')])->where([['history_type', 'Running'],['production_type', 'packing']])->sum('quantity'))
            ->withShipmentCount(Shipment::whereBetween('date', [date('Y-m-01'), date('Y-m-31')])->where('history_type', 'Running')->sum('quantity'))
            ;
    }
}
