<?php

namespace App\Http\Controllers;

use App\EmailList, App\Setting, Auth, Image;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class EmailListController extends Controller
{

    public $_profile_pic_folder;
    public $pageData = [];
    public $pageName;
    public $viewFolder;

    public function __construct()
    {
        $panelName = strtolower(str_replace('Controller', '',(new \ReflectionClass($this))->getShortName()));
        $this->pageName = $panelName;
        $this->viewFolder = $panelName;
        $this->_profile_pic_folder= 'profile-pic/'.$panelName;

        //echo strtolower(str_replace('Controller', '',(new \ReflectionClass($this))->getShortName()));
        $this->pageData = [
            'no' => 0,
            'pageName' => 'Email',
            'routeFirstName' => 'email-list',
            'ignoreColsInExport' => '[0]',
        ];

        //dd($this->pageData);

        view()->share('pageData', $this->pageData);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $query = EmailList::query();
        $name = null;
        $email = null;

        $per_page=(int)$request->input('per_page');

        if($per_page<=0)
        {
            $per_page = 20;
        }

        if($request->filled('name')) {
            $query = $query->where('name', 'like', '%'.$request->get('name').'%');
            $name = $request->get('name');
        }
        if($request->filled('email')) {
            $query = $query->where('email', 'like', '%' . $request->get('email') . '%');
            $email = $request->get('email');
        }

        $mainDatas = $query->get();

        $compact = compact(
            'name',
            'email',
            'per_page',
            'mainDatas'
        );

        return view($this->viewFolder.'.index', $compact)
            ->withCount($query->get()->count())
            ;
    }

    public function insertEmails()
    {
        EmailList::truncate();
        $emails = [
            'tanvir603@gmail.com',
            'biplob@westapparelltd.com',
            'kanon@westapparelltd.com',
            'emran@knitgarden.co',
            'al-amin@knitgarden.co',
            'ahnaf@knitgarden.co',
            'yasir@knitgarden.co',
            'chisty@knitgarden.co',
            'rakibol@knitgarden.co',
            'commercial@knitgarden.co',
            'accounts@knitgarden.co',
            'p.m@knitgarden.co',
            'knitting@knitgarden.co',
        ];

        if (!(Setting::where('name', 'shipmentScheduleChartStartMonth')->first())) {
            //dd(App\Setting::where('name', 'shipmentScheduleChartStartMonth')->first());
            DB::table('settings')->insert(
                array(
                    'name' => 'shipmentScheduleChartStartMonth',
                    'value' => 'Jan',
                    'description' => 'value insert when migrate',
                )
            );
        }


        foreach ($emails as $email) {
            EmailList::insert([
                'name' => ucfirst(explode('@', $email)[0]),
                'email' => $email,
                'type' => 'order',
            ]);
        }

        foreach (EmailList::where([['type', 'order'], ['status', 'active']])->get() as $emailObj) {
            dump($emailObj->id);
        }

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view($this->viewFolder.'.create')
            ->withUsers(User::all())
            ;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //dd($request->all());
        $loggedUseruser = Auth::user();
        if(!$loggedUseruser->can_manage_user())
        {
            return redirect()->back()->with(['fail'=>'Unauthorized Access.']);
        }
        //$team_ids = $loggedUseruser->role->managed_user_team_ids();
        //dd($team_ids);
        $request->validate([
            'name' => 'required|max:255',
            'email' => 'required|max:255',
            'image' => 'mimes:jpeg,jpg,png,JPEG,JPG,PNG | max:1000'
        ]);

        $mainData = new EmailList();
        $mainData->name = $request['name'];
        $mainData->email = $request['email'];
        $mainData->type = $request['type'];

        if ($request->has('status')) {
            $mainData->status = $request['status'];
        }

        $mainData->description = $request['description'];

        if($request->hasFile('profile_img'))
        {
            $image = $request->file('profile_img');
            $mainData->image = $filename = time() . '.' . $image->getClientOriginalExtension();
            //$image->move($this->_profile_pic_folder, $filename);
            $image_resize = Image::make($image->getRealPath());
            $image_resize->widen(250);
            $image_resize->save(public_path($this->_profile_pic_folder.'/' .$filename));
        }
        $mainData->save();
        return redirect()->route($this->pageData['routeFirstName'].'-list')->with(['success'=>$this->pageData['pageName'].' Created Successfully.']);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\EmailList  $emailList
     * @return \Illuminate\Http\Response
     */
    public function show(EmailList $emailList)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\EmailList  $emailList
     * @return \Illuminate\Http\Response
     */
    public function edit(EmailList $emailList)
    {
        return $this->create()
            ->withIsSetEmail($emailList)
            ;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\EmailList  $emailList
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, EmailList $emailList)
    {
        //dd($request->all());
        $loggedUseruser = Auth::user();
        if(!$loggedUseruser->can_manage_user())
        {
            return redirect()->back()->with(['fail'=>'Unauthorized Access.']);
        }
        //$team_ids = $loggedUseruser->role->managed_user_team_ids();
        //dd($team_ids);
        $request->validate([
            'name' => 'required|max:255',
            'email' => 'required|max:255',
            'image' => 'mimes:jpeg,jpg,png,JPEG,JPG,PNG | max:1000'
        ]);

        $mainData = $emailList;
        $mainData->name = $request['name'];
        $mainData->email = $request['email'];

        if ($request->has('type')) {
            $mainData->type = $request['type'];
        }

        if ($request->has('status')) {
            $mainData->status = $request['status'];
        }

        $mainData->description = $request['description'];

        if($request->hasFile('profile_img'))
        {
            $image = $request->file('profile_img');
            $mainData->image = $filename = time() . '.' . $image->getClientOriginalExtension();
            //$image->move($this->_profile_pic_folder, $filename);
            $image_resize = Image::make($image->getRealPath());
            $image_resize->widen(250);
            $image_resize->save(public_path($this->_profile_pic_folder.'/' .$filename));
        }
        $mainData->save();
        return redirect()->route($this->pageData['routeFirstName'].'-list')->with(['success'=>$this->pageData['pageName'].' updated Successfully.']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\EmailList  $emailList
     * @return \Illuminate\Http\Response
     */
    public function destroy(EmailList $emailList)
    {
        $emailList->delete();
        return redirect()->route($this->pageData['routeFirstName'].'-list')->with(['success'=>$this->pageData['pageName'].' delete Successfully.']);
    }
}
