<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class Commercial extends Model
{
    public function party()
    {
        return $this->belongsTo(Party::class);
    }

    public function accessories()
    {
        return $this->belongsTo(Accessories::class);
    }

    public function monthWiseCommercial($yr, $startMonth="Jan")
    {
        $commercialLcPerMonth = [];
        $commercialLC_Val = [
            'lc' => [],
            'acceptance' => [],
            'payment' => [],
        ];

        if ($startMonth === "Jan") {
            for ($i=1; $i<=12; $i++){
                $monthName = Carbon::create()->month($i)->shortEnglishMonth;
                $commercialLcPerMonth['lc'][$monthName] = $this->whereYear('lc_date', $yr)
                    ->whereMonth('lc_date', $i)
                    //->whereIn('history_type', ['Running'])
                    //->with('lc_value')
                    ->get();

                $commercialLcPerMonth['acceptance'][$monthName] = $this->whereYear('bank_acceptance_date', $yr)
                    ->whereMonth('bank_acceptance_date', $i)
                    ->get();

                $commercialLcPerMonth['payment'][$monthName] = $this->whereYear('payment_date', $yr)
                    ->whereMonth('payment_date', $i)
                    ->get();

                foreach ($commercialLcPerMonth['lc'][$monthName] as $commercial) {
                    $commercialLC_Val['lc'][$monthName][] = $commercial->lc_value ?? [];
                }

                foreach ($commercialLcPerMonth['acceptance'][$monthName] as $commercial) {
                    $commercialLC_Val['acceptance'][$monthName][] = $commercial->bank_acceptance_amount ?? [];
                }

                foreach ($commercialLcPerMonth['payment'][$monthName] as $commercial) {
                    $commercialLC_Val['payment'][$monthName][] = $commercial->payment_amount ?? [];
                }

            }
        }

        return [
            'lc'=>[ $commercialLcPerMonth['lc'], $commercialLC_Val['lc'] ],
            'acceptance'=>[ $commercialLcPerMonth['acceptance'], $commercialLC_Val['acceptance'] ],
            'payment'=>[ $commercialLcPerMonth['payment'], $commercialLC_Val['payment'] ],
        ];
    }
}
