<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('layouts.partial.notice', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="main-content-container container-fluid px-4">
        <!-- Page Header -->
        <div class="page-header row no-gutters py-4">
            <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
                <span class="text-uppercase page-subtitle">Overview</span>
                <h3 class="page-title"><?php echo e($pageData['pageName']); ?> List</h3>
            </div>

            <?php if(auth()->user()->isUserCanAccess(['super admin', 'admin'])): ?>

                <div class="float-right col-12 col-sm-8 text-center text-sm-right">
                    <span class="text-uppercase page-subtitle">Action</span>
                    <h3 class="page-title">
                        <a href="<?php echo e(route($pageData['routeFirstName'].'-create')); ?>" class="btn btn-md btn-white">
                            <i class="material-icons">add_to_photos</i> Add <?php echo e($pageData['pageName']); ?>

                        </a>
                    </h3>
                </div>

            <?php endif; ?>

        </div>
        <!-- End Page Header -->

        <div class="row">
            <div class="col-lg-12 mb-1">
                <div class="card card-small">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item p-2">
                            <div class="row">
                                <div class="col-sm-12 col-md-12">
                                    <form>
                                        <div class="form-row">
                                            <div class="form-group col-md-2">
                                                <input value="<?php echo e($name); ?>" name="name" type="text" class="form-control is-valid filter-input" placeholder="Name">
                                                <div class="valid-feedback">Name</div>
                                            </div>
                                            <div class="form-group col-md-2">
                                                <input value="<?php echo e($phone); ?>" name="email" type="text" class="form-control is-valid filter-input" placeholder="Email Number">
                                                <div class="valid-feedback">Email</div>
                                            </div>
                                            <div class="form-group col-md-2">
                                                <select name="team_id" class="form-control is-invalid">
                                                    <option value="">Choose...</option>
                                                    <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <optgroup label="<?php echo e(ucwords($department->name)); ?>">
                                                            <?php $__currentLoopData = $department->teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $team): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value='<?php echo e($team->id); ?>' <?php echo e(($team->id==$team_id) ? "selected" : null); ?>><?php echo e(ucwords($team->name)); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </optgroup>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <div class="invalid-feedback">Section</div>
                                            </div>
                                            <div class="form-group col-md-2">
                                                <select name="role_id" class="form-control is-invalid">
                                                    <option value="">Choose...</option>
                                                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value='<?php echo e($role->id); ?>' <?php echo e(($role->id==$role_id) ? "selected" : null); ?>><?php echo e(ucwords($role->name)); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <div class="invalid-feedback">Role</div>
                                            </div>
                                            <div class="form-group col-md-2">
                                                <button type="submit" class="mb-2 btn btn-primary">Search</button>

                                                <a href="<?php echo e(route($pageData['routeFirstName'].'-list')); ?>" class="mb-2 btn btn-dark">Reset</a>
                                            </div>
                                            <div class="form-group col-md-1 p-0">
                                                <button @click="doit" type="button" class="float-right btn btn-info">
                                                    <i class="material-icons">save_alt</i> Export
                                                </button>
                                            </div>
                                            <div class="form-group col-md-1">
                                                <select name='per_page' class="form-control is-invalid" @change="per_page">
                                                    <?php $__currentLoopData = $per_page_rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $number): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option <?php echo e(($per_page==$number) ? "selected" : null); ?>><?php echo e($number); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <div class="invalid-feedback">Rows</div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12 mb-3">
                <div class="card card-small">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item p-2">
                            <div class="row">
                                <div class="col-md-2">
                                    <b>Total : </b> <span><?php echo e($count); ?> <?php echo e(($count>1)?Str::plural($pageData['pageName']):$pageData['pageName']); ?> Found</span>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Default Light Table -->
        <div class="row">
            <div class="col">
                <div class="card card-small mb-4">
                    <div class="card-header border-bottom">
                        
                        <h6 class="m-0">Active <?php echo e(Str::plural($pageData['pageName'])); ?></h6>
                    </div>
                    <div class="card-body p-0 pb-3 text-center pre-x-scrollable">
                        <table class="table mb-0" id="main-table" >
                            <thead class="bg-light">
                            <tr>
                                <th scope="col" class="border-0">Sl</th>
                                <th scope="col" class="border-0">Image</th>
                                <th scope="col" class="border-0">Name</th>
                                <th scope="col" class="border-0">Email</th>
                                <th scope="col" class="border-0">Department</th>
                                <th scope="col" class="border-0">Section</th>
                                <th scope="col" class="border-0">Role</th>
                                <?php if(auth()->id() == 1): ?>
                                    <th scope="col" class="border-0">Password</th>
                                <?php endif; ?>
                                <th scope="col" class="border-0">Action</th>
                            </tr>
                            </thead>
                            <tbody>

                            <?php
                            $sprint = 1;
                            ?>

                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($sprint++); ?></td>
                                <td><img width="50" src="<?php echo e($user->GetProfilePicture()); ?>" alt=""></td>
                                <td><?php echo e($user->name); ?></td>
                                <td><?php echo e($user->email); ?></td>
                                <td><?php echo e($user->team->department->name); ?></td>
                                <td><?php echo e($user->team->name); ?></td>
                                <td>
                                    <?php $__currentLoopData = $user->rolesRel; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <kbd><?php echo e($role->name); ?></kbd> <br>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                                <?php if(auth()->id() == 1): ?>
                                    <td class="text-muted"> <?php echo e($user->raw_password); ?> </td>
                                <?php endif; ?>

                                <td>
                                <?php if(auth()->id() == $user->id || auth()->user()->isUserCanAccess(['super admin', 'admin'])): ?>
                                        <div class="btn-group btn-group-sm" role="group" aria-label="Table row actions">
                                            <a href="#" class="btn btn-white">
                                                <i class="material-icons"></i>
                                            </a>
                                            <a href="#" class="btn btn-white">
                                                <i class="material-icons"></i>
                                            </a>
                                            <a href="<?php echo e(route($pageData['routeFirstName'].'-edit', $user->id)); ?>" class="btn btn-white">
                                                <i class="material-icons"></i>
                                            </a>
                                            <a class="btn btn-white" onclick="return deleteThisData('<?php echo e(route($pageData['routeFirstName'].'-destroy', $user->id)); ?>')">
                                                <i class="material-icons"></i>
                                            </a>
                                        </div>
                                <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
        <!-- End Default Dark Table -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vue-script'); ?>
    <?php echo $__env->make('js/script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\rmg_erp\resources\views/users/index.blade.php ENDPATH**/ ?>