


<!-- The Modal -->
<div class="modal fade" id="operation-modal">
    <div class="modal-dialog">
        <div class="modal-content">

            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Shipment</h4>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>

            <!-- Modal body -->
            <div class="modal-body">
                <form action="<?php echo e(route('shipment-store')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="form-row">
                        <input type="hidden" name="order_id" value="<?php echo e($order->id); ?>">
                        <div class="form-group col-md-6">
                            <label>Quantity</label>
                            <input name="quantity" type="number" placeholder="Quantity" value="" class="form-control" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label>Date</label>
                            <input name="date" type="date" placeholder="Date" class="form-control">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Status</label>
                            <select name="status" class="form-control" required>
                                <option disabled selected>Choose...</option>
                                <option value="Partial">Partial</option>
                                <option value="ShipOut">ShipOut</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <button class="btn btn-primary">Save</button>
                        </div>
                    </div>
                </form>
            </div>

            <!-- Modal footer -->
            

        </div>
    </div>
</div>
<div class="modal fade" id="shipment_edit-operation-modal">
    <div class="modal-dialog">
        <div class="modal-content">

            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Shipment Edit</h4>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>

            <!-- Modal body -->
            <div class="modal-body">
                <form action="<?php echo e(route('shipment-store')); ?>" method="post">
                    <?php echo method_field("PATCH"); ?>
                    <?php echo csrf_field(); ?>
                    <div class="form-row">
                        <input type="hidden" name="order_id" value="<?php echo e($order->id); ?>">
                        <div class="form-group col-md-6">
                            <label>Quantity</label>
                            <input name="quantity" type="number" placeholder="Quantity" value="" class="form-control" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label>Date</label>
                            <input name="date" type="date" placeholder="Date" class="form-control">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Status</label>
                            <select name="status" class="form-control" required>
                                <option disabled selected>Choose...</option>
                                <option value="Partial">Partial</option>
                                <option value="ShipOut">ShipOut</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <button class="btn btn-primary">Update</button>
                        </div>
                    </div>
                </form>
            </div>

            <!-- Modal footer -->
            

        </div>
    </div>
</div>
<!-- End Modal -->


    <div class="row text-capitalize">
        <div class="col-sm-12 col-lg-4">
            <!-- User Details Card -->
            <div class="card card-small user-details mb-4 text-capitalize">
                <div class="card-header p-0">
                    <div class="user-details__bg">
                        <img src="<?php echo e(asset('profile-pic/system/up-user-details-background.jpg')); ?>" alt="User Details Background Image">
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="user-details__avatar mx-auto ">
                        <img class="rounded" src="<?php echo e($order->getGarmentsPicture()); ?>" alt="User Avatar">
                    </div>
                    <h4 class="text-center m-0 mt-2"><?php echo e($order->name); ?></h4>
                    <p class="text-center text-light m-0 mb-2"><?php echo e($order->buyer->name); ?> (<?php echo e($order->buyer->agent->name ?? 'None'); ?>)</p>
                    
                    <div class="user-details__user-data border-top border-bottom p-4">
                        <div class="row mb-3">
                            <div class="col w-50">
                                <span>Activity</span>
                                <span><?php echo e(isset($order->user) ? $order->user->name : 'none'); ?></span>
                            </div>
                            <div class="col w-50">
                                <span>Sale's</span>
                                <span><?php echo e(isset($order->sales_user) ? $order->sales_user->name : 'none'); ?></span>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col w-50">
                                <span>Reporting to</span>
                                <span><?php echo e(isset($order->reporting_user) ? $order->reporting_user->name : 'none'); ?></span>
                            </div>

                        </div>
                    </div>
                    
                </div>
            </div>
            <!-- End User Details Card -->
            <!-- Contact User -->
            <div class="card card-small mb-4">
                <div class="card-header border-bottom">
                    <h6 class="m-0">Send Message</h6>
                    <div class="block-handle"></div>
                </div>
                <div class="card-body">
                    <form action="">
                        <textarea name="" id="" cols="30" rows="6" class="form-control mb-3" style="min-height: 150px;"></textarea>
                        <button type="submit" class="btn btn-accent btn-sm">Send Message</button>
                    </form>
                </div>
            </div>
            <!-- End Contact User -->
            <!-- User Teams -->
            
            <!-- End User Teams -->
        </div>

        <div class="col-lg-8">

            <div class="btn-group btn-group-lg mb-4" role="group" aria-label="Table row actions">
                <a href="#" onclick="printOrderInfo(<?php echo e($order->id); ?>)" class="btn btn-white" id="Print" title="Print">
                    <i class="material-icons">print</i>
                </a>
                <button type="button" class="btn btn-white" data-toggle="modal" data-target="#operation-modal" id="Shipment" title="Shipment">
                    <i class="material-icons">local_shipping</i>
                </button>

                <a href="<?php echo e(route('order-edit',[$order->id, 'edit'=>'order'])); ?>" class="btn btn-white" id="Edit" title="Edit">
                    <i class="material-icons">&#xE254;</i>
                </a>
                <button onclick="deleteThisData('<?php echo e(route('order-destroy',$order->id)); ?>')" type="button" class="btn btn-white" id="Delete" title="Delete">
                    <i class="material-icons">&#xE872;</i>
                </button>
            </div>
            <!-- User Statistics -->
            <?php if($order->quantity->first()): ?>
                <div class="card card-small user-stats mb-4">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-6 col-sm-3 text-center">
                                <h4 class="m-0"><?php echo e($order->quantity->sum('quantity')); ?></h4>
                                <span class="text-light text-uppercase">Order Quantity</span>
                            </div>
                            <div class="col-6 col-sm-3 text-center">
                                <h4 class="m-0"><?php echo e($order->cutting->sum('quantity')); ?></h4>
                                <span class="text-light text-uppercase">Production In</span>
                            </div>
                            <div class="col-6 col-sm-3 text-center">
                                <h4 class="m-0"><?php echo e($order->packing->sum('quantity')); ?></h4>
                                <span class="text-light text-uppercase">Ready For Shipment</span>
                            </div>
                            <div class="col-6 col-sm-3 text-center">
                                <h4 class="m-0"><?php echo e(round(($order->packing->sum('quantity')/$order->quantity->sum('quantity'))*100, 2)); ?>%</h4>
                                <span class="text-light text-uppercase">Completed</span>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer py-0">
                        <div class="row">
                            <div class="col-12 col-sm-6 border-top pb-3 pt-2 border-right">
                                <div class="progress-wrapper">
                                    <span class="progress-label">Workload</span>
                                    <div class="progress progress-sm">
                                        <div class="progress-bar progress-bar-striped" role="progressbar" aria-valuenow="80" aria-valuemin="0" aria-valuemax="100" style="width: 80%;">
                                            <span class="progress-value">80%</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 border-top pb-3 pt-2">
                                <div class="progress-wrapper">
                                    <span class="progress-label">Performance</span>
                                    <div class="progress progress-sm">
                                        <div class="progress-bar progress-bar-striped bg-success" role="progressbar" aria-valuenow="92" aria-valuemin="0" aria-valuemax="100" style="width: 92%;">
                                            <span class="progress-value">92%</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="card card-small mb-4">
                <div class="card-header border-bottom ">
                    <h6 class="m-0"><b class="badge badge-secondary " style="font-size: 1rem"><span><?php echo e(ucwords($order->name)); ?> </span> - <span>ID: <?php echo e($order->id); ?></span></b> - Current status of this order</h6>
                </div>
                <div class="card-body p-0">
                    <div class="container-fluid px-0">
                        <table class="table mb-0">
                            <thead class="py-2 bg-light text-semibold border-bottom">
                            <tr>
                                <th>Details</th>
                                <th></th>
                                <th></th>
                                <th class="text-center">CurrentTNA</th>
                                <th class="text-center">ShipQty</th>
                                <th class="text-center">Short</th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <td class="lo-stats__image">
                                    <img class="border rounded" src="<?php echo e($order->getGarmentsPicture()); ?>">
                                </td>
                                <td class="lo-stats__order-details">
                                    <span><b class="text-primary">Quantity: <?php echo e($order->quantity->sum('quantity')); ?></b></span>
                                    <span></span>
                                </td>
                                <td>UnitPrice:
                                    <?php echo e($order->unit_price); ?>

                                </td>
                                <td class="lo-stats__status">
                                    <div class="d-table mx-auto">
                                        <span class="badge badge-pill badge-success"><?php echo e($order->status->name ?? null); ?></span>
                                    </div>
                                </td>
                                <td class="lo-stats__items text-center">
                                    <?php echo e($shipmentQty = $order->shipment->sum('quantity')); ?>

                                </td>
                                <td class="text-center text-success">
                                    <span class="badge badge-danger">
                                    <?php echo e($shipmentQty*$order->unit_price); ?> -
                                    <?php echo e($totalValue = $order->quantity->sum('quantity')*$order->unit_price); ?>

                                    </span>
                                    <br>
                                    <?php echo e($shipmentQty?$shipmentQty*$order->unit_price-$totalValue:null); ?>

                                </td>

                            </tr>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Weekly Performance -->
            <div class="card card-small mb-4">
                <div class="card-header border-bottom ">
                    <h6 class="m-0">Shipment Operations</h6>
                </div>
                <div class="card-body p-0">
                    <div class="container-fluid px-0">
                        <table class="details-table ">
                            <thead class="py-2 bg-light text-semibold border-bottom">
                            <tr>
                                <th>SL</th>
                                <th>Quantity</th>
                                <th>Date</th>
                                <th class="text-center">Status</th>
                                <th>Processed By</th>
                                <th>entry date</th>
                                <th class="text-right">Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $order->shipment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shipment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <?php echo e(++$pageData['no']); ?>

                                    </td>
                                    <td>
                                        <?php echo e($shipment->quantity); ?>

                                    </td>
                                    <td>
                                        <?php echo e($shipment->date); ?>

                                    </td>
                                    <td class="lo-stats__status">
                                        <div class="d-table mx-auto">
                                            <span class="badge badge-pill badge-success"><?php echo e($shipment->status); ?></span>
                                        </div>
                                    </td>
                                    <td>
                                        <?php echo e($shipment->user->name); ?>

                                    </td>
                                    <td>
                                        <?php echo e($shipment->created_at); ?>

                                    </td>
                                    <td class="lo-stats__actions">
                                        <div class="btn-group btn-group-sm" role="group" aria-label="Table row actions">
                                            <button type="button" class="btn btn-white" onclick="shipmentRowClickData(this, <?php echo e($shipment->id); ?>)" data-toggle="modal" data-target="#shipment_edit-operation-modal">
                                                <i class="material-icons">&#xE254;</i>
                                            </button>
                                            <?php if(auth()->id() == 1): ?>
                                                <button type="button" class="btn btn-white" onclick="deleteThisData('<?php echo e(route('shipment-destroy', $shipment->id)); ?>')">
                                                    <i class="material-icons">cancel_presentation</i>
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- End User Activity -->
        </div>
    </div>


<?php $__env->startSection('jQuery-code'); ?>
    <script>
        function shipmentRowClickData(elm, $$$shipmentID){
            let form = $("#shipment_edit-operation-modal").find("form");
            let prevAction = form.attr("action");
            //console.log($$$shipmentID);
            let tr = $(elm).closest("tr");
            let qty = tr.find("td")[1].innerText;
            let date = tr.find("td")[2].innerText;

            let status = tr.find("td")[3].innerText;
            form[0].quantity.value = qty;
            form[0].date.value = date;
            form[0].status.value = status;


            let url = "<?php echo e(route("shipment-update", "::orderID")); ?>";
            url = url.replace("::orderID", $$$shipmentID);

            console.log(url);


            form.attr("action", url);

        }

        $( function() {
            $( "#Print" ).tooltip({
                show: {
                    effect: "slideDown"
                }
            });
            $( "#Edit" ).tooltip({
                show: {
                    effect: "slideDown"
                }
            });
            $( "#Shipment" ).tooltip({
                show: {
                    effect: "slideDown"
                }
            });
            $( "#Delete" ).tooltip({
                show: {
                    effect: "slideDown"
                }
            });

        } );
    </script>
<?php $__env->stopSection(); ?>
<?php /**PATH E:\xampp\htdocs\rmg_erp\resources\views/layouts/orderDetails/order_details.blade.php ENDPATH**/ ?>