<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('layouts.partial.notice', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="main-content-container container-fluid px-4">
        <!-- Page Header -->
        <div class="page-header row no-gutters py-4">
            <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
                <span class="text-uppercase page-subtitle">Overview</span>
                <h3 class="page-title">User Activity List</h3>
            </div>
        </div>
        <!-- End Page Header -->

        <div class="row">
            <div class="col-lg-12 mb-1">
                <div class="card card-small">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item p-2">
                            <div class="row">
                                <div class="col-sm-12 col-md-12">
                                    <form>
                                        <div class="form-row">



                                            <div class="form-group col-md-1 pl-0">
                                                <select class="select2-box-manual form-control" name="orderBy">
                                                    <option value="<?php echo e($filterArray['orderBy']); ?>"><?php echo e($filterArray['orderBy'] ?? 'Select...'); ?></option>
                                                    <option value="created_at">First Login</option>
                                                    <option value="updated_at">Last Active</option>
                                                </select>
                                                <div class="filter-name">Sorting</div>
                                            </div>

                                            <div class="col-md-10">
                                                <div style="max-width: 240px" id="analytics-overview-date-range" class="input-daterange input-group input-group-md ml-auto">
                                                    <input value="<?php echo e($filterArray['from']); ?>" autocomplete="off" type="text" class="input-sm form-control" name="from" placeholder="Start Date">
                                                    <input value="<?php echo e($filterArray['to']); ?>" autocomplete="off" type="text" class="input-sm form-control" name="to" placeholder="End Date">
                                                </div>
                                            </div>

                                            <div class="form-group col-md-1">
                                                <button type="submit" class="mb-2 btn btn-primary">Search</button>
                                            </div>
                                            
                                            
                                            
                                            
                                            
                                            
                                            
                                            
                                            
                                            
                                            

                                            
                                            
                                            
                                            
                                            
                                            

                                            
                                            
                                            
                                            
                                            

                                            
                                            


                                        </div>
                                    </form>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12 mb-3">
                <div class="card card-small">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item p-2">
                            <div class="row">
                                <div class="col-md-2">
                                    <b>Total : </b> <span>0 Found</span>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- Default Light Table -->
        <div class="row">
            <div class="col">
                <div class="card card-small mb-4">
                    <div class="card-header border-bottom">
                        <h6 class="m-0">Active Users</h6>
                    </div>
                    <div class="card-body p-0 pb-3 text-center">
                        <table class="table mb-0">
                            <thead class="bg-light">
                            <tr>
                                <th scope="col" class="border-0">Sl</th>
                                <th scope="col" class="border-0">Name</th>
                                <th scope="col" class="border-0">First Login</th>
                                <th scope="col" class="border-0">Last Login</th>
                                <th scope="col" class="border-0">Activity</th>
                                <th scope="col" class="border-0">Last Active</th>
                                <th scope="col" class="border-0">Last Route</th>
                                <th scope="col" class="border-0">All Day Routing</th>
                                
                            </tr>
                            </thead>
                            <tbody>

                            <?php $__currentLoopData = $userActivitiesDateGroup; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date => $userActivities): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <?php $sl=0; ?>
                                    <td colspan="8" class="bg-secondary" >
                                        <h3 class="text-white font-weight-bold" style="letter-spacing: 5px"><?php echo e(Carbon::parse($date)->format('(F) d-m-Y')); ?></h3>
                                    </td>
                                </tr>
                                <?php $__currentLoopData = $userActivities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $userActivity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <?php

                                    $urls = explode('|', $userActivity->all_day_routing_urls);
                                    $first_login = Carbon::parse($userActivity->first_login);
                                    $last_login = Carbon::parse($userActivity->last_login);
                                    $last_active = Carbon::parse($userActivity->last_active);

                                    $settingsOwnNetworkIpCollect = collect(explode('|', $settingsOwnNetworkIP));


                                    $ipArray = $settingsOwnNetworkIpCollect->map(function ($ff){
                                        return App\Traits\Functions::removeLastPartFromIp($ff);
                                    });


                                    //$ownNetworkIP = App\Traits\Functions::removeLastPartFromIp($settingsOwnNetworkIP);
                                    $first_login_ip = App\Traits\Functions::removeLastPartFromIp($userActivity->first_login_ip);
                                    $last_login_ip = App\Traits\Functions::removeLastPartFromIp($userActivity->last_login_ip);

                                    $fromOffice = [true, 'From Office'];
                                    $fromOutside = [false, $last_login_ip?'From Outside':null];

                                    $first_login_from = $ipArray->contains($first_login_ip) ? $fromOffice : $fromOutside;
                                    $last_login_from = $ipArray->contains($last_login_ip) ? $fromOffice : $fromOutside;


                                    $activeExplode = explode(' & ', $userActivity->activity);

                                    $activeCount = count($activeExplode);
                                    $totMnt = 0;

                                    //dd($activeExplode);

                                    if ($activeCount > 0) {
                                        foreach ($activeExplode as $item) {
                                            $twoTimes = explode('-', $item);

                                            $one = Carbon::parse($twoTimes[0]);
                                            $two = Carbon::parse(isset($twoTimes[1]) && $twoTimes[1] != '' ? $twoTimes[1] : $last_active->format('H:i:s'));

                                            //dump(isset($twoTimes[0]), isset($twoTimes[1]) && $twoTimes[1] != '');
                                            //echo $twoTimes[0].' <> '.$twoTimes[1] .' | ';

                                            $totMnt = $totMnt + $one->diffInMinutes($two);
                                        }
                                    }

                                    $totMnt = Carbon\CarbonInterval::minutes($totMnt)->cascade()->forHumans();


                                    //$first_login_from = ($first_login_ip == $ownNetworkIP) ? $fromOffice : $fromOutside;
                                    //$last_login_from = ($last_login_ip == $ownNetworkIP) ? $fromOffice : $fromOutside;

                                    //$myself = $userActivity->user->id == auth()->id(); //->isUserCanAccess(['order approve'])
                                    $orderApproveUserCheck = $userActivity->user->usersRoleCheck(['order approve'])
                                        //{{ $myself ? 'bg-secondary text-white':null }}
                                    ?>

                                    <tr class="<?php echo e($orderApproveUserCheck ? 'bg-java text-white':null); ?>">
                                        <td>
                                            <span class="px-1 bg-warning rounded text-black small">Sl:<?php echo e(++$sl); ?></span>
                                            <span class="px-1 bg-info rounded text-white small">ID: <?php echo e($userActivity->user->id); ?></span>
                                            <br>
                                            <span class="rounded bg-dark text-white small">&nbsp;<?php echo e($first_login->format('d-m-Y')); ?>&nbsp;</span>
                                        </td>
                                        <td>
                                            <b class="font-weight-bold"><?php echo e($userActivity->user->name); ?></b>
                                            <br><?php echo e($userActivity->user->email); ?>

                                        </td>
                                        <td>
                                            <div class="text-white rounded small <?php echo e($first_login_from[0] ? 'bg-primary':'bg-danger'); ?>"><?php echo e($first_login_from[1]); ?></div>

                                            <div class="rounded bg-dark text-white small mt-1"><?php echo e($first_login->format('g:i A')); ?></div>
                                        </td>
                                        <td>
                                            <div class="text-white rounded small <?php echo e($last_login_from[0] ? 'bg-primary':'bg-danger'); ?>">
                                                <?php echo e($last_login_from[1]); ?>

                                            </div>
                                            

                                            <div class="rounded bg-dark text-white small mt-1"><?php echo e($last_login->format('g:i A')); ?></div>

                                        </td>

                                        <td>
                                            <div class="bg-warning text-black font-weight-bold rounded small"><?php echo e($totMnt != '1 second'?$totMnt:'Less 1 minute'); ?></div>
                                            <div class="bg-secondary text-white rounded small mt-1">( <?php echo e($activeCount); ?> ) <?php echo e($last_active->longAbsoluteDiffForHumans($first_login)); ?></div>
                                        </td>

                                        <td>
                                            <div>
                                                <?php if($last_active->diffInMinutes() >= 1): ?>
                                                    <div class="bg-salmon text-white rounded small">
                                                        <?php echo e($last_active->diffForHumans()); ?>

                                                    </div>

                                                    <div class="rounded bg-dark text-white small mt-1"><?php echo e($last_active->format('g:i A')); ?></div>
                                                <?php else: ?>
                                                    <div class="bg-success text-white font-weight-bold rounded small">
                                                        Active
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                            
                                        </td>

                                        <td>
                                            <div class="border border-danger small rounded">
                                                <?php echo e($userActivity->last_route_url); ?>

                                            </div>
                                        </td>

                                        <td>
                                            <div class="overflow-auto" style="max-height: 400px">
                                                <?php $__currentLoopData = $urls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php
                                                    $urlExplode = explode('->', $url);
                                                    //$onlyUrl = substr($url, 0, strpos($url, '->'));
                                                    $onlyUrl = $urlExplode[0] ? $urlExplode[0]: 'Logging Out';
                                                    $time = isset($urlExplode[1]) ? $urlExplode[1]: null;
                                                    $sprint = $key + 1;
                                                    ?>
                                                    <div class=" <?php echo e($onlyUrl != 'Logging Out'? null:'text-danger font-weight-bold'); ?>">
                                                        <span><?php echo e($sprint); ?></span>. <span class="font-italic"><?php echo e($onlyUrl); ?></span> <small class="bg-dark text-white rounded"> <?php echo e($time); ?> <i class="material-icons">arrow_downward</i> </small>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </td>
                                        
                                        
                                        
                                        
                                        
                                        
                                        
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Default Dark Table -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vue-script'); ?>
    <script>
        let isTabActive = true;

        window.onfocus = function () {
            isTabActive = true;
        };

        window.onblur = function () {
            isTabActive = false;
        };

        setInterval(()=>{
            if (isTabActive) {
                location.reload();
            }
        }, 1000 * 40);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\rmg_erp\resources\views/userActivity/index.blade.php ENDPATH**/ ?>