<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


//___ old erp tools
use App\Http\Controllers\UtilityController;
use App\Http\Middleware\CommercialAccess;
use App\Http\Middleware\RoleCheckMiddleware;

Route::prefix('old_erp')->group(function (){
    $prefixName = 'old_erp';
    $controllerName = Str::studly($prefixName);
    //Route::get('list', $controllerName.'Controller@index')->name($prefixName.'-list');
    //Route::get('rm', $controllerName.'Controller@rmData')->name($prefixName.'-rm');
    //Route::get('test', $controllerName.'Controller@test')->name($prefixName.'-test');
});


//prefix listed Route
/*
 * 1 user
 * 2 buyer
 * 3 agent
 * 4 role
 * 5 department
 * 6 team
 * 7 order-status
 * 8 order-category
 * 9 order-sub-category
 * 10 order
 * 11 shipment
 * 12 production
 * 13 sub-contractor
 * 14 production-line
 * 15 budget
 * 16 color-lib
 * 17 size-lib
 * 18 order-size-n-color
 * 19 kd-program
 * 20 order-pending
 * 21 kd-parts-lib
 * 22 kd-issue
 * 23 supplier
 * 24 booking
 * 25 accessories
 * 26 order-size-n-color //order quantity //OrderSizeNColor
 * 27 utility
 * 28 email
 * 29 setting
 * 30 budget-post-cost
 * 31 User Activity
 * 32 Party
 * 33 commercial
 * 34 Commercial Invoice
 * 35 Business Gap
 * */



Route::get('/clear', function() {
    $exitCode = Artisan::call('cache:clear');
    // return what you want
});

Route::get('/lara', function () {
    return view('welcome');
});

Route::get('/', 'HomeController@index')->name('homePage');

Auth::routes();

Route::get('/home', 'HomeController@index')->name('home'); //middleware('auth')


Route::middleware('auth')->group(function (){

//___1
    Route::prefix('user')->group(function (){
        Route::get('list', 'UserController@index')->name('user-list');
        Route::get('show', 'UserController@show')->name('user-show');
        Route::post('password-change', 'UserController@passwordChange')->name('password-change');
        Route::get('edit/{user}', 'UserController@edit')->name('user-edit');
        Route::patch('update/{user}', 'UserController@update')->name('user-update');

        Route::middleware(RoleCheckMiddleware::class . ':super admin,admin')->group(function () {
            Route::get('create', 'UserController@create')->name('user-create');
            Route::post('store', 'UserController@store')->name('user-store');
            Route::get('destroy/{user}', 'UserController@destroy')->name('user-destroy');
        });
    });

//___2
    Route::prefix('buyer')->group(function (){
        $prefixName = 'buyer';
        $controllerName = 'Buyer';
        Route::get('list', $controllerName.'Controller@index')->name($prefixName.'-list');
        Route::get('create', $controllerName.'Controller@create')->name($prefixName.'-create');
        Route::post('store', $controllerName.'Controller@store')->name($prefixName.'-store');
        Route::get('show', $controllerName.'Controller@show')->name($prefixName.'-show');
        Route::get('edit/{'.$prefixName.'}', $controllerName.'Controller@edit')->name($prefixName.'-edit');
        Route::patch('update/{'.$prefixName.'}', $controllerName.'Controller@update')->name($prefixName.'-update');
        Route::get('destroy', $controllerName.'Controller@destroy')->name($prefixName.'-destroy');
    });

//___3
    Route::prefix('agent')->group(function (){
        $prefixName = 'agent';
        $controllerName = 'Agent';
        Route::get('list', $controllerName.'Controller@index')->name($prefixName.'-list');
        Route::get('create', $controllerName.'Controller@create')->name($prefixName.'-create');
        Route::post('store', $controllerName.'Controller@store')->name($prefixName.'-store');
        Route::get('show', $controllerName.'Controller@show')->name($prefixName.'-show');
        Route::get('edit/{'.$prefixName.'}', $controllerName.'Controller@edit')->name($prefixName.'-edit');
        Route::patch('update/{'.$prefixName.'}', $controllerName.'Controller@update')->name($prefixName.'-update');
        Route::get('destroy', $controllerName.'Controller@destroy')->name($prefixName.'-destroy');
    });

//___4
    Route::prefix('role')->group(function (){
        Route::get('list', 'RoleController@index')->name('role-list');
        Route::get('create', 'RoleController@create')->name('role-create');
        Route::post('store', 'RoleController@store')->name('role-store');
        Route::get('show', 'RoleController@show')->name('role-show');
        Route::get('edit/{role}', 'RoleController@edit')->name('role-edit');
        Route::patch('update/{role}', 'RoleController@update')->name('role-update');
        Route::get('destroy/{role}', 'RoleController@destroy')->name('role-destroy');
    });

//___5
    Route::prefix('department')->group(function (){
        Route::get('list', 'DepartmentController@index')->name('department-list');
        Route::get('create', 'DepartmentController@create')->name('department-create');
        Route::post('store', 'DepartmentController@store')->name('department-store');
        Route::get('show', 'DepartmentController@show')->name('department-show');
        Route::get('edit/{department}', 'DepartmentController@edit')->name('department-edit');
        Route::patch('update/{department}', 'DepartmentController@update')->name('department-update');
        Route::get('destroy/{department}', 'DepartmentController@destroy')->name('department-destroy');
    });

//___6
    Route::prefix('team')->group(function (){
        Route::get('list', 'TeamController@index')->name('team-list');
        Route::get('create', 'TeamController@create')->name('team-create');
        Route::post('store', 'TeamController@store')->name('team-store');
        Route::get('show', 'TeamController@show')->name('team-show');
        Route::get('edit/{team}', 'TeamController@edit')->name('team-edit');
        Route::patch('update/{team}', 'TeamController@update')->name('team-update');
        Route::get('destroy/{team}', 'TeamController@destroy')->name('team-destroy');
    });

//___7
    Route::prefix('order-status')->group(function (){
        Route::get('list', 'OrderStatusController@index')->name('order-status-list');
        Route::get('create', 'OrderStatusController@create')->name('order-status-create');
        Route::post('store', 'OrderStatusController@store')->name('order-status-store');
        Route::get('show', 'OrderStatusController@show')->name('order-status-show');
        Route::get('edit/{orderStatus}', 'OrderStatusController@edit')->name('order-status-edit');
        Route::patch('update/{orderStatus}', 'OrderStatusController@update')->name('order-status-update');
        Route::get('destroy/{orderStatus}', 'OrderStatusController@destroy')->name('order-status-destroy');
    });

//___8
    Route::prefix('order-category')->group(function (){
        $prefixName = 'order-category';
        $controllerName = Str::studly($prefixName);
        Route::get('list', $controllerName.'Controller@index')->name($prefixName.'-list');
        Route::get('create', $controllerName.'Controller@create')->name($prefixName.'-create');
        Route::post('store', $controllerName.'Controller@store')->name($prefixName.'-store');
        Route::get('show', $controllerName.'Controller@show')->name($prefixName.'-show');
        Route::get('edit/{'.Str::camel($prefixName).'}', $controllerName.'Controller@edit')->name($prefixName.'-edit');
        Route::patch('update/{'.Str::camel($prefixName).'}', $controllerName.'Controller@update')->name($prefixName.'-update');
        Route::get('destroy/{'.Str::camel($prefixName).'}', $controllerName.'Controller@destroy')->name($prefixName.'-destroy');
    });

//___9
    Route::prefix('order-sub-category')->group(function (){
        $prefixName = 'order-sub-category';
        $controllerName = Str::studly($prefixName);
        Route::get('list', $controllerName.'Controller@index')->name($prefixName.'-list');
        Route::get('create', $controllerName.'Controller@create')->name($prefixName.'-create');
        Route::post('store', $controllerName.'Controller@store')->name($prefixName.'-store');
        Route::get('show', $controllerName.'Controller@show')->name($prefixName.'-show');
        Route::get('edit/{'.Str::camel($prefixName).'}', $controllerName.'Controller@edit')->name($prefixName.'-edit');
        Route::patch('update/{'.Str::camel($prefixName).'}', $controllerName.'Controller@update')->name($prefixName.'-update');
        Route::get('destroy/{'.Str::camel($prefixName).'}', $controllerName.'Controller@destroy')->name($prefixName.'-destroy');
    });

//___10
    Route::prefix('order')->group(function (){
        $prefixName = 'order';
        $controllerName = Str::studly($prefixName);
        Route::get('list', $controllerName.'Controller@index')->name('order-list');
        Route::get('notApprove-list', $controllerName.'Controller@notApproveIndex')->name('order-notApprove-list');
        Route::get('edit-request-list', $controllerName.'Controller@editRequestIndex')->name('order-edit-request-list');

        //Route::get('edit-request-list', 'OrderEditRequestController@index')->name($prefixName.'-edit-request-list');

        Route::get('approve-order/{'.Str::camel($prefixName).'}', $controllerName.'Controller@approveOrder')->name('order-approve-order');
        Route::get('create', $controllerName.'Controller@create')->name('order-create');
        Route::post('store', $controllerName.'Controller@store')->name('order-store');
        Route::get('show/{'.Str::camel($prefixName).'}', $controllerName.'Controller@show')->name('order-show');
        Route::get('edit/{'.Str::camel($prefixName).'}', $controllerName.'Controller@edit')->name('order-edit');
        Route::patch('update/{'.Str::camel($prefixName).'}', $controllerName.'Controller@update')->name('order-update');
        Route::get('destroy/{'.Str::camel($prefixName).'}', $controllerName.'Controller@destroy')->name('order-destroy');
        Route::get('destroy-from-not-approve-order/{'.Str::camel($prefixName).'}', $controllerName.'Controller@destroyFromNotApproveOrder')->name('order-destroy-from-not-approve-order');
        Route::get('cancel-list', $controllerName.'Controller@cancelListIndex')->name('order-cancel-list');
// jewel
        Route::get('print/{'.Str::camel($prefixName).'}', $controllerName.'Controller@print')->name('order-print');
        Route::get('table', $controllerName.'Controller@indexForTable')->name('order-table');
        Route::get('pie-chart', $controllerName.'Controller@indexForPieChart')->name('order-pie-chart');
    });

//___11
    Route::prefix('shipment')->group(function (){
        $prefixName = 'shipment';
        $controllerName = Str::studly($prefixName);
        Route::get('list', $controllerName.'Controller@index')->name($prefixName.'-list');
        Route::get('create', $controllerName.'Controller@create')->name($prefixName.'-create');
        Route::post('store', $controllerName.'Controller@store')->name($prefixName.'-store');
        Route::get('show/{'.Str::camel($prefixName).'}', $controllerName.'Controller@show')->name($prefixName.'-show');
        Route::get('edit/{'.Str::camel($prefixName).'}', $controllerName.'Controller@edit')->name($prefixName.'-edit');
        Route::patch('update/{'.Str::camel($prefixName).'}', $controllerName.'Controller@update')->name($prefixName.'-update');
        Route::get('destroy/{'.Str::camel($prefixName).'}', $controllerName.'Controller@destroy')->name($prefixName.'-destroy');
    });

//___12
    Route::prefix('production')->group(function (){
        $prefixName = 'production';
        $controllerName = Str::studly($prefixName);
        Route::get('list', $controllerName.'Controller@index')->name($prefixName.'-list');
        Route::get('create', $controllerName.'Controller@create')->name($prefixName.'-create');
        Route::post('store/{order}', $controllerName.'Controller@store')->name($prefixName.'-store');
        Route::get('show/{'.Str::camel($prefixName).'}', $controllerName.'Controller@show')->name($prefixName.'-show');
        Route::get('edit/{'.Str::camel($prefixName).'}', $controllerName.'Controller@edit')->name($prefixName.'-edit');
        Route::patch('update/{'.Str::camel($prefixName).'}', $controllerName.'Controller@update')->name($prefixName.'-update');
        Route::get('destroy/{'.Str::camel($prefixName).'}', $controllerName.'Controller@destroy')->name($prefixName.'-destroy');

        Route::post('bulk-store/{order}', $controllerName.'Controller@bulkStore')->name($prefixName.'-bulk-store');

        Route::get('date-wise-list', $controllerName.'Controller@dateWiseList')->name($prefixName.'-date-wise-list');

    });

//___13
    Route::prefix('sub-contractor')->group(function (){
        $prefixName = 'sub-contractor';
        $controllerName = Str::studly($prefixName);
        Route::get('list', $controllerName.'Controller@index')->name($prefixName.'-list');
        Route::get('create', $controllerName.'Controller@create')->name($prefixName.'-create');
        Route::post('store', $controllerName.'Controller@store')->name($prefixName.'-store');
        Route::get('show/{'.Str::camel($prefixName).'}', $controllerName.'Controller@show')->name($prefixName.'-show');
        Route::get('edit/{'.Str::camel($prefixName).'}', $controllerName.'Controller@edit')->name($prefixName.'-edit');
        Route::patch('update/{'.Str::camel($prefixName).'}', $controllerName.'Controller@update')->name($prefixName.'-update');
        Route::get('destroy/{'.Str::camel($prefixName).'}', $controllerName.'Controller@destroy')->name($prefixName.'-destroy');
    });

//___14
    Route::prefix('production-line')->group(function (){
        $prefixName = 'production-line';
        $controllerName = Str::studly($prefixName);
        Route::get('list', $controllerName.'Controller@index')->name($prefixName.'-list');
        Route::get('create', $controllerName.'Controller@create')->name($prefixName.'-create');
        Route::post('store', $controllerName.'Controller@store')->name($prefixName.'-store');
        Route::get('show/{'.Str::camel($prefixName).'}', $controllerName.'Controller@show')->name($prefixName.'-show');
        Route::get('edit/{'.Str::camel($prefixName).'}', $controllerName.'Controller@edit')->name($prefixName.'-edit');
        Route::patch('update/{'.Str::camel($prefixName).'}', $controllerName.'Controller@update')->name($prefixName.'-update');
        Route::get('destroy/{'.Str::camel($prefixName).'}', $controllerName.'Controller@destroy')->name($prefixName.'-destroy');
    });

//___15
    Route::prefix('budget')->group(function (){
        $prefixName = 'budget';
        $controllerName = Str::studly($prefixName);
        Route::get('list', $controllerName.'Controller@index')->name($prefixName.'-list');
        Route::get('create', $controllerName.'Controller@create')->name($prefixName.'-create');
        Route::post('store', $controllerName.'Controller@store')->name($prefixName.'-store');
        Route::get('show/{'.Str::camel($prefixName).'}', $controllerName.'Controller@show')->name($prefixName.'-show');
        Route::get('edit/{'.Str::camel($prefixName).'}', $controllerName.'Controller@edit')->name($prefixName.'-edit');
        Route::patch('update/{'.Str::camel($prefixName).'}', $controllerName.'Controller@update')->name($prefixName.'-update');
        Route::get('destroy/{'.Str::camel($prefixName).'}', $controllerName.'Controller@destroy')->name($prefixName.'-destroy');
    });

//___16
    Route::prefix('color-lib')->group(function (){
        $prefixName = 'color-lib';
        $controllerName = Str::studly($prefixName);
        Route::get('list', $controllerName.'Controller@index')->name($prefixName.'-list');
        Route::get('create', $controllerName.'Controller@create')->name($prefixName.'-create');
        Route::post('store', $controllerName.'Controller@store')->name($prefixName.'-store');
        Route::get('show/{'.Str::camel($prefixName).'}', $controllerName.'Controller@show')->name($prefixName.'-show');
        Route::get('edit/{'.Str::camel($prefixName).'}', $controllerName.'Controller@edit')->name($prefixName.'-edit');
        Route::patch('update/{'.Str::camel($prefixName).'}', $controllerName.'Controller@update')->name($prefixName.'-update');
        Route::get('destroy/{'.Str::camel($prefixName).'}', $controllerName.'Controller@destroy')->name($prefixName.'-destroy');
    });

//___17
    Route::prefix('size-lib')->group(function (){
        $prefixName = 'size-lib';
        $controllerName = Str::studly($prefixName);
        Route::get('list', $controllerName.'Controller@index')->name($prefixName.'-list');
        Route::get('create', $controllerName.'Controller@create')->name($prefixName.'-create');
        Route::post('store', $controllerName.'Controller@store')->name($prefixName.'-store');
        Route::get('show/{'.Str::camel($prefixName).'}', $controllerName.'Controller@show')->name($prefixName.'-show');
        Route::get('edit/{'.Str::camel($prefixName).'}', $controllerName.'Controller@edit')->name($prefixName.'-edit');
        Route::patch('update/{'.Str::camel($prefixName).'}', $controllerName.'Controller@update')->name($prefixName.'-update');
        Route::get('destroy/{'.Str::camel($prefixName).'}', $controllerName.'Controller@destroy')->name($prefixName.'-destroy');
    });

//___18
    Route::prefix('order-size-n-color')->group(function (){
        $prefixName = 'order-size-n-color';
        $controllerName = Str::studly($prefixName);
        Route::get('list', $controllerName.'Controller@index')->name($prefixName.'-list');
        Route::get('create', $controllerName.'Controller@create')->name($prefixName.'-create');
        Route::post('store', $controllerName.'Controller@store')->name($prefixName.'-store');
        Route::get('show/{'.Str::camel($prefixName).'}', $controllerName.'Controller@show')->name($prefixName.'-show');
        Route::get('edit/{'.Str::camel($prefixName).'}', $controllerName.'Controller@edit')->name($prefixName.'-edit');
        Route::patch('update/{'.Str::camel($prefixName).'}', $controllerName.'Controller@update')->name($prefixName.'-update');
        Route::get('destroy/{'.Str::camel($prefixName).'}', $controllerName.'Controller@destroy')->name($prefixName.'-destroy');
    });

//___19
    Route::prefix('kd-program')->group(function (){
        $prefixName = 'kd-program';
        $controllerName = Str::studly($prefixName);
        Route::get('list', $controllerName.'Controller@index')->name($prefixName.'-list');
        Route::get('create', $controllerName.'Controller@create')->name($prefixName.'-create');
        Route::post('store', $controllerName.'Controller@store')->name($prefixName.'-store');
        //Route::get('show/{'.Str::camel($prefixName).'}', $controllerName.'Controller@show')->name($prefixName.'-show');
        Route::get('show/{order}', $controllerName.'Controller@show')->name($prefixName.'-show'); //get order model
        Route::get('edit/{'.Str::camel($prefixName).'}', $controllerName.'Controller@edit')->name($prefixName.'-edit');
        Route::patch('update/{'.Str::camel($prefixName).'}', $controllerName.'Controller@update')->name($prefixName.'-update');
        Route::get('destroy/{'.Str::camel($prefixName).'}', $controllerName.'Controller@destroy')->name($prefixName.'-destroy');

        Route::get('date-wise-list', $controllerName.'Controller@dateWiseList')->name($prefixName.'-date-wise-list');
    });

//___20
    Route::prefix('order-pending')->group(function (){
        $prefixName = 'order-pending';
        $controllerName = Str::studly($prefixName);
        Route::get('list', $controllerName.'Controller@index')->name($prefixName.'-list');
        Route::get('create', $controllerName.'Controller@create')->name($prefixName.'-create');
        Route::post('store', $controllerName.'Controller@store')->name($prefixName.'-store');
        Route::get('show/{'.Str::camel($prefixName).'}', $controllerName.'Controller@show')->name($prefixName.'-show');
        Route::get('edit/{'.Str::camel($prefixName).'}', $controllerName.'Controller@edit')->name($prefixName.'-edit');
        Route::patch('update/{'.Str::camel($prefixName).'}', $controllerName.'Controller@update')->name($prefixName.'-update');
        Route::get('destroy/{'.Str::camel($prefixName).'}', $controllerName.'Controller@destroy')->name($prefixName.'-destroy');
    });


//___21
    Route::prefix('kd-parts-lib')->group(function (){
        $prefixName = 'kd-parts-lib';
        $controllerName = Str::studly($prefixName);
        Route::get('list', $controllerName.'Controller@index')->name($prefixName.'-list');
        Route::get('create', $controllerName.'Controller@create')->name($prefixName.'-create');
        Route::post('store', $controllerName.'Controller@store')->name($prefixName.'-store');
        Route::get('show/{'.Str::camel($prefixName).'}', $controllerName.'Controller@show')->name($prefixName.'-show');
        Route::get('edit/{'.Str::camel($prefixName).'}', $controllerName.'Controller@edit')->name($prefixName.'-edit');
        Route::patch('update/{'.Str::camel($prefixName).'}', $controllerName.'Controller@update')->name($prefixName.'-update');
        Route::get('destroy/{'.Str::camel($prefixName).'}', $controllerName.'Controller@destroy')->name($prefixName.'-destroy');
    });


//___22
    Route::prefix('kd-issue')->group(function (){
        $prefixName = 'kd-issue';
        $controllerName = Str::studly($prefixName);
        Route::get('list', $controllerName.'Controller@index')->name($prefixName.'-list');
        Route::get('create', $controllerName.'Controller@create')->name($prefixName.'-create');
        Route::post('store', $controllerName.'Controller@store')->name($prefixName.'-store');
        Route::get('show/{'.Str::camel($prefixName).'}', $controllerName.'Controller@show')->name($prefixName.'-show');
        Route::get('edit/{'.Str::camel($prefixName).'}', $controllerName.'Controller@edit')->name($prefixName.'-edit');
        Route::patch('update/{'.Str::camel($prefixName).'}', $controllerName.'Controller@update')->name($prefixName.'-update');
        Route::get('destroy/{'.Str::camel($prefixName).'}', $controllerName.'Controller@destroy')->name($prefixName.'-destroy');
    });


//___23
    Route::prefix('supplier')->group(function (){
        $prefixName = 'supplier';
        $controllerName = Str::studly($prefixName);
        Route::get('list', $controllerName.'Controller@index')->name($prefixName.'-list');
        Route::get('create', $controllerName.'Controller@create')->name($prefixName.'-create');
        Route::post('store', $controllerName.'Controller@store')->name($prefixName.'-store');
        Route::get('show/{'.Str::camel($prefixName).'}', $controllerName.'Controller@show')->name($prefixName.'-show');
        Route::get('edit/{'.Str::camel($prefixName).'}', $controllerName.'Controller@edit')->name($prefixName.'-edit');
        Route::patch('update/{'.Str::camel($prefixName).'}', $controllerName.'Controller@update')->name($prefixName.'-update');
        Route::get('destroy/{'.Str::camel($prefixName).'}', $controllerName.'Controller@destroy')->name($prefixName.'-destroy');
    });


//___24
    Route::prefix('booking')->group(function (){
        $prefixName = 'booking';
        $controllerName = Str::studly($prefixName);
        Route::get('list', $controllerName.'Controller@index')->name($prefixName.'-list');
        Route::get('create', $controllerName.'Controller@create')->name($prefixName.'-create');
        Route::post('store', $controllerName.'Controller@store')->name($prefixName.'-store');
        Route::get('show/{'.Str::camel($prefixName).'}', $controllerName.'Controller@show')->name($prefixName.'-show');
        Route::get('edit/{'.Str::camel($prefixName).'}', $controllerName.'Controller@edit')->name($prefixName.'-edit');
        Route::patch('update/{'.Str::camel($prefixName).'}', $controllerName.'Controller@update')->name($prefixName.'-update');
        Route::get('destroy/{'.Str::camel($prefixName).'}', $controllerName.'Controller@destroy')->name($prefixName.'-destroy');

        Route::get('print-data/{order_id}/{accessories}', $controllerName.'Controller@printData')->name($prefixName.'-print-data');
    });


//___25
    Route::prefix('accessories')->group(function (){
        $prefixName = 'accessories';
        $controllerName = Str::studly($prefixName);
        Route::get('list', $controllerName.'Controller@index')->name($prefixName.'-list');
        Route::get('create', $controllerName.'Controller@create')->name($prefixName.'-create');
        Route::post('store', $controllerName.'Controller@store')->name($prefixName.'-store');
        Route::get('show/{'.Str::camel($prefixName).'}', $controllerName.'Controller@show')->name($prefixName.'-show');
        Route::get('edit/{'.Str::camel($prefixName).'}', $controllerName.'Controller@edit')->name($prefixName.'-edit');
        Route::patch('update/{'.Str::camel($prefixName).'}', $controllerName.'Controller@update')->name($prefixName.'-update');
        Route::get('destroy/{'.Str::camel($prefixName).'}', $controllerName.'Controller@destroy')->name($prefixName.'-destroy');
    });

//___26
    Route::prefix('order-size-n-color')->group(function (){
        $prefixName = 'order-size-n-color';
        $controllerName = Str::studly($prefixName);
        Route::get('list', $controllerName.'Controller@index')->name($prefixName.'-list');
        //Route::get('create', $controllerName.'Controller@create')->name($prefixName.'-create');
        //Route::post('store', $controllerName.'Controller@store')->name($prefixName.'-store');
        Route::get('show/{'.Str::camel($prefixName).'}', $controllerName.'Controller@show')->name($prefixName.'-show');
        //Route::get('edit/{'.Str::camel($prefixName).'}', $controllerName.'Controller@edit')->name($prefixName.'-edit');
        //Route::patch('update/{'.Str::camel($prefixName).'}', $controllerName.'Controller@update')->name($prefixName.'-update');
        //Route::get('destroy/{'.Str::camel($prefixName).'}', $controllerName.'Controller@destroy')->name($prefixName.'-destroy');
    });

//___27
    Route::prefix('utility')->group(function (){
        $prefixName = 'utility';

        $methodName = request()->all() ? array_keys(request()->all())[0]: 'notSetMethode';

        $controllerName = Str::studly($prefixName);
        /*$ut = new UtilityController();

        try {
            Route::get('/', $controllerName.'Controller@'.$methodName);
        } catch (Exception $exception){
            Route::get('/', $controllerName.'Controller@methodeNotFound');
        }*/
        Route::get('/', $controllerName.'Controller@'.$methodName);
        Route::get('mail-check', $controllerName.'Controller@emailCheck')->name('mail-check');
        Route::get('orderQtySumGetFromQtyTableAndInsertIntoOrderTable', $controllerName.'Controller@orderQtySumGetFromQtyTableAndInsertIntoOrderTable');
    });


//___28
    Route::prefix('email-list')->group(function (){
        $prefixName = 'email-list';
        $controllerName = Str::studly($prefixName);
        Route::get('list', $controllerName.'Controller@index')->name($prefixName.'-list');
        Route::get('create', $controllerName.'Controller@create')->name($prefixName.'-create');
        Route::post('store', $controllerName.'Controller@store')->name($prefixName.'-store');
        Route::get('show/{'.Str::camel($prefixName).'}', $controllerName.'Controller@show')->name($prefixName.'-show');
        Route::get('edit/{'.Str::camel($prefixName).'}', $controllerName.'Controller@edit')->name($prefixName.'-edit');
        Route::patch('update/{'.Str::camel($prefixName).'}', $controllerName.'Controller@update')->name($prefixName.'-update');
        Route::get('destroy/{'.Str::camel($prefixName).'}', $controllerName.'Controller@destroy')->name($prefixName.'-destroy');

        Route::get('insert', $controllerName.'Controller@insertEmails');
    });

//___29
    Route::prefix('setting')->middleware('extraAuth')->group(function (){
        $prefixName = 'setting';
        $controllerName = Str::studly($prefixName);
        Route::match(['get', 'post'],'list', $controllerName.'Controller@index')->name($prefixName.'-list');
        Route::get('show/{'.Str::camel($prefixName).'}', $controllerName.'Controller@show')->name($prefixName.'-show');
        Route::get('edit/{'.Str::camel($prefixName).'}', $controllerName.'Controller@edit')->name($prefixName.'-edit');
        Route::patch('update/{'.Str::camel($prefixName).'}', $controllerName.'Controller@update')->name($prefixName.'-update');
        //Route::post('store', $controllerName.'Controller@store')->name($prefixName.'-store');
        //Route::get('create', $controllerName.'Controller@create')->name($prefixName.'-create');
        //Route::get('destroy/{'.Str::camel($prefixName).'}', $controllerName.'Controller@destroy')->name($prefixName.'-destroy');
    });

//___30
    Route::prefix('budget-post-cost')->group(function (){
        $prefixName = 'budget-post-cost';
        $controllerName = Str::studly($prefixName);
        Route::get('list', $controllerName.'Controller@index')->name($prefixName.'-list');
        Route::get('create', $controllerName.'Controller@create')->name($prefixName.'-create');
        Route::post('store', $controllerName.'Controller@store')->name($prefixName.'-store');
        Route::get('show/{order}', $controllerName.'Controller@show')->name($prefixName.'-show');
        Route::get('edit/{'.Str::camel($prefixName).'}', $controllerName.'Controller@edit')->name($prefixName.'-edit');
        Route::patch('update/{'.Str::camel($prefixName).'}', $controllerName.'Controller@update')->name($prefixName.'-update');
        Route::get('destroy/{'.Str::camel($prefixName).'}', $controllerName.'Controller@destroy')->name($prefixName.'-destroy');

        Route::get('export', $controllerName.'Controller@export')->name($prefixName.'-export');
        Route::get('budgetPostCostFetchModalData/{order}/{post_cost_type}', $controllerName.'Controller@budgetPostCostFetchModalData')->name($prefixName.'-fetchModalData');
        Route::put('budgetPostCostEditModalData/{budgetPostCost}', $controllerName.'Controller@budgetPostCostEditModalData')->name($prefixName.'-editModalData');
    });

//___31
    $prefixName = 'user-activity';
    $controllerName = Str::studly($prefixName);
    Route::prefix($prefixName)->group(function () use ($controllerName){
        Route::match(['get', 'post'], 'list', $controllerName.'Controller@index')->name('user-activity-list')->middleware(RoleCheckMiddleware::class.':super admin');
        Route::get('/get-ip', $controllerName.'Controller@getUserIp')->name('get-user-ip');
    });

//___32
    $prefixName = 'party';
    $controllerName = Str::studly($prefixName);
    Route::prefix($prefixName)->group(function () use ($controllerName){
        Route::get('list', $controllerName.'Controller@index')->name('party-list');
        Route::get('create', $controllerName.'Controller@create')->name('party-create');
        Route::post('store', $controllerName.'Controller@store')->name('party-store');
        Route::get('show', $controllerName.'Controller@show')->name('party-show');
        Route::get('edit/{party}', $controllerName.'Controller@edit')->name('party-edit');
        Route::patch('update/{party}', $controllerName.'Controller@update')->name('party-update');
        Route::get('destroy', $controllerName.'Controller@destroy')->name('party-destroy');
    });

    //Route::middleware('auth')->group(function (){
    Route::middleware(RoleCheckMiddleware::class.':commercial access')->group(function (){
        //___33
        $prefixName = 'commercial';
        $controllerName = Str::studly($prefixName);
        Route::prefix($prefixName)->group(function () use ($controllerName) {
            Route::get('list', $controllerName.'Controller@index')->name('commercial-list');
            Route::get('due-list', $controllerName.'Controller@dueIndex')->name('commercial-due-list');
            Route::get('create', $controllerName.'Controller@create')->name('commercial-create');
            Route::post('store', $controllerName.'Controller@store')->name('commercial-store');
            Route::get('show/{commercial}', $controllerName.'Controller@show')->name('commercial-show');
            Route::get('edit/{commercial}', $controllerName.'Controller@edit')->name('commercial-edit');
            Route::patch('update/{commercial}', $controllerName.'Controller@update')->name('commercial-update');
            Route::get('destroy/{commercial}', $controllerName.'Controller@destroy')->name('commercial-destroy');
        });

//___34
        $prefixName = 'commercial-invoice';
        $controllerName = Str::studly($prefixName);
        Route::prefix($prefixName)->group(function () use ($controllerName) {
            Route::get('list', $controllerName.'Controller@index')->name('commercial-invoice-list');
            Route::get('create', $controllerName.'Controller@create')->name('commercial-invoice-create');
            Route::post('store', $controllerName.'Controller@store')->name('commercial-invoice-store');
            Route::get('show/{commercialInvoice}', $controllerName.'Controller@show')->name('commercial-invoice-show');
            Route::get('edit/{commercialInvoice}', $controllerName.'Controller@edit')->name('commercial-invoice-edit');
            Route::patch('update/{commercialInvoice}', $controllerName.'Controller@update')->name('commercial-invoice-update');
            Route::get('destroy/{commercialInvoice}', $controllerName.'Controller@destroy')->name('commercial-invoice-destroy');
        });

        //___35
        $prefixName = 'business-gap';
        $controllerName = Str::studly($prefixName);
        Route::prefix($prefixName)->group(function () use ($controllerName) {
            Route::get('create', $controllerName.'Controller@create')->name('business-gap-create');

            Route::get('list', $controllerName.'Controller@index')->name('business-gap-list');
            Route::post('store', $controllerName.'Controller@store')->name('business-gap-store');
            Route::get('show/{commercialInvoice}', $controllerName.'Controller@show')->name('business-gap-show');
            Route::get('edit/{commercialInvoice}', $controllerName.'Controller@edit')->name('business-gap-edit');
            Route::patch('update/{commercialInvoice}', $controllerName.'Controller@update')->name('business-gap-update');
            Route::get('destroy/{commercialInvoice}', $controllerName.'Controller@destroy')->name('business-gap-destroy');
        });
    });

});



























