@extends('layouts.master')

@section('content')

    @include('layouts.partial.notice')

    <div class="main-content-container container-fluid px-4">
        <!-- Page Header -->
        <div class="page-header row no-gutters py-4">
            <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
                <span class="text-uppercase page-subtitle">Overview</span>
                <h3 class="page-title">User Activity List</h3>
            </div>
        </div>
        <!-- End Page Header -->

        <div class="row">
            <div class="col-lg-12 mb-1">
                <div class="card card-small">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item p-2">
                            <div class="row">
                                <div class="col-sm-12 col-md-12">
                                    <form>
                                        <div class="form-row">



                                            <div class="form-group col-md-1 pl-0">
                                                <select class="select2-box-manual form-control" name="orderBy">
                                                    <option value="{{ $filterArray['orderBy'] }}">{{ $filterArray['orderBy'] ?? 'Select...' }}</option>
                                                    <option value="created_at">First Login</option>
                                                    <option value="updated_at">Last Active</option>
                                                </select>
                                                <div class="filter-name">Sorting</div>
                                            </div>

                                            <div class="col-md-10">
                                                <div style="max-width: 240px" id="analytics-overview-date-range" class="input-daterange input-group input-group-md ml-auto">
                                                    <input value="{{ $filterArray['from'] }}" autocomplete="off" type="text" class="input-sm form-control" name="from" placeholder="Start Date">
                                                    <input value="{{ $filterArray['to'] }}" autocomplete="off" type="text" class="input-sm form-control" name="to" placeholder="End Date">
                                                </div>
                                            </div>

                                            <div class="form-group col-md-1">
                                                <button type="submit" class="mb-2 btn btn-primary">Search</button>
                                            </div>
                                            {{--                                            <div class="form-group col-md-2">--}}
                                            {{--                                                <input value="" name="name" type="text" class="form-control is-valid filter-input" placeholder="Name">--}}
                                            {{--                                                <div class="valid-feedback">Name</div>--}}
                                            {{--                                            </div>--}}
                                            {{--                                            <div class="form-group col-md-2">--}}
                                            {{--                                                <input value="" name="phone" type="text" class="form-control is-valid filter-input" placeholder="Phone Number">--}}
                                            {{--                                                <div class="valid-feedback">Phone</div>--}}
                                            {{--                                            </div>--}}
                                            {{--                                            <div class="form-group col-md-2">--}}
                                            {{--                                                <select name="team_id" class="form-control is-invalid">--}}
                                            {{--                                                    <option value="">Choose...</option>--}}

                                            {{--                                                </select>--}}
                                            {{--                                                <div class="invalid-feedback">Section</div>--}}
                                            {{--                                            </div>--}}
                                            {{--                                            <div class="form-group col-md-2">--}}
                                            {{--                                                <select name="role_id" class="form-control is-invalid">--}}
                                            {{--                                                    <option value="">Choose...</option>--}}

                                            {{--                                                </select>--}}
                                            {{--                                                <div class="invalid-feedback">Role</div>--}}
                                            {{--                                            </div>--}}
                                            {{--                                            <div class="form-group col-md-2">--}}
                                            {{--                                                <button type="submit" class="mb-2 btn btn-primary">Search</button>--}}

                                            {{--                                                <a href="#" class="mb-2 btn btn-dark">Reset</a>--}}
                                            {{--                                            </div>--}}


                                        </div>
                                    </form>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12 mb-3">
                <div class="card card-small">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item p-2">
                            <div class="row">
                                <div class="col-md-2">
                                    <b>Total : </b> <span>0 Found</span>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- Default Light Table -->
        <div class="row">
            <div class="col">
                <div class="card card-small mb-4">
                    <div class="card-header border-bottom">
                        <h6 class="m-0">Active Users</h6>
                    </div>
                    <div class="card-body p-0 pb-3 text-center">
                        <table class="table mb-0">
                            <thead class="bg-light">
                            <tr>
                                <th scope="col" class="border-0">Sl</th>
                                <th scope="col" class="border-0">Name</th>
                                <th scope="col" class="border-0">First Login</th>
                                <th scope="col" class="border-0">Last Login</th>
                                <th scope="col" class="border-0">Activity</th>
                                <th scope="col" class="border-0">Last Active</th>
                                <th scope="col" class="border-0">Last Route</th>
                                <th scope="col" class="border-0">All Day Routing</th>
                                {{--                                    <th scope="col" class="border-0">Action</th>--}}
                            </tr>
                            </thead>
                            <tbody>

                            @foreach($userActivitiesDateGroup as $date => $userActivities)
                                <tr>
                                    <?php $sl=0; ?>
                                    <td colspan="8" class="bg-secondary" >
                                        <h3 class="text-white font-weight-bold" style="letter-spacing: 5px">{{ Carbon::parse($date)->format('(F) d-m-Y') }}</h3>
                                    </td>
                                </tr>
                                @foreach($userActivities as $userActivity)

                                    <?php

                                    $urls = explode('|', $userActivity->all_day_routing_urls);
                                    $first_login = Carbon::parse($userActivity->first_login);
                                    $last_login = Carbon::parse($userActivity->last_login);
                                    $last_active = Carbon::parse($userActivity->last_active);

                                    $settingsOwnNetworkIpCollect = collect(explode('|', $settingsOwnNetworkIP));


                                    $ipArray = $settingsOwnNetworkIpCollect->map(function ($ff){
                                        return App\Traits\Functions::removeLastPartFromIp($ff);
                                    });


                                    //$ownNetworkIP = App\Traits\Functions::removeLastPartFromIp($settingsOwnNetworkIP);
                                    $first_login_ip = App\Traits\Functions::removeLastPartFromIp($userActivity->first_login_ip);
                                    $last_login_ip = App\Traits\Functions::removeLastPartFromIp($userActivity->last_login_ip);

                                    $fromOffice = [true, 'From Office'];
                                    $fromOutside = [false, $last_login_ip?'From Outside':null];

                                    $first_login_from = $ipArray->contains($first_login_ip) ? $fromOffice : $fromOutside;
                                    $last_login_from = $ipArray->contains($last_login_ip) ? $fromOffice : $fromOutside;


                                    $activeExplode = explode(' & ', $userActivity->activity);

                                    $activeCount = count($activeExplode);
                                    $totMnt = 0;

                                    //dd($activeExplode);

                                    if ($activeCount > 0) {
                                        foreach ($activeExplode as $item) {
                                            $twoTimes = explode('-', $item);

                                            $one = Carbon::parse($twoTimes[0]);
                                            $two = Carbon::parse(isset($twoTimes[1]) && $twoTimes[1] != '' ? $twoTimes[1] : $last_active->format('H:i:s'));

                                            //dump(isset($twoTimes[0]), isset($twoTimes[1]) && $twoTimes[1] != '');
                                            //echo $twoTimes[0].' <> '.$twoTimes[1] .' | ';

                                            $totMnt = $totMnt + $one->diffInMinutes($two);
                                        }
                                    }

                                    $totMnt = Carbon\CarbonInterval::minutes($totMnt)->cascade()->forHumans();


                                    //$first_login_from = ($first_login_ip == $ownNetworkIP) ? $fromOffice : $fromOutside;
                                    //$last_login_from = ($last_login_ip == $ownNetworkIP) ? $fromOffice : $fromOutside;

                                    //$myself = $userActivity->user->id == auth()->id(); //->isUserCanAccess(['order approve'])
                                    $orderApproveUserCheck = $userActivity->user->usersRoleCheck(['order approve'])
                                        //{{ $myself ? 'bg-secondary text-white':null }}
                                    ?>

                                    <tr class="{{ $orderApproveUserCheck ? 'bg-java text-white':null }}">
                                        <td>
                                            <span class="px-1 bg-warning rounded text-black small">Sl:{{ ++$sl }}</span>
                                            <span class="px-1 bg-info rounded text-white small">ID: {{ $userActivity->user->id }}</span>
                                            <br>
                                            <span class="rounded bg-dark text-white small">&nbsp;{{ $first_login->format('d-m-Y') }}&nbsp;</span>
                                        </td>
                                        <td>
                                            <b class="font-weight-bold">{{ $userActivity->user->name }}</b>
                                            <br>{{ $userActivity->user->email }}
                                        </td>
                                        <td>
                                            <div class="text-white rounded small {{$first_login_from[0] ? 'bg-primary':'bg-danger'}}">{{ $first_login_from[1] }}</div>

                                            <div class="rounded bg-dark text-white small mt-1">{{ $first_login->format('g:i A') }}</div>
                                        </td>
                                        <td>
                                            <div class="text-white rounded small {{$last_login_from[0] ? 'bg-primary':'bg-danger'}}">
                                                {{ $last_login_from[1] }}
                                            </div>
                                            {{--{{ $last_login->format('d-m-Y') }}--}}

                                            <div class="rounded bg-dark text-white small mt-1">{{ $last_login->format('g:i A') }}</div>

                                        </td>

                                        <td>
                                            <div class="bg-warning text-black font-weight-bold rounded small">{{ $totMnt != '1 second'?$totMnt:'Less 1 minute' }}</div>
                                            <div class="bg-secondary text-white rounded small mt-1">( {{ $activeCount }} ) {{ $last_active->longAbsoluteDiffForHumans($first_login) }}</div>
                                        </td>

                                        <td>
                                            <div>
                                                @if($last_active->diffInMinutes() >= 1)
                                                    <div class="bg-salmon text-white rounded small">
                                                        {{ $last_active->diffForHumans() }}
                                                    </div>

                                                    <div class="rounded bg-dark text-white small mt-1">{{ $last_active->format('g:i A') }}</div>
                                                @else
                                                    <div class="bg-success text-white font-weight-bold rounded small">
                                                        Active
                                                    </div>
                                                @endif
                                            </div>
                                            {{--{{ $last_active->format('d-m-Y') }}--}}
                                        </td>

                                        <td>
                                            <div class="border border-danger small rounded">
                                                {{$userActivity->last_route_url}}
                                            </div>
                                        </td>

                                        <td>
                                            <div class="overflow-auto" style="max-height: 400px">
                                                @foreach($urls as $key=>$url)
                                                    <?php
                                                    $urlExplode = explode('->', $url);
                                                    //$onlyUrl = substr($url, 0, strpos($url, '->'));
                                                    $onlyUrl = $urlExplode[0] ? $urlExplode[0]: 'Logging Out';
                                                    $time = isset($urlExplode[1]) ? $urlExplode[1]: null;
                                                    $sprint = $key + 1;
                                                    ?>
                                                    <div class=" {{$onlyUrl != 'Logging Out'? null:'text-danger font-weight-bold'}}">
                                                        <span>{{$sprint}}</span>. <span class="font-italic">{{$onlyUrl}}</span> <small class="bg-dark text-white rounded"> {{$time}} <i class="material-icons">arrow_downward</i> </small>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </td>
                                        {{--                                            <td>--}}
                                        {{--                                                <div class="btn-group btn-group-sm" role="group" aria-label="Table row actions">--}}
                                        {{--                                                    <a href="#" class="btn btn-white">--}}
                                        {{--                                                        <i class="material-icons"></i>--}}
                                        {{--                                                    </a>--}}
                                        {{--                                                </div>--}}
                                        {{--                                            </td>--}}
                                    </tr>
                                @endforeach
                            @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Default Dark Table -->
    </div>
@endsection

@section('vue-script')
    <script>
        let isTabActive = true;

        window.onfocus = function () {
            isTabActive = true;
        };

        window.onblur = function () {
            isTabActive = false;
        };

        setInterval(()=>{
            if (isTabActive) {
                location.reload();
            }
        }, 1000 * 40);
    </script>
@endsection
