@extends('layouts.master')

@section('content')

    @include('layouts.partial.notice')

    <div class="main-content-container container-fluid px-4">
        <!-- Page Header -->
        <div class="page-header row no-gutters py-4">
            <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
                <span class="text-uppercase page-subtitle">Overview</span>
                <h3 class="page-title"> {{ isset($isSetEmail)? 'Edit':'' }} {{ $pageData['pageName'] }} Profile</h3>
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Default Light Table -->
        <div class="row">

            <div class="col-lg-8">
                <div class="card card-small mb-4">
                    <div class="card-header border-bottom">
                        <h6 class="m-0">{{ $pageData['pageName'] }} Details</h6>
                    </div>
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item p-3">
                            <div class="row">
                                <div class="col">

                                    @if(isset($isSetEmail))
                                        <form action="{{ route($pageData['routeFirstName'].'-update', $isSetEmail->id) }}" method="post" enctype="multipart/form-data">
                                        @method('PATCH')
                                    @else
                                        <form action="{{ route($pageData['routeFirstName'].'-store') }}" method="post" enctype="multipart/form-data">
                                    @endif

                                        @csrf

                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label for="feFirstName"> Name</label>
                                                <input v-model="fullName" name="name" type="text" class="form-control" id="feFirstName"
                                                       placeholder="Name" value="" @if(isset($isSetEmail)) readonly @endif>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label for="feLastName">Set Name</label>


                                                @if(isset($isSetEmail))
                                                    @switch($isSetEmail->name)

                                                        @case('shipmentScheduleChartStartYear')

                                                        <hr>
                                                            <kbd>
                                                                @switch($isSetEmail->value)

                                                                    @case(-1)
                                                                        Previous Year
                                                                    @break

                                                                    @case(0)
                                                                        Present Year
                                                                    @break

                                                                    @case(1)
                                                                        Next Year
                                                                    @break

                                                                @endswitch
                                                            </kbd>
                                                            <h4>Selected Year - {{ date('Y') + $isSetEmail->value }}</h4>


                                                            <div><label class="border rounded-lg m-2 p-2"><input type="radio" name="value" value="-1" @if($isSetEmail->value == "-1") checked @endif> Previous Year</label></div>
                                                            <div><label class="border rounded-lg m-2 p-2"><input type="radio" name="value" value="0" @if($isSetEmail->value == "0") checked @endif> Present Year</label></div>
                                                            <div><label class="border rounded-lg m-2 p-2"><input type="radio" name="value" value="1" @if($isSetEmail->value == "1") checked @endif> Next Year</label></div>
                                                        <hr>

                                                        @break

                                                        @case('shipmentScheduleChartStartMonth')

                                                        <hr>
                                                            <div><label class="border rounded-lg m-2 p-2"><input type="radio" name="value" value="Jan" @if($isSetEmail->value == "Jan") checked @endif> January Month</label></div>
                                                            <div><label class="border rounded-lg m-2 p-2"><input type="radio" name="value" value="Jul" @if($isSetEmail->value == "Jul") checked @endif> July Month</label></div>
                                                        <hr>
                                                        Now:

                                                            @switch($isSetEmail->value)

                                                                @case('Jan')
                                                                    <button>January Month</button>
                                                                @break

                                                                @case('Jun')
                                                                    <button>July Month</button>
                                                                @break

                                                            @endswitch

                                                        @break

                                                        @case('erpBackgroundColor')

                                                        <hr>
                                                            <div><label class="border rounded-lg m-2 p-2"> Change System Color
                                                                    <br><input type="color" name="value" value="{{$isSetEmail->value}}" style="width: 100%;height: 80px"></label></div>
                                                        <hr>
                                                        Existing System Color: <div class="col-md-6 border rounded" style="background:{{$isSetEmail->value}}; height: 7rem"></div>

                                                        @break

                                                        @case('Debug')

                                                            <hr>
                                                            <div><label class="border rounded-lg m-2 p-2"><input type="radio" name="value" value="true" @if($isSetEmail->value == "true") checked @endif> True</label></div>
                                                            <div><label class="border rounded-lg m-2 p-2"><input type="radio" name="value" value="false" @if($isSetEmail->value == "false") checked @endif> False</label></div>
                                                            <hr>
                                                            Now:

                                                            @switch($isSetEmail->value)

                                                                @case('true')
                                                                <button>True</button>
                                                                @break

                                                                @case('false')
                                                                <button>False</button>
                                                                @break

                                                            @endswitch

                                                        @break

                                                        @default
                                                            <input name="value" type="text" class="form-control" id="feLastName"
                                                                   placeholder="value" value="{{ isset($isSetEmail->value)?$isSetEmail->value:old('value') }}">

                                                    @endswitch

                                                @else
                                                    <input name="value" type="text" class="form-control" id="feLastName"
                                                           placeholder="value" value="{{ isset($isSetEmail->value)?$isSetEmail->value:old('value') }}">
                                                @endif

                                            </div>
                                        </div>

                                        <div class="form-row">
                                            <div class="form-group col-md-4">
                                                <label>Status</label>
                                                <select name="status" class="form-control">
                                                    <option disabled selected="">Choose...</option>
                                                    <option value="active">Active</option>
                                                    <option value="inactive">Inactive</option>
                                                </select>
                                            </div>
                                        </div>



                                        <div class="form-row">
                                            <div class="form-group col-md-12">
                                                <label for="feDescription">About {{ $pageData['pageName'] }}</label>
                                                <textarea v-model="aboutUser" name="description" class="form-control" id="feDescription" rows="5">Lorem ipsum dolor sit amet consectetur adipisicing elit. Odio eaque, quidem, commodi soluta qui quae minima obcaecati quod dolorum sint alias, possimus illum assumenda eligendi cumque?</textarea>
                                            </div>
                                        </div>
                                        <button type="submit" class="btn btn-accent">Save</button>
                                    </form>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- End Default Light Table -->
    </div>
@endsection

@section('vue-script')
    <script>

        const data = {
            fullName: '{{ isset($isSetEmail) ? $isSetEmail->name:old('name') }}',
            aboutUser: '{{ isset($isSetEmail) ? $isSetEmail->description:'' }}',
        };

        const app = new Vue({
            el: '#app',
            data,
            methods: {

            },
            beforeMount(){
                //this.departmentChange()
            },
            computed: {
                //
            }

        });
    </script>
@endsection

