<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserActivitiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_activities', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id');
            $table->string('first_login_ip')->nullable();
            $table->string('last_login_ip')->nullable();
            $table->dateTime('first_login')->nullable();
            $table->dateTime('last_login')->nullable();
            $table->dateTime('last_active')->nullable();
            $table->string('last_route_url')->nullable();
            $table->text('all_day_routing_urls')->nullable();
            $table->text('activity')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_activities');
    }
}
