<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCommercialsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('commercials', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id')->nullable()->unsigned();
            $table->integer('update_user_id')->nullable()->unsigned();
            $table->integer('reporting_to_user_id')->nullable()->unsigned();
            $table->integer('status_id')->nullable()->unsigned();//process_id
            $table->integer('prev_status_id')->nullable()->unsigned();

            $table->string('item_name')->nullable();
            $table->integer('party_id')->unsigned();
            $table->string('pi_number')->nullable();
            $table->string('lc_number')->nullable();
            $table->date('lc_date')->nullable();
            $table->enum('lc_purpose', ['ForOrder', 'ForFactoryCash', 'For_B2B_Adjustment'])->default('ForOrder');
            $table->integer('lc_value')->nullable();
            $table->date('bank_acceptance_date')->nullable();
            $table->integer('bank_acceptance_amount')->nullable();
            $table->integer('tenor')->unsigned();
            $table->date('payment_date')->nullable();
            $table->enum('payment_status', ['PaymentDue', 'Paid', 'PartialPaid'])->default('PaymentDue');
            $table->integer('payment_amount')->nullable();
            $table->text('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('commercials');
    }
}
