<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Hash;

class ExtraAuthenticate
{
    /**
     * Get the path the user should be redirected to when they are not authenticated.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return string
     */
    public function handle($request, Closure $next)
    {
        $authUser = auth()->user();

        if($authUser->isUserCanAccess(['order approve'])){

            $sec = 60;
            $min = 30;
            $gotMinute = time() + ($sec * $min);

            if ($request->filled('password')) {
                if (Hash::check($request->password, $authUser->password)) {
                    session(['timer_for_user_activity_access_session' => $gotMinute]);
                } else {
                    return back()->with(['fail'=>'Password mismatch !']); //Password mismatch
                }
            }

            if (session('timer_for_user_activity_access_session') > time()) {
                session(['timer_for_user_activity_access_session' => $gotMinute]);
                return $next($request);
            } else {
                session(['timer_for_user_activity_access_session' => 0]);
            }

            return response(view('layouts.tools.extraLogin'));

        }

        return back()->with(['fail'=>'Unauthorised action! please inform your superior.']);

    }
}
