<?php

namespace App\Http\Controllers;

use App\Setting;
use App\User;
use App\UserActivity;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Route;

class UserActivityController extends Controller
{
    public function getUserIp(Request $request)
    {
        //$compact = compact('user_ip');
        //return view('getIP', $compact);
        //return $request->header('user-ip');

        $user_ip = $request->header('user-ip');
        session(['user_ip'=>$user_ip]);
        $this->store(Auth::user());
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $orderBy = 'updated_at';
        $checkHasColumn = $request['orderBy'] == 'updated_at' || $request['orderBy'] == 'created_at';
        if ($request->filled('orderBy') && $checkHasColumn) {
            $orderBy = $request['orderBy'];
        }

        $filterArray = [
            'from' => $request->get('from') ?? null,
            'to' => $request->get('to') ?? null,
            'orderBy' => $orderBy == 'updated_at' ? 'Last Active' : 'First Login',
        ];


        $query = UserActivity::query();
        $settingsOwnNetworkIP = Setting::where('name', 'Own Network IP')->first()->value;

        //$beforeDays = Carbon::now()->addDays($days)->format('Y-m-d');
        $today1dayAdd = Carbon::parse($request->get('to'))->addDays(1)->format('Y-m-d');

        if ($request->filled('from') && $request->filled('to')) {
            $query = $query->whereBetween('created_at', [$request->get('from'), $today1dayAdd]);
        } else {
            $query = $query->whereDate('created_at', date('Y-m-d'));
        }

        $userActivitiesDateGroup = $query->orderBy($orderBy, 'desc')->get()->groupBy(function ($act){
            return $act->created_at->format('Y-m-d');
        });


        $compact = compact(
            'userActivitiesDateGroup',
            'settingsOwnNetworkIP',
            'filterArray'
        );
        return view('userActivity.index', $compact);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(User $user = null)
    {
        $loginAttempt = false;

        if ($user) {

            $loginAttempt = true;

        } else {
            if (Auth::check()) {
                $user = Auth::user();
            } else {
                return null;
            }
        }

        $user_id = (integer) $user->id;
        $currentRouteName = Route::current()->getName();

        $userActivity = new UserActivity();

        $todayUserActivitySingle = UserActivity
            ::where('user_id', $user_id)
            ->whereDate('created_at', date('Y-m-d'))
            ->first();

        //dd($todayUserActivitySingle);


        if ($todayUserActivitySingle) {

            $all_day_routing_urls = explode('|', $todayUserActivitySingle->all_day_routing_urls);
            $totalUrls = count($all_day_routing_urls);

            $separator = $todayUserActivitySingle->all_day_routing_urls ? '->' . Carbon::now()->format('h:iA') . '|' : '';

            $lastUrl = $all_day_routing_urls[$totalUrls - 1];

            //if ($currentRouteName != 'user-activity-list') {
                if ($lastUrl != $currentRouteName) {
                    $todayUserActivitySingle->all_day_routing_urls = $todayUserActivitySingle->all_day_routing_urls .$separator. $currentRouteName;
                }
            //}

            $last_active = Carbon::parse($todayUserActivitySingle->last_active);

            if (!$todayUserActivitySingle->activity) {
                $todayUserActivitySingle->activity = Carbon::parse($todayUserActivitySingle->first_login)->format('H:i:s') . '-';
            }

            if ($last_active->diffInMinutes() >= 5) {
                $todayUserActivitySingle->activity = $todayUserActivitySingle->activity . $last_active->format('H:i:s') . ' & ' . Carbon::now()->format('H:i:s') . '-';
            }


            $userActivity = $todayUserActivitySingle;
        } else {
            session(['user_ip'=>false]);
        }

        $userActivity->user_id = $user->id;
        $userActivity->last_active = Carbon::now();

        if (!$userActivity->first_login) {
            $userActivity->first_login = Carbon::now();
        }

        $user_ip = session('user_ip');

        if (!$userActivity->first_login_ip) {
            //session(['user_ip'=>false]);
            $userActivity->first_login_ip = $user_ip;
            $userActivity->last_login_ip = $user_ip;
        }

        if ($loginAttempt) {
            $userActivity->last_login = Carbon::now();
            if ($user_ip) {
                //dd('ddd');
                $userActivity->last_login_ip = $user_ip;
            }
        }

        //if ($currentRouteName != 'user-activity-list') {
            $userActivity->last_route_url = $currentRouteName;
        //}


        $userActivity->save();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\UserActivity  $userActivity
     * @return \Illuminate\Http\Response
     */
    public function show(UserActivity $userActivity)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\UserActivity  $userActivity
     * @return \Illuminate\Http\Response
     */
    public function edit(UserActivity $userActivity)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\UserActivity  $userActivity
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, UserActivity $userActivity)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\UserActivity  $userActivity
     * @return \Illuminate\Http\Response
     */
    public function destroy(UserActivity $userActivity)
    {
        //
    }
}
