<?php

namespace App\Http\Controllers;

use App\Setting, Auth, Image;
use App\User;
use Illuminate\Http\Request;

class SettingController extends Controller
{
    public $_profile_pic_folder;
    public $pageData = [];
    public $pageName;
    public $viewFolder;
    public $defaultSettings = [];

    public function __construct()
    {
        $this->defaultSettings = collect([
            [
                'name' => 'companyName',
                'value'=> 'ERP Software'
            ],
            [
                'name' => 'shipmentScheduleChartStartYear',
                'value'=> '0'
            ],
            [
                'name' => 'shipmentScheduleChartStartMonth',
                'value'=> 'Jan'
            ],
            [
                'name' => 'erpBackgroundColor',
                'value'=> '#ffffff'
            ],
            [
                'name' => 'Default Year',
                'value'=> date('Y')
            ],
            [
                'name' => 'Own Network IP',
                'value'=> '1.1.1.1'
            ],
            [
                'name' => 'Debug',
                'value'=> 'true'
            ],
        ]);

        //dd($this->defaultSettings->pluck('name')->toArray());
        //dd($this->defaultSettings->where('name', 'erpBackgroundColor2')->first());

        $panelName = strtolower(str_replace('Controller', '',(new \ReflectionClass($this))->getShortName()));
        $this->pageName = $panelName;
        $this->viewFolder = $panelName;
        $this->_profile_pic_folder= 'profile-pic/'.$panelName;

        //echo strtolower(str_replace('Controller', '',(new \ReflectionClass($this))->getShortName()));
        $this->pageData = [
            'no' => 0,
            'pageName' => 'Setting',
            'routeFirstName' => 'setting',
            'ignoreColsInExport' => '[0]',
        ];

        //dd($this->pageData);

        view()->share('pageData', $this->pageData);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $this->autoDefaultSettingsCreator();


        $query = Setting::query();
        $name = null;
        $unit_name = null;

        $per_page=(int)$request->input('per_page');

        if($per_page<=0)
        {
            $per_page = 20;
        }

        if($request->filled('name')) {
            $query = $query->where('name', 'like', '%'.$request->get('name').'%');
            $name = $request->get('name');
        }
        if($request->filled('unit_name')) {
            $query = $query->where('unit_name', 'like', '%' . $request->get('unit_name') . '%');
            $unit_name = $request->get('unit_name');
        }

        $mainDatas = $query->get();

        $compact = compact(
            'name',
            'unit_name',
            'per_page',
            'mainDatas'
        );

        return view('setting.index', $compact)
            ->withCount($query->get()->count())
            ;
    }

    public function autoDefaultSettingsCreator()
    {
        $defaultSettingsInDB = Setting::pluck('name')->toArray(); // collect default Settings name from DB
        $newDefaultSettings = array_diff($this->defaultSettings->pluck('name')->toArray(), $defaultSettingsInDB);

        //dd($newDefaultSettings);

        if (!empty($newDefaultSettings)) {
            foreach ($newDefaultSettings as $newDefaultSetting) {
                $insertDefaultSetting = new Setting();

                $settingObj = $this->defaultSettings->where('name', $newDefaultSetting)->first(); // from local collection data

                $insertDefaultSetting->name = $settingObj['name'];
                $insertDefaultSetting->value = $settingObj['value'];
                $insertDefaultSetting->save();
            }
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view($this->viewFolder.'.create')
            ->withUsers(User::all())
            ;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //dd($request->all());
        $loggedUseruser = Auth::user();
        if(!$loggedUseruser->can_manage_user())
        {
            return redirect()->back()->with(['fail'=>'Unauthorized Access.']);
        }
        //$team_ids = $loggedUseruser->role->managed_user_team_ids();
        //dd($team_ids);
        $request->validate([
            'name' => 'required|max:255|unique:settings',
            'value' => 'required|max:255|unique:settings',
        ]);

        $mainData = new Setting();
        $mainData->value = $request['value'];
        $mainData->name = $request['name'];
        if ($request->has('status')) {
            $mainData->status = $request['status'];
        }

        $mainData->description = $request['description'];


        $mainData->save();
        return redirect()->route($this->pageData['routeFirstName'].'-list')->with(['success'=>$this->pageData['pageName'].' Created Successfully.']);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function show(Setting $setting)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function edit(Setting $setting)
    {
        return $this->create()
            ->withIsSetEmail($setting)
            ;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Setting $setting)
    {
        //dd($request->all());
        $loggedUseruser = Auth::user();
        if(!$loggedUseruser->can_manage_user())
        {
            return redirect()->back()->with(['fail'=>'Unauthorized Access.']);
        }
        //$team_ids = $loggedUseruser->role->managed_user_team_ids();
        //dd($team_ids);
        $request->validate([
            'value' => 'required|max:255|unique:settings',
        ]);

        $mainData = $setting;
        $mainData->value = $request['value'];
        if ($request->has('status')) {
            $mainData->status = $request['status'];
        }

        $mainData->description = $request['description'];


        $mainData->save();
        return redirect()->route($this->pageData['routeFirstName'].'-list')->with(['success'=>$this->pageData['pageName'].' updated Successfully.']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function destroy(Setting $setting)
    {
        //$setting->delete();

        return redirect()->route($this->pageData['routeFirstName'].'-list')->with(['success'=>$this->pageData['pageName'].' delete Successfully.']);
    }
}
