<?php

namespace App\Http\Controllers;

use App\Accessories;
use Auth;
use App\Booking;
use App\Order;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class BookingController extends Controller
{
    /*public $_profile_pic_folder = 'profile-pic/booking';
    public $pageData = [];
    public $pageName = 'booking';
    public $viewFolder = 'booking';*/

    public $_profile_pic_folder;
    public $pageData = [];
    public $pageName;
    public $viewFolder;

    public function __construct()
    {
        $panelName = strtolower(str_replace('Controller', '',(new \ReflectionClass($this))->getShortName()));
        $this->pageName = $panelName;
        $this->viewFolder = $panelName;
        $this->_profile_pic_folder= 'profile-pic/'.$panelName;

        $this->pageData = [
            'no' => 0,
            'pageName' => Str::studly($this->pageName),
            'routeFirstName' => $this->pageName,
            'ignoreColsInExport' => '[0]',
        ];

        view()->share('pageData', $this->pageData);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        /*$msg = "New order place in Order List \n";

        $msg .= "\n \n ERROR";
        $msg .= "\n \n ERROR";
        $msg .= "\n \n ERROR";

        $headers = "From: newrmgerp@gmail.com";
        // send email
        mail("biplob@westapparelltd.com","My subject",$msg,$headers);
        mail("tanvir603@gmail.com","My subject",$msg,$headers);*/


        //dd($request->all());
        $query = Order::query()->where('history_type', 'Running');
        $query = $query->with(['budget:order_id,cm', 'buyer', 'quantity', 'status', 'shipment']);
        $id = $request->get('id') ?? null;
        $buyer_id = $request->get('buyer_id') ?? null;
        $name = $request->get('name') ?? null;
        $style = $request->get('style') ?? null;
        $style_desc = $request->get('style_desc') ?? null;
        $statuses = $request->get('statuses') ?? null;
        $category_id = $request->get('category_id') ?? null;
        $sub_category_id = $request->get('sub_category_id') ?? null;
        $from = $request->get('from') ?? null;
        $to = $request->get('to') ?? null;

        //$date_type = $request->get('date_type') ?? null;

        $per_page=(int)$request->input('per_page');

        if($per_page<=0)
        {
            $per_page = 20;
        }

        if($request->filled('id')) {
            $query = $query->where('id', $request->get('id') );
            //$phone = $request->get('phone');
        }
        if($request->filled('buyer_id')) {
            $query = $query->where('buyer_id', $request->get('buyer_id') );
            //$phone = $request->get('phone');
        }
        if($request->filled('name')) {
            $query = $query->where('name', $request->get('name') );
            //$phone = $request->get('phone');
        }
        if($request->filled('style')) {
            $query = $query->where('style', $request->get('style') );
            //$phone = $request->get('phone');
        }
        if($request->filled('style_desc')) {
            $query = $query->where('style_desc', $request->get('style_desc') );
            //$phone = $request->get('phone');
        }
        if($request->filled('statuses')) {
            $query = $query->where('statuses', $request->get('statuses') );
            //$phone = $request->get('phone');
        }
        if($request->filled('sub_category_id')) {
            $query = $query->where('sub_category_id', $request->get('sub_category_id') );
            //$phone = $request->get('phone');
        }
        if($request->filled('from') && $request->filled('to')) {
            $query = $query->whereBetween($request->get('date_type'), [$request->get('from'), $request->get('to')] );
            //$phone = $request->get('phone');
        }


        /*last 10 days*/
        if(!$request->has('data_filtering')) {
            $today = date('Y-m-d');
            $hasDays = date('Y-m-d', strtotime('10 days', strtotime($today)));

            $query = $query->whereBetween('date_of_ship', [$today, $hasDays]);
        }
        /*end last 10 days*/


        //$orders = $query->get();
        $orders = $query->orderBy('date_of_ship')->get();
        //dd($orders);
        //$orders->setpath($request->fullUrl()."&per_page=$per_page");

        $compact = compact(
            'id',
            'buyer_id',
            'name',
            'style',
            'style_desc',
            'statuses',
            'category_id',
            'sub_category_id',
            'from',
            'to',
            'per_page',
            'orders'
        );

        return view($this->viewFolder.'.index', $compact)
            ->withCount($query->get()->count())
            ;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view($this->viewFolder.'.create')
            ->withUsers(User::all())
            ;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $loggedUser = Auth::user();

        //dd($request->all());

        foreach ($request->get('order_ids') as $index => $order_id) {
            $booking = new Booking();
            $booking->order_id = $order_id;
            $booking->user_id = $loggedUser->id;
            $booking->supplier_id = $request['supplier_id'];
            $booking->accessories_id = $request['accessories_id'];
            $booking->color_id = $request['color_ids'][$index];

            $booking->consumption = $request['consumptions'][$index];
            $booking->count = $request['counts'][$index];
            $booking->item_size = $request['item_sizes'][$index];
            $booking->wastage = $request['wastages'][$index];
            $booking->unit_price = $request['unit_prices'][$index];
            $booking->remarks = $request['remarks'][$index];
            $booking->save();
        }

        return redirect()->back()->with(['success'=>$this->pageData['pageName'].' Save Successfully.']);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Booking  $booking
     * @return \Illuminate\Http\Response
     */
    public function show($order_id)
    {
        $items = Booking::where('order_id', $order_id)
            ->with('accessories')
            ->get()
            ;

        $accessoriesObjects = [];
        foreach ($items as $item) {
            $accessoriesObjects[] = $item->accessories;
        }
        return array_unique($accessoriesObjects);
    }

    public function printData($order_id, $accessories_id)
    {
        $order = Order::find($order_id);
        $accessories = Accessories::find($accessories_id);
        $items = Booking::where('order_id', $order_id)
            //->with('accessories')
            ->get()
        ;

        if (!$accessories) {
            $accessories = new \stdClass();
            $accessories->id = 0;
            $accessories->name = 'all';
        }


        //dd($accessories);


        $compact = compact(
            'order',
            'items',
            'accessories'
        );

        return view($this->viewFolder.'.print.index', $compact);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Booking  $booking
     * @return \Illuminate\Http\Response
     */
    public function edit(Booking $booking)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Booking  $booking
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Booking $booking)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Booking  $booking
     * @return \Illuminate\Http\Response
     */
    public function destroy(Booking $booking)
    {
        //
    }
}
